/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVT;

public class RunAllFVTOn2Servers {
    public static void main(String[] args) {
        HttpHelper.noStrictSSL();
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            RunAllFVT.performFVT(url, "cocoView1", "garygeeke");
            RunAllFVT.performFVT(url, "cocoView2", "garygeeke");
            System.out.println("FVT ran successfully");
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static String getUrl(String[] args) throws IOException {
        String url = null;
        if (args.length > 0) {
            url = args[0];
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter a URL. Press enter to get the default (https://localhost:9443.)):");
            url = br.readLine();
            if (url.length() == 0) {
                url = "https://localhost:9443";
            }
        }
        return url;
    }
}

