/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.glossarys;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryParams;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResponseParameterization;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.glossarys.GlossaryAuthorViewGlossary;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class GlossaryAuthorViewGlossaryClient
implements GlossaryAuthorViewGlossary,
ResponseParameterization<Glossary> {
    private static final String BASE_URL = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries";
    protected final GlossaryAuthorViewRestClient client;

    public GlossaryAuthorViewGlossaryClient(GlossaryAuthorViewRestClient client) {
        this.client = client;
    }

    public GlossaryAuthorViewGlossaryClient(String serverName, String url) throws InvalidParameterException {
        this.client = new GlossaryAuthorViewRestClient(serverName, url);
    }

    public List<Glossary> find(String userId, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.find(userId, findRequest, false, true);
    }

    public List<Glossary> find(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.find(userId, findRequest, exactValue, ignoreCase, null);
    }

    public List<Glossary> find(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Integer maximumPageSizeOnRestCall) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GenericResponse response = this.client.findRESTCall(userId, this.getMethodInfo("find"), BASE_URL, this.getParameterizedType(), findRequest, exactValue, ignoreCase, maximumPageSizeOnRestCall);
        return response.results();
    }

    public Class<? extends GenericResponse> responseType() {
        return SubjectAreaOMASAPIResponse.class;
    }

    @Override
    public Glossary create(String userId, Glossary glossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GenericResponse<Glossary> response = this.client.postRESTCall(userId, this.getMethodInfo("create"), BASE_URL, this.getParameterizedType(), glossary);
        return (Glossary)response.head().get();
    }

    @Override
    public Glossary update(String userId, String guid, Glossary glossary, boolean isReplace) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (isReplace) {
            params.put("isReplace", "true");
        } else {
            params.put("isReplace", "false");
        }
        GenericResponse response = this.client.putRESTCall(userId, guid, this.getMethodInfo("create"), BASE_URL, this.getParameterizedType(), glossary, params);
        return (Glossary)response.head().get();
    }

    @Override
    public Glossary getByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries/%s";
        GenericResponse response = this.client.getByGUIdRESTCall(userId, guid, this.getMethodInfo("getByGUID"), this.getParameterizedType(), urlTemplate);
        return (Glossary)response.head().get();
    }

    @Override
    public void delete(String userId, String guid) throws PropertyServerException {
        this.client.delRESTCall(userId, this.getParameterizedType(), this.getMethodInfo("delete"), BASE_URL, guid);
    }

    @Override
    public Glossary restore(String userId, String guid) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries/%s";
        GenericResponse<String> response = this.client.postRESTCall(userId, this.getMethodInfo("restore"), urnTemplate, this.getParameterizedType(), guid);
        return (Glossary)response.head().get();
    }

    @Override
    public List<Relationship> getAllRelationships(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Relationship.class});
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries/%s/relationships";
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, this.getMethodInfo("getAllRelationships"), type, urnTemplate);
        return response.results();
    }

    @Override
    public List<Category> getCategories(String userId, String guid, FindRequest findRequest, boolean onlyTop) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries/" + guid + "/categories";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("exactValue", "false");
        params.put("ignoreCase", "true");
        params.put("onlyTop", String.valueOf(onlyTop));
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, this.getMethodInfo("getCategories"), type, urnTemplate, findRequest, (Integer)0, params);
        return response.results();
    }

    @Override
    public List<Category> getCategories(String userId, String guid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries/" + guid + "/categories";
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse response = this.client.findRESTCall(userId, this.getMethodInfo("getCategories"), urnTemplate, type, findRequest, false, true, 0);
        return response.results();
    }

    @Override
    public List<Term> getTerms(String userId, String guid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getTerms(userId, guid, findRequest, false, true, null);
    }

    @Override
    public List<Term> createTerms(String userId, String guid, Term[] termArray) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Term.class});
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries/%s/terms";
        ResolvableType resolvableType1 = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (ResolvableType[])new ResolvableType[]{resolvableType});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType1.getType());
        SubjectAreaOMASAPIResponse<SubjectAreaOMASAPIResponse<Term>> completeResponse = this.client.postRESTCallArr(userId, this.getMethodInfo("createMultipleTerms"), urnTemplate, guid, (ParameterizedTypeReference<SubjectAreaOMASAPIResponse<SubjectAreaOMASAPIResponse<Term>>>)type, termArray);
        List temp = completeResponse.results();
        ArrayList<Term> termList = new ArrayList<Term>();
        for (GenericResponse resp : temp) {
            if (resp.results().size() <= 0) continue;
            termList.add((Term)resp.results().get(0));
        }
        return termList;
    }

    public List<Term> getTerms(String userId, String guid, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Integer maximumPageSizeOnRestCall) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Term.class});
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/glossaries/%s/terms";
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        QueryParams queryParams = new QueryParams().setExactValue(exactValue).setIgnoreCase(ignoreCase);
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, this.getMethodInfo("getTerms"), type, urnTemplate, findRequest, maximumPageSizeOnRestCall, queryParams);
        return response.results();
    }

    protected String getMethodInfo(String methodName) {
        return methodName + " for " + this.resultType().getSimpleName();
    }
}

