/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.CategoryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.FVTUtils;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryHierarchyFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for category hierarchy FVT";
    private static final String DEFAULT_TEST_CATEGORY_NAME_BASE = "Test hierarchy category ";
    private static final int WIDTH = 3;
    private static final int DEPTH = 4;
    private static int depth_counter = 0;
    private GlossaryFVT glossaryFVT = null;
    private CategoryFVT categoryFVT = null;
    private static Logger log = LoggerFactory.getLogger(CategoryHierarchyFVT.class);

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            CategoryHierarchyFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            log.error("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runWith2Servers(String url) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryAuthorFVTCheckedException {
        CategoryHierarchyFVT.runIt(url, "cocoView1", "garygeeke");
        CategoryHierarchyFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public CategoryHierarchyFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.categoryFVT = new CategoryFVT(url, serverName, userId);
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
    }

    public static void runIt(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        try {
            System.out.println("CategoryHierarchyFVT runIt started");
            CategoryHierarchyFVT fvt = new CategoryHierarchyFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemaining();
            System.out.println("CategoryHierarchyFVT runIt stopped");
        }
        catch (Exception error) {
            log.error("The FVT Encountered an Exception", (Throwable)error);
            throw error;
        }
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("Create a glossary");
        }
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        FVTUtils.validateNode((Node)glossary);
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        if (log.isDebugEnabled()) {
            log.debug("Create category hierarchy");
        }
        Set<Category> categories = this.createTopCategories(glossaryGuid);
        while (depth_counter < 4) {
            ++depth_counter;
            Set<Category> childrenCategories = new HashSet<Category>();
            for (Category category : categories) {
                FVTUtils.validateNode((Node)category);
                childrenCategories = this.createChildrenCategories(category, glossaryGuid);
            }
            categories = childrenCategories;
        }
    }

    private Set<Category> createTopCategories(String glossaryGuid) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HashSet<Category> categories = new HashSet<Category>();
        for (int width_counter = 0; width_counter < 3; ++width_counter) {
            String categoryName = CategoryHierarchyFVT.createName(0, width_counter);
            Category category = this.categoryFVT.createCategoryWithGlossaryGuid(categoryName, glossaryGuid);
            FVTUtils.validateNode((Node)category);
            if (log.isDebugEnabled()) {
                log.debug("Created category with name  " + categoryName + " with no parent");
            }
            categories.add(category);
        }
        return categories;
    }

    private static String createName(int depth, int width) {
        return "Test hierarchy category d" + depth + "w" + width;
    }

    private Set<Category> createChildrenCategories(Category parent, String glossaryGuid) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HashSet<Category> categories = new HashSet<Category>();
        for (int width_counter = 0; width_counter < 3; ++width_counter) {
            String categoryName = CategoryHierarchyFVT.createName(depth_counter, width_counter);
            Category category = this.categoryFVT.createCategoryWithParentGlossary(categoryName, parent, glossaryGuid);
            FVTUtils.validateNode((Node)category);
            if (log.isDebugEnabled()) {
                log.debug("Created category with name  " + categoryName + " with parent " + parent.getName());
            }
            categories.add(category);
        }
        return categories;
    }

    void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        this.categoryFVT.deleteRemainingCategories();
        this.glossaryFVT.deleteRemainingGlossaries();
    }
}

