/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;

public class FVTUtils {
    public static void validateNode(Node node) throws GlossaryAuthorFVTCheckedException {
        if (node == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected node to exist,  ");
        }
        if (node.getName() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected node to have a name,  ");
        }
        if (node.getSystemAttributes() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + node.getName() + "'s system attributes to exist,  ");
        }
        if (node.getSystemAttributes().getGUID() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + node.getName() + "'s userId  to exist,  ");
        }
    }

    public static void validateRelationship(Relationship relationship) throws GlossaryAuthorFVTCheckedException {
        if (relationship == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected relationship to exist,  ");
        }
        if (relationship.getName() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected relationship to have a name,  ");
        }
        if (relationship.getName().equals("Unknown")) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected relationship to have a known name,  ");
        }
        if (relationship.getSystemAttributes() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + "'s system attributes to exist,  ");
        }
        if (relationship.getSystemAttributes().getGUID() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + "'s userId  to exist,  ");
        }
        if (relationship.isReadOnly()) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + " not to be readonly");
        }
        if (relationship.getEnd1() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + " end1 to have a value");
        }
        if (relationship.getEnd1().getNodeQualifiedName() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + " end1 qualified name to have a value");
        }
        if (relationship.getEnd1().getNodeGuid() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + " end1 guid to have a value");
        }
        if (relationship.getEnd2() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + " end2 to have a value");
        }
        if (relationship.getEnd2().getNodeQualifiedName() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + " end2 qualified name to have a value");
        }
        if (relationship.getEnd2().getNodeGuid() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + relationship.getName() + " end2 guid to have a value");
        }
    }

    public static void checkEnds(Relationship relationship1, Relationship relationship2, String relationshipName, String operation) throws GlossaryAuthorFVTCheckedException {
        if (!relationship1.getEnd1().getNodeGuid().equals(relationship2.getEnd1().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: update end 1 not as expected for relationship " + relationshipName + " operation " + operation);
        }
        if (!relationship1.getEnd2().getNodeGuid().equals(relationship2.getEnd2().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: update end 2 not as expected for relationship " + relationshipName + " operation " + operation);
        }
    }
}

