/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client;

import java.util.Collection;
import java.util.Map;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryBuilder;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryParams;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryUtils;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;

public class GlossaryAuthorViewRestClient
extends FFDCRESTClient {
    private static final Logger log = LoggerFactory.getLogger(GlossaryAuthorViewRestClient.class);
    protected static final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final String serverName;
    private final String serverPlatformURLRoot;

    public GlossaryAuthorViewRestClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
    }

    public <T> GenericResponse<T> getByIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        GenericResponse completeResponse = null;
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        completeResponse = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> getByGUIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        GenericResponse completeResponse = null;
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
        completeResponse = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> postRESTCall(String userId, String methodName, String urlTemplate, ParameterizedTypeReference<GenericResponse<T>> type, String guid) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        GenericResponse completeResponse = null;
        String expandedURL = String.format(this.serverPlatformURLRoot + urlTemplate, this.serverName, userId, guid);
        completeResponse = (GenericResponse)this.callPostRESTCall(methodName, type, expandedURL, null, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> postRESTCall(String userId, String create, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> parameterizedType, T t) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + create + ",userId=" + userId);
        }
        GenericResponse completeResponse = null;
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId);
        completeResponse = (GenericResponse)this.callPostRESTCall(create, parameterizedType, expandedURL, t, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(create, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== Glossary successful method : " + create + ",userId=" + userId);
        }
        return completeResponse;
    }

    public SubjectAreaOMASAPIResponse<SubjectAreaOMASAPIResponse<Term>> postRESTCallArr(String userId, String methodName, String urlTemplate, String guid, ParameterizedTypeReference<SubjectAreaOMASAPIResponse<SubjectAreaOMASAPIResponse<Term>>> type, Term[] termArray) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urlTemplate, this.serverName, userId, guid);
        if (log.isDebugEnabled()) {
            log.debug("<== Glossary successful method : " + methodName + ",userId=" + userId);
        }
        SubjectAreaOMASAPIResponse completeResponse = (SubjectAreaOMASAPIResponse)this.callPostRESTCall(methodName, type, expandedURL, termArray, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> putRESTCall(String userId, String guid, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> parameterizedType, Glossary glossary, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate + "/%s", this.serverName, userId, guid);
        if (log.isDebugEnabled()) {
            log.debug("<== Glossary successful method : " + methodName + ",userId=" + userId);
        }
        return (GenericResponse)this.callPutRESTCall(methodName, parameterizedType, expandedURL, glossary, params);
    }

    public <T> GenericResponse<T> putRESTCall(String userId, String guid, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> parameterizedType, Category category, Object ... params) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate + "/%s", this.serverName, userId, guid);
        if (log.isDebugEnabled()) {
            log.debug("<== Glossary successful method : " + methodName + ",userId=" + userId);
        }
        return (GenericResponse)this.callPutRESTCall(methodName, parameterizedType, expandedURL, category, params);
    }

    public <T> GenericResponse<T> putRESTCall(String userId, String guid, String methodName, String urlTemplate, ParameterizedTypeReference<GenericResponse<T>> parameterizedType, T t) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urlTemplate, this.serverName, userId, guid);
        if (log.isDebugEnabled()) {
            log.debug("<== Glossary successful method : " + methodName + ",userId=" + userId);
        }
        return (GenericResponse)this.callPutRESTCall(methodName, parameterizedType, expandedURL, t, new Object[]{true});
    }

    public <T> GenericResponse<T> delRESTCall(String userId, ParameterizedTypeReference<GenericResponse<T>> parameterizedType, String methodName, String urnTemplate, String guid) throws PropertyServerException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guId=" + guid);
        }
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate + "/%s", this.serverName, userId, guid);
        if (log.isDebugEnabled()) {
            log.debug("<== Glossary successful method : " + methodName + ",userId=" + userId + ",guId=" + guid);
        }
        return (GenericResponse)this.callDeleteRESTCall(methodName, parameterizedType, expandedURL, new Object[0]);
    }

    public QueryBuilder createFindQuery(String methodName, FindRequest findRequest) throws InvalidParameterException {
        return this.createFindQuery(methodName, findRequest, false, true);
    }

    public QueryBuilder createFindQuery(String methodName, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException {
        String property;
        QueryBuilder queryBuilder = new QueryBuilder();
        SequencingOrder sequencingOrder = findRequest.getSequencingOrder();
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        String sequencingOrderName = QueryUtils.encodeParams((String)methodName, (String)"sequencingOrder", (String)sequencingOrder.name());
        queryBuilder.addParam((Object)"sequencingOrder", (Object)sequencingOrderName);
        Integer pageSize = findRequest.getPageSize();
        if (pageSize != null) {
            queryBuilder.addParam((Object)"pageSize", (Object)pageSize);
        }
        queryBuilder.addParam((Object)"startingFrom", (Object)findRequest.getStartingFrom());
        String searchCriteria = findRequest.getSearchCriteria();
        if (searchCriteria != null) {
            searchCriteria = QueryUtils.encodeParams((String)methodName, (String)"searchCriteria", (String)searchCriteria);
            queryBuilder.addParam((Object)"searchCriteria", (Object)searchCriteria);
        }
        if ((property = findRequest.getSequencingProperty()) != null) {
            property = QueryUtils.encodeParams((String)methodName, (String)"sequencingProperty", (String)property);
            queryBuilder.addParam((Object)"sequencingProperty", (Object)property);
        }
        queryBuilder.addParam((Object)"exactValue", (Object)exactValue);
        queryBuilder.addParam((Object)"ignoreCase", (Object)ignoreCase);
        return queryBuilder;
    }

    public QueryBuilder createFindQuery(String methodName, FindRequest findRequest, QueryParams queryParams) throws InvalidParameterException {
        String property;
        QueryBuilder queryBuilder = new QueryBuilder();
        SequencingOrder sequencingOrder = findRequest.getSequencingOrder();
        if (sequencingOrder == null) {
            sequencingOrder = SequencingOrder.ANY;
        }
        String sequencingOrderName = QueryUtils.encodeParams((String)methodName, (String)"sequencingOrder", (String)sequencingOrder.name());
        queryBuilder.addParam((Object)"sequencingOrder", (Object)sequencingOrderName);
        Integer pageSize = findRequest.getPageSize();
        if (pageSize != null) {
            queryBuilder.addParam((Object)"pageSize", (Object)pageSize);
        }
        queryBuilder.addParam((Object)"startingFrom", (Object)findRequest.getStartingFrom());
        String searchCriteria = findRequest.getSearchCriteria();
        if (searchCriteria != null) {
            searchCriteria = QueryUtils.encodeParams((String)methodName, (String)"searchCriteria", (String)searchCriteria);
            queryBuilder.addParam((Object)"searchCriteria", (Object)searchCriteria);
        }
        if ((property = findRequest.getSequencingProperty()) != null) {
            property = QueryUtils.encodeParams((String)methodName, (String)"sequencingProperty", (String)property);
            queryBuilder.addParam((Object)"sequencingProperty", (Object)property);
        }
        queryBuilder.addParams(queryParams);
        return queryBuilder;
    }

    public <T> GenericResponse<T> findRESTCall(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Integer maximumPageSizeOnRestCall) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        GenericResponse completeResponse = null;
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(invalidParameterHandler.getMaxPagingSize()));
        }
        invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
        int requestedPageSize = findRequest.getPageSize();
        if (maximumPageSizeOnRestCall == null || maximumPageSizeOnRestCall < 1 || maximumPageSizeOnRestCall >= requestedPageSize) {
            String findUrlTemplate = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId);
            String expandedURL = findUrlTemplate + this.createFindQuery(methodName, findRequest, exactValue, ignoreCase).toString();
            completeResponse = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        } else {
            completeResponse = this.getAccumulatedResponse(userId, methodName, urnTemplate, type, findRequest, maximumPageSizeOnRestCall, requestedPageSize);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> findRESTCallById(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Integer maximumPageSizeOnRestCall, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        GenericResponse completeResponse = null;
        if (findRequest.getPageSize() == null) {
            findRequest.setPageSize(Integer.valueOf(invalidParameterHandler.getMaxPagingSize()));
        }
        invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
        int requestedPageSize = findRequest.getPageSize();
        if (maximumPageSizeOnRestCall == null || maximumPageSizeOnRestCall < 1 || maximumPageSizeOnRestCall >= requestedPageSize) {
            String findUrlTemplate = String.format(this.serverPlatformURLRoot + urnTemplate, this.serverName, userId, guid);
            String expandedURL = findUrlTemplate + this.createFindQuery(methodName, findRequest, exactValue, ignoreCase).toString();
            completeResponse = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        } else {
            completeResponse = this.getAccumulatedResponse(userId, methodName, urnTemplate, type, findRequest, maximumPageSizeOnRestCall, requestedPageSize);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    private <T> GenericResponse<T> getAccumulatedResponse(String userId, String methodName, String urnTemplate, ParameterizedTypeReference<GenericResponse<T>> type, FindRequest findRequest, Integer maximumPageSizeOnRestCall, int requestedPageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GenericResponse completeResponse = null;
        int startingFrom = findRequest.getStartingFrom();
        int totalNumberRetrieved = 0;
        while (totalNumberRetrieved < requestedPageSize) {
            findRequest.setPageSize(maximumPageSizeOnRestCall);
            findRequest.setStartingFrom(startingFrom + totalNumberRetrieved);
            String findUrlTemplate = urnTemplate + this.createFindQuery(methodName, findRequest).toString();
            String expandedURL = String.format(this.serverPlatformURLRoot + findUrlTemplate, this.serverName, userId);
            GenericResponse responseForPart = (GenericResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)responseForPart);
            int numberRetrieved = responseForPart.results().size();
            totalNumberRetrieved = this.getMore(numberRetrieved, maximumPageSizeOnRestCall, requestedPageSize) ? (totalNumberRetrieved += numberRetrieved) : requestedPageSize;
            if (completeResponse == null) {
                completeResponse = responseForPart;
                continue;
            }
            completeResponse.addAllResults((Collection)responseForPart.results());
        }
        return completeResponse;
    }

    boolean getMore(int numberRetrieved, int maximumPageSizeOnRestCall, int requestedPageSize) {
        return numberRetrieved == maximumPageSizeOnRestCall && requestedPageSize > maximumPageSizeOnRestCall;
    }

    public <T> GenericResponse<T> getByIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate, FindRequest findRequest, Integer maximumPageSizeOnRestCall, Map<String, String> params) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        GenericResponse<T> completeResponse = null;
        int requestedPageSize = 0;
        if (findRequest != null) {
            if (findRequest.getPageSize() == null) {
                findRequest.setPageSize(Integer.valueOf(invalidParameterHandler.getMaxPagingSize()));
            }
            invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
            requestedPageSize = findRequest.getPageSize();
        }
        if (maximumPageSizeOnRestCall == null || maximumPageSizeOnRestCall < 1 || maximumPageSizeOnRestCall >= requestedPageSize) {
            String expandedURL;
            if (findRequest == null) {
                expandedURL = String.format(this.serverPlatformURLRoot + (String)urnTemplate, this.serverName, userId, guid);
            } else {
                QueryBuilder queryBuilder = this.createFindQuery(methodName, findRequest);
                if (params != null && params.keySet().size() > 0) {
                    for (String param : params.keySet()) {
                        queryBuilder.addParam((Object)param, (Object)params.get(param));
                    }
                }
                String findUrlTemplate = (String)urnTemplate + queryBuilder.toString();
                expandedURL = String.format(this.serverPlatformURLRoot + findUrlTemplate, this.serverName, userId, guid);
            }
            completeResponse = (GenericResponse<T>)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, completeResponse);
        } else {
            int lastIndex = ((String)urnTemplate).lastIndexOf("%s");
            String lastBit = ((String)urnTemplate).substring(lastIndex);
            String lastBitWithGuid = lastBit.replace("%s", guid);
            urnTemplate = ((String)urnTemplate).substring(0, lastIndex) + lastBitWithGuid;
            completeResponse = this.getAccumulatedResponse(userId, methodName, (String)urnTemplate, type, findRequest, maximumPageSizeOnRestCall, requestedPageSize);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public <T> GenericResponse<T> getByIdRESTCall(String userId, String guid, String methodName, ParameterizedTypeReference<GenericResponse<T>> type, String urnTemplate, FindRequest findRequest, Integer maximumPageSizeOnRestCall, QueryParams queryParams) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        GenericResponse<T> completeResponse = null;
        int requestedPageSize = 0;
        if (findRequest != null) {
            if (findRequest.getPageSize() == null) {
                findRequest.setPageSize(Integer.valueOf(invalidParameterHandler.getMaxPagingSize()));
            }
            invalidParameterHandler.validatePaging(findRequest.getStartingFrom(), findRequest.getPageSize().intValue(), methodName);
            requestedPageSize = findRequest.getPageSize();
        }
        if (maximumPageSizeOnRestCall == null || maximumPageSizeOnRestCall < 1 || maximumPageSizeOnRestCall >= requestedPageSize) {
            String expandedURL;
            if (findRequest == null) {
                expandedURL = String.format(this.serverPlatformURLRoot + (String)urnTemplate, this.serverName, userId, guid);
            } else {
                QueryBuilder queryBuilder = this.createFindQuery(methodName, findRequest, queryParams);
                String findUrlTemplate = (String)urnTemplate + queryBuilder.toString();
                expandedURL = String.format(this.serverPlatformURLRoot + findUrlTemplate, this.serverName, userId, guid);
            }
            completeResponse = (GenericResponse<T>)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
            this.exceptionHandler.detectAndThrowStandardExceptions(methodName, completeResponse);
        } else {
            int lastIndex = ((String)urnTemplate).lastIndexOf("%s");
            String lastBit = ((String)urnTemplate).substring(lastIndex);
            String lastBitWithGuid = lastBit.replace("%s", guid);
            urnTemplate = ((String)urnTemplate).substring(0, lastIndex) + lastBitWithGuid;
            completeResponse = this.getAccumulatedResponse(userId, methodName, (String)urnTemplate, type, findRequest, maximumPageSizeOnRestCall, requestedPageSize);
        }
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public OMAGServerConfigResponse getConfigRESTCall(String userId, String guid, String methodName, Class<OMAGServerConfigResponse> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        OMAGServerConfigResponse completeResponse = null;
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, userId, this.serverName);
        completeResponse = (OMAGServerConfigResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public ViewServiceConfigResponse getViewServiceConfigRESTCall(String userId, String guid, String methodName, Class<ViewServiceConfigResponse> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId + ",guid=" + guid);
        }
        ViewServiceConfigResponse completeResponse = null;
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, userId, this.serverName);
        completeResponse = (ViewServiceConfigResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }

    public ViewServicesResponse getViewConfigRESTCall(String userId, String methodName, Class<ViewServicesResponse> type, String urnTemplate) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("==> Method: " + methodName + ",userId=" + userId);
        }
        ViewServicesResponse completeResponse = null;
        String expandedURL = String.format(this.serverPlatformURLRoot + urnTemplate, userId, this.serverName);
        completeResponse = (ViewServicesResponse)this.callGetRESTCall(methodName, type, expandedURL, new Object[0]);
        this.exceptionHandler.detectAndThrowStandardExceptions(methodName, (FFDCResponse)completeResponse);
        if (log.isDebugEnabled()) {
            log.debug("<== successful method : " + methodName + ",userId=" + userId);
        }
        return completeResponse;
    }
}

