/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.category;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryParams;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResponseParameterization;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.category.GlossaryAuthorViewCategory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class GlossaryAuthorViewCategoryClient
implements GlossaryAuthorViewCategory,
ResponseParameterization<Category> {
    protected final GlossaryAuthorViewRestClient client;
    private static final String BASE_URL = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/categories";

    protected String getMethodInfo(String methodName) {
        return methodName + " for " + this.resultType().getSimpleName();
    }

    public GlossaryAuthorViewCategoryClient(GlossaryAuthorViewRestClient client) {
        this.client = client;
    }

    @Override
    public Category create(String userId, Category category) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        GenericResponse<Category> response = this.client.postRESTCall(userId, this.getMethodInfo("create"), BASE_URL, this.getParameterizedType(), category);
        return (Category)response.head().get();
    }

    @Override
    public Category update(String userId, String guid, Category category, boolean isReplace) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (isReplace) {
            params.put("isReplace", "true");
        } else {
            params.put("isReplace", "false");
        }
        GenericResponse response = this.client.putRESTCall(userId, guid, this.getMethodInfo("create"), BASE_URL, this.getParameterizedType(), category, params);
        return (Category)response.head().get();
    }

    @Override
    public void delete(String userId, String guid) throws PropertyServerException {
        String methodName = this.getMethodInfo("Restore");
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = BASE_URL;
        this.client.delRESTCall(userId, type, methodName, urlTemplate, guid);
    }

    @Override
    public Category restore(String userId, String guid) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = this.getMethodInfo("Restore");
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/categories/%s";
        GenericResponse<String> response = this.client.postRESTCall(userId, methodName, urlTemplate, type, guid);
        return (Category)response.head().get();
    }

    @Override
    public List<Category> getCategoryChildren(String userId, String parentGuid, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/categories/%s/categories";
        GenericResponse completeResponse = this.client.findRESTCallById(userId, this.getMethodInfo("getCategoryChildren"), urlTemplate, type, findRequest, exactValue, ignoreCase, null, parentGuid);
        return completeResponse.results();
    }

    @Override
    public List<Category> findAll(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.find(userId, new FindRequest(), false, true);
    }

    @Override
    public Category getByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/categories/%s";
        GenericResponse response = this.client.getByGUIdRESTCall(userId, guid, this.getMethodInfo("getByGUID"), type, urlTemplate);
        return (Category)response.head().get();
    }

    @Override
    public List<Category> find(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse completeResponse = this.client.findRESTCall(userId, this.getMethodInfo("find"), BASE_URL, type, findRequest, exactValue, ignoreCase, null);
        return completeResponse.results();
    }

    @Override
    public List<Relationship> getRelationships(String userId, String guid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Relationship.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/categories/%s/relationships";
        GenericResponse completeResponse = this.client.getByIdRESTCall(userId, guid, "getCategoryRelationships", type, urlTemplate, findRequest, (Integer)0, (QueryParams)null);
        return completeResponse.results();
    }

    @Override
    public List<Relationship> getAllRelationships(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getRelationships(userId, guid, new FindRequest());
    }

    @Override
    public List<Term> getTerms(String userId, String guid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getTerms(userId, guid, findRequest, false, true, null);
    }

    public List<Term> getTerms(String userId, String guid, FindRequest findRequest, boolean exactValue, boolean ignoreCase, Integer maximumPageSizeOnRestCall) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Term.class});
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/categories/%s/terms";
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        QueryParams queryParams = new QueryParams().setExactValue(exactValue).setIgnoreCase(ignoreCase);
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, this.getMethodInfo("getTerms"), type, urnTemplate, findRequest, maximumPageSizeOnRestCall, queryParams);
        return response.results();
    }

    public Class<? extends GenericResponse> responseType() {
        return SubjectAreaOMASAPIResponse.class;
    }
}

