/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.graph;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.NeighborhoodHistoricalFindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryBuilder;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResponseParameterization;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.graph.GlossaryAuthorViewGraph;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.GraphStatistics;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class GlossaryAuthorViewGraphClient
implements GlossaryAuthorViewGraph,
ResponseParameterization<Graph> {
    protected final GlossaryAuthorViewRestClient client;
    private static final String BASE_URL = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph";
    private static final String BASE_URL_GPSTATS = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph-counts";
    private static final String GLOSSARY_AUTHOR_CONFIG_BASE_URL = "/open-metadata/admin-services/users/%s/servers/%s/configuration";
    private static final String GLOSSARY_AUTHOR_C_BASE_URL = "/open-metadata/admin-services/users/%s/servers/%s/view-services/glossary-author";
    private static final String GLOSSARY_AUTHOR_VIEWCONFIG_BASE_URL = "/open-metadata/admin-services/users/%s/servers/%s/view-services/configuration";

    protected String getMethodInfo(String methodName) {
        return methodName + " for " + this.resultType().getSimpleName();
    }

    public GlossaryAuthorViewGraphClient(GlossaryAuthorViewRestClient client) {
        this.client = client;
    }

    @Override
    public Graph create(String userId, Graph graph) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        GenericResponse<Graph> response = this.client.postRESTCall(userId, this.getMethodInfo("create"), BASE_URL, this.getParameterizedType(), graph);
        return (Graph)response.head().get();
    }

    @Override
    public Graph update(String userId, String guid, Graph graph, boolean isReplace) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph/%s?isReplace=" + Boolean.toString(isReplace);
        String methodInfo = this.getMethodInfo("update(isReplace=" + isReplace + ")");
        GenericResponse<Graph> response = this.client.putRESTCall(userId, guid, methodInfo, urlTemplate, this.getParameterizedType(), graph);
        return (Graph)response.head().get();
    }

    @Override
    public void delete(String userId, String guid) throws PropertyServerException {
        String methodName = this.getMethodInfo("Restore");
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = BASE_URL;
        this.client.delRESTCall(userId, type, methodName, urlTemplate, guid);
    }

    @Override
    public Graph restore(String userId, String guid) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = this.getMethodInfo("Restore");
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Graph.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph/%s";
        GenericResponse<String> response = this.client.postRESTCall(userId, methodName, urlTemplate, type, guid);
        return (Graph)response.head().get();
    }

    @Override
    public List<Category> getCategoryChildren(String userId, String parentGuid, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph/%s/categories";
        GenericResponse completeResponse = this.client.findRESTCallById(userId, this.getMethodInfo("getCategoryChildren"), urlTemplate, type, findRequest, exactValue, ignoreCase, null, parentGuid);
        return completeResponse.results();
    }

    @Override
    public List<Graph> findAll(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.find(userId, new FindRequest(), false, true);
    }

    @Override
    public Graph getByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Graph.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph/%s";
        GenericResponse response = this.client.getByGUIdRESTCall(userId, guid, this.getMethodInfo("getByGUID"), type, urlTemplate);
        return (Graph)response.head().get();
    }

    @Override
    public List<Graph> find(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Graph.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse completeResponse = this.client.findRESTCall(userId, this.getMethodInfo("find"), BASE_URL, type, findRequest, exactValue, ignoreCase, null);
        return completeResponse.results();
    }

    @Override
    public List<Category> getCategories(String userId, String graphGuid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph/%s/categories";
        String methodInfo = this.getMethodInfo(" getCategories");
        QueryBuilder query = this.client.createFindQuery(methodInfo, findRequest);
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph/%s/categories" + query.toString();
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse response = this.client.getByIdRESTCall(userId, graphGuid, methodInfo, type, urlTemplate);
        return response.results();
    }

    @Override
    public OMAGServerConfig getConfig(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OMAGServerConfigResponse completeResponse = this.client.getConfigRESTCall(userId, "current", this.getMethodInfo("getConfig"), OMAGServerConfigResponse.class, GLOSSARY_AUTHOR_CONFIG_BASE_URL);
        return completeResponse.getOMAGServerConfig();
    }

    @Override
    public ViewServiceConfig getGlossaryAuthViewServiceConfig(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ViewServiceConfigResponse completeResponse = this.client.getViewServiceConfigRESTCall(userId, "current", this.getMethodInfo("getOmagServerName"), ViewServiceConfigResponse.class, GLOSSARY_AUTHOR_C_BASE_URL);
        return completeResponse.getConfig();
    }

    @Override
    public GraphStatistics getGraphStatistics(String userId, String guid, Date asOfTime, Set<NodeType> nodeFilter, Set<RelationshipType> relationshipFilter, StatusFilter statusFilter) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{GraphStatistics.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        NeighborhoodHistoricalFindRequest request = new NeighborhoodHistoricalFindRequest();
        request.setAsOfTime(asOfTime);
        request.setNodeFilter(nodeFilter);
        request.setRelationshipFilter(relationshipFilter);
        request.setStatusFilter(statusFilter);
        String methodName = "getGraphStatistics";
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph-counts/%s" + this.createGraphQuery(request).toString();
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, "getGraphStatistics", type, urlTemplate);
        return (GraphStatistics)response.head().get();
    }

    @Override
    public Graph getGraph(String userId, String guid, Date asOfTime, Set<NodeType> nodeFilter, Set<RelationshipType> relationshipFilter, StatusFilter statusFilter) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        NeighborhoodHistoricalFindRequest request = new NeighborhoodHistoricalFindRequest();
        request.setAsOfTime(asOfTime);
        request.setNodeFilter(nodeFilter);
        request.setRelationshipFilter(relationshipFilter);
        request.setStatusFilter(statusFilter);
        String methodName = "getGraph";
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/graph/%s" + this.createGraphQuery(request).toString();
        GenericResponse response = this.client.getByIdRESTCall(userId, guid, "getGraph", this.getParameterizedType(), urlTemplate);
        return (Graph)response.head().get();
    }

    public QueryBuilder createGraphQuery(NeighborhoodHistoricalFindRequest request) {
        QueryBuilder queryBuilder = new QueryBuilder();
        String nodeFilter = request.getNodeFilter().stream().map(Enum::name).collect(Collectors.joining(","));
        String relationshipFilter = request.getRelationshipFilter().stream().map(Enum::name).collect(Collectors.joining(","));
        if (!nodeFilter.isEmpty()) {
            queryBuilder.addParam((Object)"nodeFilter", (Object)nodeFilter);
        }
        if (!relationshipFilter.isEmpty()) {
            queryBuilder.addParam((Object)"relationshipFilter", (Object)relationshipFilter);
        }
        return queryBuilder.addParam((Object)"asOfTime", (Object)request.getAsOfTime()).addParam((Object)"statusFilter", (Object)request.getStatusFilter().name());
    }

    @Override
    public List<ViewServiceConfig> getViewServiceConfigs(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ViewServicesResponse completeResponse = this.client.getViewConfigRESTCall(userId, this.getMethodInfo("getViewServiceConfig"), ViewServicesResponse.class, GLOSSARY_AUTHOR_VIEWCONFIG_BASE_URL);
        return completeResponse.getServices();
    }

    public Class<? extends GenericResponse> responseType() {
        return SubjectAreaOMASAPIResponse.class;
    }
}

