/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.admin;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.viewservices.glossaryauthor.admin.serviceinstances.GlossaryAuthorViewServicesInstance;
import org.odpi.openmetadata.viewservices.glossaryauthor.auditlog.GlossaryAuthorViewAuditCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryAuthorViewAdmin
extends ViewServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(GlossaryAuthorViewAdmin.class);
    private ViewServiceConfig viewServiceConfig = null;
    private OMRSAuditLog auditLog = null;
    private String serverUserName = null;
    private GlossaryAuthorViewServicesInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfigurationProperties, OMRSAuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        String methodName = "initialize";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: initialize,userid=" + serverUserName);
        }
        GlossaryAuthorViewAuditCode auditCode = GlossaryAuthorViewAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.viewServiceConfig = viewServiceConfigurationProperties;
            this.auditLog = auditLog;
            this.serverUserName = serverUserName;
            this.serverName = serverName;
            this.instance = new GlossaryAuthorViewServicesInstance(this.serverName, auditLog, serverUserName, maxPageSize, this.viewServiceConfig.getOMAGServerName(), this.viewServiceConfig.getOMAGServerPlatformRootURL());
            auditCode = GlossaryAuthorViewAuditCode.SERVICE_INITIALIZED;
            this.writeAuditLogPassingErrorMessage(auditLog, "initialize", auditCode, serverName);
            if (log.isDebugEnabled()) {
                log.debug("<== Method: initialize,userid=" + serverUserName);
            }
        }
        catch (InvalidParameterException iae) {
            auditCode = GlossaryAuthorViewAuditCode.SERVICE_INSTANCE_FAILURE;
            this.writeAuditLogPassingErrorMessage(auditLog, "initialize", auditCode, iae.getMessage());
            throw new OMAGConfigurationErrorException(iae.getReportedHTTPCode(), iae.getReportingClassName(), iae.getReportingActionDescription(), iae.getErrorMessage(), iae.getReportedSystemAction(), iae.getReportedUserAction());
        }
    }

    private void writeAuditLogPassingErrorMessage(OMRSAuditLog auditLog, String actionDescription, GlossaryAuthorViewAuditCode auditCode, String message) {
        auditLog.logRecord(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(message), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        log.debug(">>shutdown");
        GlossaryAuthorViewAuditCode auditCode = GlossaryAuthorViewAuditCode.SERVICE_TERMINATING;
        this.writeAuditLogPassingErrorMessage(this.auditLog, "shutdown", auditCode, this.serverName);
        if (this.instance != null) {
            this.instance.shutdown();
        }
        auditCode = GlossaryAuthorViewAuditCode.SERVICE_SHUTDOWN;
        this.writeAuditLogPassingErrorMessage(this.auditLog, "shutdown", auditCode, this.serverName);
        log.debug("<<shutdown");
    }
}

