/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.auditlog;

import java.text.MessageFormat;
import java.util.Arrays;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GlossaryAuthorViewAuditCode {
    SERVICE_INITIALIZING("OMVS-GLOSSARY-AUTHOR-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Glossary Author View Service (OMVS) is initializing", "The local server is initializing the Glossary Author OMVS. If the initialization is successful then audit message OMVS-GLOSSARY-AUTHOR-0003 will be issued, if there were errors then they should be shown in the audit log. ", "No action is required. This is part of the normal operation of the Glossary Author OMVS."),
    SERVICE_INITIALIZED("OMVS-GLOSSARY-AUTHOR-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Glossary Author View Service (OMVS) is initialized", "The Glossary Author OMVS has completed initialization. Calls will be accepted by this service, if OMRS is also configured and the view server has been started. ", "No action is required.  This is part of the normal operation of the Glossary Author OMVS. Once the OMRS is configured and the server is started, Glossary Author view service requests can be accepted."),
    SERVICE_SHUTDOWN("OMVS-GLOSSARY-AUTHOR-0003", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Glossary Author View Service (OMVS) is shutting down", "The local server has requested shutdown of the Glossary Author OMVS.", "No action is required. The operator should verify that shutdown was intended. This is part of the normal operation of the Glossary Author OMVS."),
    SERVICE_INSTANCE_FAILURE("OMVS-GLOSSARY-AUTHOR-0004", OMRSAuditLogRecordSeverity.EXCEPTION, "The Glossary Author View Service (OMVS) is unable to initialize a new instance; error message is {0}", "The view service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    SERVICE_TERMINATING("OMVS-GLOSSARY-AUTHOR-0005", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Glossary Author View Service (OMVS) is shutting down server instance {0}", "The local handlers has requested shut down of the Glossary Author OMVS.", "No action is required. This is part of the normal operation of the service.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;
    private static final Logger log;

    private GlossaryAuthorViewAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("<== OMRS Audit Code.getMessage(%s)", Arrays.toString(params)));
        }
        MessageFormat mf = new MessageFormat(this.logMessage);
        String result = mf.format(params);
        if (log.isDebugEnabled()) {
            log.debug(String.format("==> OMRS Audit Code.getMessage(%s): %s", Arrays.toString(params), result));
        }
        return result;
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }

    static {
        log = LoggerFactory.getLogger(GlossaryAuthorViewAuditCode.class);
    }
}

