/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.initialization;

import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaGlossary;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaProject;
import org.odpi.openmetadata.accessservices.subjectarea.SubjectAreaTerm;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.MetadataServerUncontactableException;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstanceHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.admin.serviceinstances.GlossaryAuthorViewServicesInstance;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.GlossaryHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.ProjectHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.TermHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.initialization.GlossaryAuthorViewRegistration;
import org.odpi.openmetadata.viewservices.glossaryauthor.initialization.GlossaryAuthorViewServicesInstanceMap;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryauthorViewServicesInstance;

public class GlossaryAuthorViewInstanceHandler
extends OMVSServiceInstanceHandler {
    private static GlossaryAuthorViewServicesInstanceMap instanceMap = new GlossaryAuthorViewServicesInstanceMap();

    public GlossaryAuthorViewInstanceHandler() {
        super(ViewServiceDescription.GLOSSARY_AUTHOR.getViewServiceName());
        GlossaryAuthorViewRegistration.registerViewService();
    }

    public String getViewServiceName(String serverName) throws MetadataServerUncontactableException {
        GlossaryauthorViewServicesInstance instance = instanceMap.getInstance(serverName);
        if (instance != null) {
            return instance.getServiceName();
        }
        String methodName = "getViewServiceName";
        SubjectAreaErrorCode errorCode = SubjectAreaErrorCode.SERVICE_NOT_INITIALIZED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{serverName, "getViewServiceName"});
        throw new MetadataServerUncontactableException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getViewServiceName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public GlossaryHandler getGlossaryHandler(String serverName, String userId, String serviceOperationName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, MetadataServerUncontactableException {
        SubjectAreaGlossary subjectAreaGlossary = this.getSubjectAreaGlossary(serverName, userId, serviceOperationName);
        return new GlossaryHandler(subjectAreaGlossary);
    }

    public ProjectHandler getProjectHandler(String serverName, String userId, String serviceOperationName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, MetadataServerUncontactableException {
        SubjectAreaProject subjectAreaProject = this.getSubjectAreaProject(serverName, userId, serviceOperationName);
        return new ProjectHandler(subjectAreaProject);
    }

    public TermHandler getTermHandler(String serverName, String userId, String serviceOperationName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, MetadataServerUncontactableException {
        SubjectAreaTerm subjectAreaTerm = this.getSubjectAreaTerm(serverName, userId, serviceOperationName);
        return new TermHandler(subjectAreaTerm);
    }

    private SubjectAreaGlossary getSubjectAreaGlossary(String serverName, String userId, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewServicesInstance instance = this.getSubjectAreaViewServicesInstance(userId, serverName, serviceOperationName);
        return instance.getSubjectAreaGlossary();
    }

    private SubjectAreaTerm getSubjectAreaTerm(String serverName, String userId, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewServicesInstance instance = this.getSubjectAreaViewServicesInstance(userId, serverName, serviceOperationName);
        return instance.getSubjectAreaTerm();
    }

    private SubjectAreaProject getSubjectAreaProject(String serverName, String userId, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewServicesInstance instance = this.getSubjectAreaViewServicesInstance(userId, serverName, serviceOperationName);
        return instance.getSubjectAreaProject();
    }

    private GlossaryAuthorViewServicesInstance getSubjectAreaViewServicesInstance(String userId, String serverName, String serviceOperationName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return (GlossaryAuthorViewServicesInstance)super.getServerServiceInstance(userId, serverName, serviceOperationName);
    }
}

