/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossariesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.GlossaryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.GlossaryHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryAuthorViewGlossaryRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewGlossaryRESTServices.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);

    public SubjectAreaOMASAPIResponse createGlossary(String serverName, String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossary");
        SubjectAreaOMASAPIResponse response = null;
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "createGlossary");
            Glossary createdGlossary = handler.createGlossary(userId, suppliedGlossary);
            response = new GlossaryResponse(createdGlossary);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "createGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossary(String serverName, String userId, String guid) {
        String methodName = "getGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossary");
        SubjectAreaOMASAPIResponse response = null;
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "getGlossary");
            Glossary obtainedGlossary = handler.getGlossaryByGuid(userId, guid);
            response = new GlossaryResponse(obtainedGlossary);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse findGlossary(String serverName, String userId, Date asOfTime, String searchCriteria, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossary");
        SubjectAreaOMASAPIResponse response = null;
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "findGlossary");
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            List<Glossary> glossaries = handler.findGlossary(userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            GlossariesResponse glossariesResponse = new GlossariesResponse();
            glossariesResponse.setGlossaries(glossaries);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "findGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getGlossaryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryRelationships");
        SubjectAreaOMASAPIResponse response = null;
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryRelationships");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "getGlossaryRelationships");
            List<Line> lines = handler.getGlossaryRelationships(userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getGlossaryRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateGlossary(String serverName, String userId, String guid, Glossary glossary, Boolean isReplace) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossary");
        SubjectAreaOMASAPIResponse response = null;
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "updateGlossary");
            if (isReplace == null) {
                isReplace = false;
            }
            Glossary updatedGlossary = isReplace != false ? handler.replaceGlossary(userId, guid, glossary) : handler.updateGlossary(userId, guid, glossary);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(updatedGlossary);
            response = glossaryResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "updateGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteGlossary(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGlossary");
        SubjectAreaOMASAPIResponse response = null;
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "deleteGlossary");
            if (isPurge == null) {
                isPurge = false;
            }
            if (isPurge.booleanValue()) {
                handler.purgeGlossary(userId, guid);
                response = new VoidResponse();
            } else {
                Glossary glossary = handler.deleteGlossary(userId, guid);
                GlossaryResponse glossaryResponse = new GlossaryResponse();
                glossaryResponse.setGlossary(glossary);
                response = glossaryResponse;
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "deleteGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreGlossary(String serverName, String userId, String guid) {
        String methodName = "restoreGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreGlossary");
        SubjectAreaOMASAPIResponse response = null;
        OMRSAuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "restoreGlossary");
            Glossary glossary = handler.restoreGlossary(userId, guid);
            GlossaryResponse glossaryResponse = new GlossaryResponse();
            glossaryResponse.setGlossary(glossary);
            response = glossaryResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "restoreGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

