/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnexpectedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UserNotAuthorizedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.viewservices.glossaryauthor.auditlog.GlossaryAuthorViewAuditCode;
import org.odpi.openmetadata.viewservices.glossaryauthor.initialization.GlossaryAuthorViewInstanceHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewGlossaryRESTServices;
import org.slf4j.LoggerFactory;

public abstract class BaseGlossaryAuthorView {
    protected static GlossaryAuthorViewInstanceHandler instanceHandler = new GlossaryAuthorViewInstanceHandler();
    protected static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryAuthorViewGlossaryRESTServices.class), instanceHandler.getServiceName());

    protected SubjectAreaOMASAPIResponse getResponseForError(Throwable error, AuditLog auditLog, String methodName) {
        SubjectAreaOMASAPIResponse response = null;
        if (error instanceof OCFCheckedExceptionBase) {
            response = this.getResponseFromOCFCheckedExceptionBase((OCFCheckedExceptionBase)error);
        } else if (error instanceof SubjectAreaCheckedExceptionBase) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedExceptionBase)((SubjectAreaCheckedExceptionBase)error));
        } else {
            response = new UnexpectedExceptionResponse(methodName, error.getMessage());
            if (auditLog != null) {
                auditLog.logException(methodName, GlossaryAuthorViewAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), methodName, error.getMessage()), error);
            }
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getResponseFromOCFCheckedExceptionBase(OCFCheckedExceptionBase ocfCheckedExceptionBase) {
        InvalidParameterExceptionResponse response = null;
        if (ocfCheckedExceptionBase instanceof InvalidParameterException) {
            org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException e = new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(ocfCheckedExceptionBase.getReportedHTTPCode(), ocfCheckedExceptionBase.getReportingClassName(), ocfCheckedExceptionBase.getReportingActionDescription(), ocfCheckedExceptionBase.getErrorMessage(), ocfCheckedExceptionBase.getReportedSystemAction(), ocfCheckedExceptionBase.getReportedUserAction());
            response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
        } else if (ocfCheckedExceptionBase instanceof org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException) {
            UserNotAuthorizedException e = new UserNotAuthorizedException(ocfCheckedExceptionBase.getReportedHTTPCode(), ocfCheckedExceptionBase.getReportingClassName(), ocfCheckedExceptionBase.getReportingActionDescription(), ocfCheckedExceptionBase.getErrorMessage(), ocfCheckedExceptionBase.getReportedSystemAction(), ocfCheckedExceptionBase.getReportedUserAction(), ((org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException)ocfCheckedExceptionBase).getUserId());
            response = new UserNotAuthorizedExceptionResponse((SubjectAreaCheckedExceptionBase)e);
        } else if (ocfCheckedExceptionBase instanceof PropertyServerException) {
            org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException e = new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(ocfCheckedExceptionBase.getReportedHTTPCode(), ocfCheckedExceptionBase.getReportingClassName(), ocfCheckedExceptionBase.getReportingActionDescription(), ocfCheckedExceptionBase.getErrorMessage(), ocfCheckedExceptionBase.getReportedSystemAction(), ocfCheckedExceptionBase.getReportedUserAction());
            response = new InvalidParameterExceptionResponse((SubjectAreaCheckedExceptionBase)e);
        }
        return response;
    }
}

