/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoriesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.CategoryHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryAuthorViewCategoryRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewCategoryRESTServices.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);

    public SubjectAreaOMASAPIResponse createCategory(String serverName, String userId, Category suppliedCategory) {
        String methodName = "createCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createCategory");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createCategory");
            CategoryHandler handler = instanceHandler.getCategoryHandler(serverName, userId, "createCategory");
            Category createdCategory = handler.createCategory(userId, suppliedCategory);
            response = new CategoryResponse(createdCategory);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "createCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategory(String serverName, String userId, String guid) {
        String methodName = "getCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategory");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategory");
            CategoryHandler handler = instanceHandler.getCategoryHandler(serverName, userId, "getCategory");
            Category obtainedCategory = handler.getCategoryByGuid(userId, guid);
            response = new CategoryResponse(obtainedCategory);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse findCategory(String serverName, String userId, Date asOfTime, String searchCriteria, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findCategory");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findCategory");
            CategoryHandler handler = instanceHandler.getCategoryHandler(serverName, userId, "findCategory");
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            List<Category> categories = handler.findCategory(userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            CategoriesResponse categoriesResponse = new CategoriesResponse();
            categoriesResponse.setCategories(categories);
            response = categoriesResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "findCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategoryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getCategoryRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoryRelationships");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoryRelationships");
            CategoryHandler handler = instanceHandler.getCategoryHandler(serverName, userId, "getCategoryRelationships");
            List<Line> lines = handler.getCategoryRelationships(userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getCategoryRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateCategory(String serverName, String userId, String guid, Category category, Boolean isReplace) {
        String methodName = "updateCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCategory");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCategory");
            CategoryHandler handler = instanceHandler.getCategoryHandler(serverName, userId, "updateCategory");
            if (isReplace == null) {
                isReplace = false;
            }
            Category updatedCategory = isReplace != false ? handler.replaceCategory(userId, guid, category) : handler.updateCategory(userId, guid, category);
            CategoryResponse categoryResponse = new CategoryResponse();
            categoryResponse.setCategory(updatedCategory);
            response = categoryResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "updateCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteCategory(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteCategory");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteCategory");
            CategoryHandler handler = instanceHandler.getCategoryHandler(serverName, userId, "deleteCategory");
            if (isPurge == null) {
                isPurge = false;
            }
            if (isPurge.booleanValue()) {
                handler.purgeCategory(userId, guid);
                response = new VoidResponse();
            } else {
                Category category = handler.deleteCategory(userId, guid);
                CategoryResponse categoryResponse = new CategoryResponse();
                categoryResponse.setCategory(category);
                response = categoryResponse;
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "deleteCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreCategory(String serverName, String userId, String guid) {
        String methodName = "restoreCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreCategory");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreCategory");
            CategoryHandler handler = instanceHandler.getCategoryHandler(serverName, userId, "restoreCategory");
            Category category = handler.restoreCategory(userId, guid);
            CategoryResponse categoryResponse = new CategoryResponse();
            categoryResponse.setCategory(category);
            response = categoryResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "restoreCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

