/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.ProjectHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryAuthorViewProjectRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewProjectRESTServices.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);

    public SubjectAreaOMASAPIResponse createProject(String serverName, String userId, Project suppliedProject) {
        String methodName = "createProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProject");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "createProject");
            Project createdProject = handler.createProject(userId, suppliedProject);
            response = new ProjectResponse(createdProject);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "createProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getProject(String serverName, String userId, String guid) {
        String methodName = "getProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProject");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "getProject");
            Project obtainedProject = handler.getProjectByGuid(userId, guid);
            response = new ProjectResponse(obtainedProject);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse findProject(String serverName, String userId, Date asOfTime, String searchCriteria, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findProject");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "findProject");
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            List<Project> projects = handler.findProject(userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            ProjectsResponse projectsResponse = new ProjectsResponse();
            projectsResponse.setProjects(projects);
            response = projectsResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "findProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getProjectRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProjectRelationships");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectRelationships");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "getProjectRelationships");
            List<Line> lines = handler.getProjectRelationships(userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getProjectRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateProject(String serverName, String userId, String guid, Project project, Boolean isReplace) {
        String methodName = "updateProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProject");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "updateProject");
            if (isReplace == null) {
                isReplace = false;
            }
            Project updatedProject = isReplace != false ? handler.replaceProject(userId, guid, project) : handler.updateProject(userId, guid, project);
            ProjectResponse projectResponse = new ProjectResponse();
            projectResponse.setProject(updatedProject);
            response = projectResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "updateProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteProject(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteProject");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "deleteProject");
            if (isPurge == null) {
                isPurge = false;
            }
            if (isPurge.booleanValue()) {
                handler.purgeProject(userId, guid);
                response = new VoidResponse();
            } else {
                Project project = handler.deleteProject(userId, guid);
                ProjectResponse projectResponse = new ProjectResponse();
                projectResponse.setProject(project);
                response = projectResponse;
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "deleteProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreProject(String serverName, String userId, String guid) {
        String methodName = "restoreProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreProject");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "restoreProject");
            Project project = handler.restoreProject(userId, guid);
            ProjectResponse projectResponse = new ProjectResponse();
            projectResponse.setProject(project);
            response = projectResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "restoreProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

