/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ISARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScopeRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchorRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermCategorizationRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermHASARelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermISATypeOFRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermTYPEDBYRelationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.AntonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.CategoryAnchorRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.PreferredTermRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ProjectScopeRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.RelatedTermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ReplacementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SemanticAssignementRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SynonymRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermAnchorRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermCategorizationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermHASARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISARelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermISATYPEOFRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermTYPEDBYRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TranslationRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UsedInContextRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.ValidValueRelationshipResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.RelationshipHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryAuthorViewRelationshipRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewRelationshipRESTServices.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);

    public SubjectAreaOMASAPIResponse createTermHASARelationship(String serverName, String userId, TermHASARelationship termHASARelationship) {
        String restAPIName = "createTermHASARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermHASARelationship createdTermHASARelationship = handler.createTermHASARelationship(userId, termHASARelationship);
            response = new TermHASARelationshipResponse(createdTermHASARelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermHASARelationship(String serverName, String userId, String guid) {
        String restAPIName = "getTermHASARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermHASARelationship updatedTermHASARelationship = handler.getTermHASARelationship(userId, guid);
            response = new TermHASARelationshipResponse(updatedTermHASARelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermHASARelationship(String serverName, String userId, TermHASARelationship termHASARelationship, boolean isReplace) {
        String restAPIName = "updateTermHASARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                TermHASARelationship updatedTermHASARelationship = handler.replaceTermHASARelationship(userId, termHASARelationship);
                response = new TermHASARelationshipResponse(updatedTermHASARelationship);
            } else {
                TermHASARelationship updatedTermHASARelationship = handler.updateTermHASARelationship(userId, termHASARelationship);
                response = new TermHASARelationshipResponse(updatedTermHASARelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermHASARelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteTermHASARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeTermHASARelationship(userId, guid);
                response = new VoidResponse();
            } else {
                TermHASARelationship deletedTermHASARelationship = handler.deleteTermHASARelationship(userId, guid);
                response = new TermHASARelationshipResponse(deletedTermHASARelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermHASARelationship(String serverName, String userId, String guid) {
        String restAPIName = "restoreTermHASARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermHASARelationship restoredTermHASARelationship = handler.restoreTermHASARelationship(userId, guid);
            response = new TermHASARelationshipResponse(restoredTermHASARelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createRelatedTerm(String serverName, String userId, RelatedTerm relatedTerm) {
        String restAPIName = "createRelatedTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            RelatedTerm createdRelatedTerm = handler.createRelatedTerm(userId, relatedTerm);
            response = new RelatedTermResponse(createdRelatedTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getRelatedTerm(String serverName, String userId, String guid) {
        String restAPIName = "getRelatedTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            RelatedTerm updatedRelatedTerm = handler.getRelatedTerm(userId, guid);
            response = new RelatedTermResponse(updatedRelatedTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateRelatedTerm(String serverName, String userId, RelatedTerm relatedTerm, boolean isReplace) {
        String restAPIName = "updateRelatedTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                RelatedTerm updatedRelatedTerm = handler.replaceRelatedTerm(userId, relatedTerm);
                response = new RelatedTermResponse(updatedRelatedTerm);
            } else {
                RelatedTerm updatedRelatedTerm = handler.updateRelatedTerm(userId, relatedTerm);
                response = new RelatedTermResponse(updatedRelatedTerm);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteRelatedTerm(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteRelatedTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeRelatedTerm(userId, guid);
                response = new VoidResponse();
            } else {
                RelatedTerm deletedRelatedTerm = handler.deleteRelatedTerm(userId, guid);
                response = new RelatedTermResponse(deletedRelatedTerm);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreRelatedTerm(String serverName, String userId, String guid) {
        String restAPIName = "restoreRelatedTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            RelatedTerm restoredRelatedTerm = handler.restoreRelatedTerm(userId, guid);
            response = new RelatedTermResponse(restoredRelatedTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createSynonym(String serverName, String userId, Synonym synonym) {
        String restAPIName = "createSynonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Synonym createdSynonym = handler.createSynonymRelationship(userId, synonym);
            response = new SynonymRelationshipResponse(createdSynonym);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getSynonym(String serverName, String userId, String guid) {
        String restAPIName = "getSynonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Synonym updatedSynonym = handler.getSynonymRelationship(userId, guid);
            response = new SynonymRelationshipResponse(updatedSynonym);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateSynonym(String serverName, String userId, Synonym synonym, boolean isReplace) {
        String restAPIName = "updateSynonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                Synonym updatedSynonym = handler.replaceSynonymRelationship(userId, synonym);
                response = new SynonymRelationshipResponse(updatedSynonym);
            } else {
                Synonym updatedSynonym = handler.updateSynonymRelationship(userId, synonym);
                response = new SynonymRelationshipResponse(updatedSynonym);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteSynonym(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteSynonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeSynonymRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                Synonym deletedSynonym = handler.deleteSynonymRelationship(userId, guid);
                response = new SynonymRelationshipResponse(deletedSynonym);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreSynonym(String serverName, String userId, String guid) {
        String restAPIName = "restoreSynonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Synonym restoredSynonym = handler.restoreSynonymRelationship(userId, guid);
            response = new SynonymRelationshipResponse(restoredSynonym);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createAntonym(String serverName, String userId, Antonym antonym) {
        String restAPIName = "createAntonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Antonym createdAntonym = handler.createAntonymRelationship(userId, antonym);
            response = new AntonymRelationshipResponse(createdAntonym);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getAntonym(String serverName, String userId, String guid) {
        String restAPIName = "getAntonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Antonym updatedAntonym = handler.getAntonymRelationship(userId, guid);
            response = new AntonymRelationshipResponse(updatedAntonym);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateAntonym(String serverName, String userId, Antonym antonym, boolean isReplace) {
        String restAPIName = "updateAntonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                Antonym updatedAntonym = handler.replaceAntonymRelationship(userId, antonym);
                response = new AntonymRelationshipResponse(updatedAntonym);
            } else {
                Antonym updatedAntonym = handler.updateAntonymRelationship(userId, antonym);
                response = new AntonymRelationshipResponse(updatedAntonym);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteAntonym(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteAntonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeAntonymRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                Antonym deletedAntonym = handler.deleteAntonymRelationship(userId, guid);
                response = new AntonymRelationshipResponse(deletedAntonym);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreAntonym(String serverName, String userId, String guid) {
        String restAPIName = "restoreAntonym";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Antonym restoredAntonym = handler.restoreAntonymRelationship(userId, guid);
            response = new AntonymRelationshipResponse(restoredAntonym);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createTranslation(String serverName, String userId, Translation categoryAnchor) {
        String restAPIName = "createTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Translation createdTranslation = handler.createTranslationRelationship(userId, categoryAnchor);
            response = new TranslationRelationshipResponse(createdTranslation);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTranslation(String serverName, String userId, String guid) {
        String restAPIName = "getTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Translation updatedTranslation = handler.getTranslationRelationship(userId, guid);
            response = new TranslationRelationshipResponse(updatedTranslation);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTranslation(String serverName, String userId, Translation categoryAnchor, boolean isReplace) {
        String restAPIName = "updateTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                Translation updatedTranslation = handler.replaceTranslationRelationship(userId, categoryAnchor);
                response = new TranslationRelationshipResponse(updatedTranslation);
            } else {
                Translation updatedTranslation = handler.updateTranslationRelationship(userId, categoryAnchor);
                response = new TranslationRelationshipResponse(updatedTranslation);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTranslation(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeTranslationRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                Translation deletedTranslation = handler.deleteTranslationRelationship(userId, guid);
                response = new TranslationRelationshipResponse(deletedTranslation);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTranslation(String serverName, String userId, String guid) {
        String restAPIName = "restoreTranslation";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            Translation restoredTranslation = handler.restoreTranslationRelationship(userId, guid);
            response = new TranslationRelationshipResponse(restoredTranslation);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createUsedInContext(String serverName, String userId, UsedInContext usedInContext) {
        String restAPIName = "createUsedInContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            UsedInContext createdUsedInContext = handler.createUsedInContextRelationship(userId, usedInContext);
            response = new UsedInContextRelationshipResponse(createdUsedInContext);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getUsedInContext(String serverName, String userId, String guid) {
        String restAPIName = "getUsedInContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            UsedInContext updatedUsedInContext = handler.getUsedInContextRelationship(userId, guid);
            response = new UsedInContextRelationshipResponse(updatedUsedInContext);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateUsedInContext(String serverName, String userId, UsedInContext usedInContext, boolean isReplace) {
        String restAPIName = "updateUsedInContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                UsedInContext updatedUsedInContext = handler.replaceUsedInContextRelationship(userId, usedInContext);
                response = new UsedInContextRelationshipResponse(updatedUsedInContext);
            } else {
                UsedInContext updatedUsedInContext = handler.updateUsedInContextRelationship(userId, usedInContext);
                response = new UsedInContextRelationshipResponse(updatedUsedInContext);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteUsedInContext(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteUsedInContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeUsedInContextRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                UsedInContext deletedUsedInContext = handler.deleteUsedInContextRelationship(userId, guid);
                response = new UsedInContextRelationshipResponse(deletedUsedInContext);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreUsedInContext(String serverName, String userId, String guid) {
        String restAPIName = "restoreUsedInContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            UsedInContext restoredUsedInContext = handler.restoreUsedInContextRelationship(userId, guid);
            response = new UsedInContextRelationshipResponse(restoredUsedInContext);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createPreferredTerm(String serverName, String userId, PreferredTerm preferredTerm) {
        String restAPIName = "createPreferredTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            PreferredTerm createdPreferredTerm = handler.createPreferredTermRelationship(userId, preferredTerm);
            response = new PreferredTermRelationshipResponse(createdPreferredTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getPreferredTerm(String serverName, String userId, String guid) {
        String restAPIName = "getPreferredTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            PreferredTerm updatedPreferredTerm = handler.getPreferredTermRelationship(userId, guid);
            response = new PreferredTermRelationshipResponse(updatedPreferredTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updatePreferredTerm(String serverName, String userId, PreferredTerm preferredTerm, boolean isReplace) {
        String restAPIName = "updatePreferredTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                PreferredTerm updatedPreferredTerm = handler.replacePreferredTermRelationship(userId, preferredTerm);
                response = new PreferredTermRelationshipResponse(updatedPreferredTerm);
            } else {
                PreferredTerm updatedPreferredTerm = handler.updatePreferredTermRelationship(userId, preferredTerm);
                response = new PreferredTermRelationshipResponse(updatedPreferredTerm);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deletePreferredTerm(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deletePreferredTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgePreferredTermRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                PreferredTerm deletedPreferredTerm = handler.deletePreferredTermRelationship(userId, guid);
                response = new PreferredTermRelationshipResponse(deletedPreferredTerm);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restorePreferredTerm(String serverName, String userId, String guid) {
        String restAPIName = "restorePreferredTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            PreferredTerm restoredPreferredTerm = handler.restorePreferredTermRelationship(userId, guid);
            response = new PreferredTermRelationshipResponse(restoredPreferredTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createValidValue(String serverName, String userId, ValidValue validValue) {
        String restAPIName = "createValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ValidValue createdValidValue = handler.createValidValueRelationship(userId, validValue);
            response = new ValidValueRelationshipResponse(createdValidValue);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getValidValue(String serverName, String userId, String guid) {
        String restAPIName = "getValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ValidValue updatedValidValue = handler.getValidValueRelationship(userId, guid);
            response = new ValidValueRelationshipResponse(updatedValidValue);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateValidValue(String serverName, String userId, ValidValue validValue, boolean isReplace) {
        String restAPIName = "updateValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                ValidValue updatedValidValue = handler.replaceValidValueRelationship(userId, validValue);
                response = new ValidValueRelationshipResponse(updatedValidValue);
            } else {
                ValidValue updatedValidValue = handler.updateValidValueRelationship(userId, validValue);
                response = new ValidValueRelationshipResponse(updatedValidValue);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteValidValue(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeValidValueRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                ValidValue deletedValidValue = handler.deleteValidValueRelationship(userId, guid);
                response = new ValidValueRelationshipResponse(deletedValidValue);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreValidValue(String serverName, String userId, String guid) {
        String restAPIName = "restoreValidValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ValidValue restoredValidValue = handler.restoreValidValueRelationship(userId, guid);
            response = new ValidValueRelationshipResponse(restoredValidValue);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createReplacementTerm(String serverName, String userId, ReplacementTerm replacementTerm) {
        String restAPIName = "createReplacementTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ReplacementTerm createdReplacementTerm = handler.createReplacementTermRelationship(userId, replacementTerm);
            response = new ReplacementRelationshipResponse(createdReplacementTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getReplacementTerm(String serverName, String userId, String guid) {
        String restAPIName = "getReplacementTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ReplacementTerm updatedReplacementTerm = handler.getReplacementTermRelationship(userId, guid);
            response = new ReplacementRelationshipResponse(updatedReplacementTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateReplacementTerm(String serverName, String userId, ReplacementTerm replacementTerm, boolean isReplace) {
        String restAPIName = "updateReplacementTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                ReplacementTerm updatedReplacementTerm = handler.replaceReplacementTermRelationship(userId, replacementTerm);
                response = new ReplacementRelationshipResponse(updatedReplacementTerm);
            } else {
                ReplacementTerm updatedReplacementTerm = handler.updateReplacementTermRelationship(userId, replacementTerm);
                response = new ReplacementRelationshipResponse(updatedReplacementTerm);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteReplacementTerm(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteReplacementTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeReplacementTermRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                ReplacementTerm deletedReplacementTerm = handler.deleteReplacementTermRelationship(userId, guid);
                response = new ReplacementRelationshipResponse(deletedReplacementTerm);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreReplacementTerm(String serverName, String userId, String guid) {
        String restAPIName = "restoreReplacementTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ReplacementTerm restoredReplacementTerm = handler.restoreReplacementTermRelationship(userId, guid);
            response = new ReplacementRelationshipResponse(restoredReplacementTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createTermTYPEDBYRelationship(String serverName, String userId, TermTYPEDBYRelationship termTYPEDBYRelationship) {
        String restAPIName = "createTermTYPEDBYRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermTYPEDBYRelationship createdTermTYPEDBYRelationship = handler.createTermTYPEDBYRelationship(userId, termTYPEDBYRelationship);
            response = new TermTYPEDBYRelationshipResponse(createdTermTYPEDBYRelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermTYPEDBYRelationship(String serverName, String userId, String guid) {
        String restAPIName = "getTermTYPEDBYRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermTYPEDBYRelationship updatedTermTYPEDBYRelationship = handler.getTermTYPEDBYRelationship(userId, guid);
            response = new TermTYPEDBYRelationshipResponse(updatedTermTYPEDBYRelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermTYPEDBYRelationship(String serverName, String userId, TermTYPEDBYRelationship termTYPEDBYRelationship, boolean isReplace) {
        String restAPIName = "updateTermTYPEDBYRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                TermTYPEDBYRelationship updatedTermTYPEDBYRelationship = handler.replaceTermTYPEDBYRelationship(userId, termTYPEDBYRelationship);
                response = new TermTYPEDBYRelationshipResponse(updatedTermTYPEDBYRelationship);
            } else {
                TermTYPEDBYRelationship updatedTermTYPEDBYRelationship = handler.updateTermTYPEDBYRelationship(userId, termTYPEDBYRelationship);
                response = new TermTYPEDBYRelationshipResponse(updatedTermTYPEDBYRelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermTYPEDBYRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteTermTYPEDBYRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeTermTYPEDBYRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                TermTYPEDBYRelationship deletedTermTYPEDBYRelationship = handler.deleteTermTYPEDBYRelationship(userId, guid);
                response = new TermTYPEDBYRelationshipResponse(deletedTermTYPEDBYRelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermTYPEDBYRelationship(String serverName, String userId, String guid) {
        String restAPIName = "restoreTermTYPEDBYRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermTYPEDBYRelationship restoredTermTYPEDBYRelationship = handler.restoreTypedByRelationship(userId, guid);
            response = new TermTYPEDBYRelationshipResponse(restoredTermTYPEDBYRelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createIsaRelationship(String serverName, String userId, ISARelationship ISARelationship2) {
        String restAPIName = "createIsaRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ISARelationship createdISARelationship = handler.createIsaRelationship(userId, ISARelationship2);
            response = new TermISARelationshipResponse(createdISARelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getISARelationship(String serverName, String userId, String guid) {
        String restAPIName = "getISARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ISARelationship updatedISARelationship = handler.getIsaRelationship(userId, guid);
            response = new TermISARelationshipResponse(updatedISARelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateISARelationship(String serverName, String userId, ISARelationship ISARelationship2, boolean isReplace) {
        String restAPIName = "updateISARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                ISARelationship updatedISARelationship = handler.replaceIsaRelationship(userId, ISARelationship2);
                response = new TermISARelationshipResponse(updatedISARelationship);
            } else {
                ISARelationship updatedISARelationship = handler.updateIsaRelationship(userId, ISARelationship2);
                response = new TermISARelationshipResponse(updatedISARelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteISARelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteISARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeIsaRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                ISARelationship deletedISARelationship = handler.deleteIsaRelationship(userId, guid);
                response = new TermISARelationshipResponse(deletedISARelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreISARelationship(String serverName, String userId, String guid) {
        String restAPIName = "restoreISARelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ISARelationship restoredISARelationship = handler.restoreIsaRelationship(userId, guid);
            response = new TermISARelationshipResponse(restoredISARelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createTermISATypeOFRelationship(String serverName, String userId, TermISATypeOFRelationship termISATypeOFRelationship) {
        String restAPIName = "createTermISATypeOFRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermISATypeOFRelationship createdTermISATypeOFRelationship = handler.createTermISATypeOFRelationship(userId, termISATypeOFRelationship);
            response = new TermISATYPEOFRelationshipResponse(createdTermISATypeOFRelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermISATypeOFRelationship(String serverName, String userId, String guid) {
        String restAPIName = "getTermISATypeOFRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermISATypeOFRelationship updatedTermISATypeOFRelationship = handler.getTermISATypeOFRelationship(userId, guid);
            response = new TermISATYPEOFRelationshipResponse(updatedTermISATypeOFRelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermISATypeOFRelationship(String serverName, String userId, TermISATypeOFRelationship termISATypeOFRelationship, boolean isReplace) {
        String restAPIName = "updateTermISATypeOFRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                TermISATypeOFRelationship updatedTermISATypeOFRelationship = handler.replaceTermISATypeOFRelationship(userId, termISATypeOFRelationship);
                response = new TermISATYPEOFRelationshipResponse(updatedTermISATypeOFRelationship);
            } else {
                TermISATypeOFRelationship updatedTermISATypeOFRelationship = handler.updateTermISATypeOFRelationship(userId, termISATypeOFRelationship);
                response = new TermISATYPEOFRelationshipResponse(updatedTermISATypeOFRelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermISATypeOFRelationship(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteTermISATypeOFRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeTermISATypeOFRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                TermISATypeOFRelationship deletedTermISATypeOFRelationship = handler.deleteTermISATypeOFRelationship(userId, guid);
                response = new TermISATYPEOFRelationshipResponse(deletedTermISATypeOFRelationship);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermISATypeOFRelationship(String serverName, String userId, String guid) {
        String restAPIName = "restoreTermISATypeOFRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermISATypeOFRelationship restoredTermISATypeOFRelationship = handler.restoreIsaTypeOfRelationship(userId, guid);
            response = new TermISATYPEOFRelationshipResponse(restoredTermISATypeOFRelationship);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createTermCategorization(String serverName, String userId, TermCategorizationRelationship termCategorization) {
        String restAPIName = "createTermCategorization";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermCategorizationRelationship createdTermCategorization = handler.createTermCategorizationRelationship(userId, termCategorization);
            response = new TermCategorizationRelationshipResponse(createdTermCategorization);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermCategorization(String serverName, String userId, String guid) {
        String restAPIName = "getTermCategorization";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermCategorizationRelationship updatedTermCategorization = handler.getTermCategorizationRelationship(userId, guid);
            response = new TermCategorizationRelationshipResponse(updatedTermCategorization);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermCategorization(String serverName, String userId, TermCategorizationRelationship termCategorization, boolean isReplace) {
        String restAPIName = "updateTermCategorization";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                TermCategorizationRelationship updatedTermCategorization = handler.replaceTermCategorizationRelationship(userId, termCategorization);
                response = new TermCategorizationRelationshipResponse(updatedTermCategorization);
            } else {
                TermCategorizationRelationship updatedTermCategorization = handler.updateTermCategorizationRelationship(userId, termCategorization);
                response = new TermCategorizationRelationshipResponse(updatedTermCategorization);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermCategorization(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteTermCategorization";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeTermCategorizationRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                TermCategorizationRelationship deletedTermCategorization = handler.deleteTermCategorizationRelationship(userId, guid);
                response = new TermCategorizationRelationshipResponse(deletedTermCategorization);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermCategorization(String serverName, String userId, String guid) {
        String restAPIName = "restoreTermCategorization";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermCategorizationRelationship restoredTermCategorization = handler.restoreTermCategorizationRelationship(userId, guid);
            response = new TermCategorizationRelationshipResponse(restoredTermCategorization);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createTermAnchor(String serverName, String userId, TermAnchorRelationship termAnchor) {
        String restAPIName = "createTermAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermAnchorRelationship createdTermAnchor = handler.createTermAnchorRelationship(userId, termAnchor);
            response = new TermAnchorRelationshipResponse(createdTermAnchor);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermAnchor(String serverName, String userId, String guid) {
        String restAPIName = "getTermAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermAnchorRelationship updatedTermAnchor = handler.getTermAnchorRelationship(userId, guid);
            response = new TermAnchorRelationshipResponse(updatedTermAnchor);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTermAnchor(String serverName, String userId, TermAnchorRelationship termAnchor, boolean isReplace) {
        String restAPIName = "updateTermAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                TermAnchorRelationship updatedTermAnchor = handler.replaceTermAnchorRelationship(userId, termAnchor);
                response = new TermAnchorRelationshipResponse(updatedTermAnchor);
            } else {
                TermAnchorRelationship updatedTermAnchor = handler.updateTermAnchorRelationship(userId, termAnchor);
                response = new TermAnchorRelationshipResponse(updatedTermAnchor);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTermAnchor(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteTermAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeTermAnchorRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                TermAnchorRelationship deletedTermAnchor = handler.deleteTermAnchorRelationship(userId, guid);
                response = new TermAnchorRelationshipResponse(deletedTermAnchor);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTermAnchor(String serverName, String userId, String guid) {
        String restAPIName = "restoreTermAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            TermAnchorRelationship restoredTermAnchor = handler.restoreTermAnchorRelationship(userId, guid);
            response = new TermAnchorRelationshipResponse(restoredTermAnchor);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createCategoryAnchor(String serverName, String userId, CategoryAnchorRelationship categoryAnchor) {
        String restAPIName = "createCategoryAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            CategoryAnchorRelationship createdCategoryAnchor = handler.createCategoryAnchorRelationship(userId, categoryAnchor);
            response = new CategoryAnchorRelationshipResponse(createdCategoryAnchor);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getCategoryAnchor(String serverName, String userId, String guid) {
        String restAPIName = "getCategoryAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            CategoryAnchorRelationship updatedCategoryAnchor = handler.getCategoryAnchorRelationship(userId, guid);
            response = new CategoryAnchorRelationshipResponse(updatedCategoryAnchor);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateCategoryAnchor(String serverName, String userId, CategoryAnchorRelationship categoryAnchor, boolean isReplace) {
        String restAPIName = "updateCategoryAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                CategoryAnchorRelationship updatedCategoryAnchor = handler.replaceCategoryAnchorRelationship(userId, categoryAnchor);
                response = new CategoryAnchorRelationshipResponse(updatedCategoryAnchor);
            } else {
                CategoryAnchorRelationship updatedCategoryAnchor = handler.updateCategoryAnchorRelationship(userId, categoryAnchor);
                response = new CategoryAnchorRelationshipResponse(updatedCategoryAnchor);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteCategoryAnchor(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteCategoryAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeCategoryAnchorRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                CategoryAnchorRelationship deletedCategoryAnchor = handler.deleteCategoryAnchorRelationship(userId, guid);
                response = new CategoryAnchorRelationshipResponse(deletedCategoryAnchor);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreCategoryAnchor(String serverName, String userId, String guid) {
        String restAPIName = "restoreCategoryAnchor";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            CategoryAnchorRelationship restoredCategoryAnchor = handler.restoreCategoryAnchorRelationship(userId, guid);
            response = new CategoryAnchorRelationshipResponse(restoredCategoryAnchor);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse createProjectScope(String serverName, String userId, ProjectScopeRelationship projectScope) {
        String restAPIName = "createProjectScope";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ProjectScopeRelationship createdProjectScope = handler.createProjectScopeRelationship(userId, projectScope);
            response = new ProjectScopeRelationshipResponse(createdProjectScope);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getProjectScope(String serverName, String userId, String guid) {
        String restAPIName = "getProjectScope";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ProjectScopeRelationship updatedProjectScope = handler.getProjectScopeRelationship(userId, guid);
            response = new ProjectScopeRelationshipResponse(updatedProjectScope);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateProjectScope(String serverName, String userId, ProjectScopeRelationship projectScope, boolean isReplace) {
        String restAPIName = "updateProjectScope";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isReplace) {
                ProjectScopeRelationship updatedProjectScope = handler.replaceProjectScopeRelationship(userId, projectScope);
                response = new ProjectScopeRelationshipResponse(updatedProjectScope);
            } else {
                ProjectScopeRelationship updatedProjectScope = handler.updateProjectScopeRelationship(userId, projectScope);
                response = new ProjectScopeRelationshipResponse(updatedProjectScope);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteProjectScope(String serverName, String userId, String guid, Boolean isPurge) {
        String restAPIName = "deleteProjectScope";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            if (isPurge.booleanValue()) {
                handler.purgeProjectScopeRelationship(userId, guid);
                response = new VoidResponse();
            } else {
                ProjectScopeRelationship deletedProjectScope = handler.deleteProjectScopeRelationship(userId, guid);
                response = new ProjectScopeRelationshipResponse(deletedProjectScope);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreProjectScope(String serverName, String userId, String guid) {
        String restAPIName = "restoreProjectScope";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            ProjectScopeRelationship restoredProjectScope = handler.restoreProjectScopeRelationship(userId, guid);
            response = new ProjectScopeRelationshipResponse(restoredProjectScope);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getSemanticAssignmentRelationship(String serverName, String userId, String guid) {
        String restAPIName = "getSemanticAssignmentRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, restAPIName);
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, restAPIName);
            RelationshipHandler handler = instanceHandler.getRelationshipHandler(serverName, userId, restAPIName);
            SemanticAssignment updatedSemanticAssignment = handler.getSemanticAssignmentRelationship(userId, guid);
            response = new SemanticAssignementRelationshipResponse(updatedSemanticAssignment);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, restAPIName);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

