/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.LinesResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.TermsResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.VoidResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.TermHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryAuthorViewTermRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewTermRESTServices.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);

    public SubjectAreaOMASAPIResponse createTerm(String serverName, String userId, Term suppliedTerm) {
        String methodName = "createTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTerm");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createTerm");
            TermHandler handler = instanceHandler.getTermHandler(serverName, userId, "createTerm");
            Term createdTerm = handler.createTerm(userId, suppliedTerm);
            response = new TermResponse(createdTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "createTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTerm(String serverName, String userId, String guid) {
        String methodName = "getTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTerm");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTerm");
            TermHandler handler = instanceHandler.getTermHandler(serverName, userId, "getTerm");
            Term obtainedTerm = handler.getTermByGuid(userId, guid);
            response = new TermResponse(obtainedTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse findTerm(String serverName, String userId, Date asOfTime, String searchCriteria, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTerm");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTerm");
            TermHandler handler = instanceHandler.getTermHandler(serverName, userId, "findTerm");
            if (offset == null) {
                offset = new Integer(0);
            }
            if (pageSize == null) {
                pageSize = new Integer(0);
            }
            List<Term> terms = handler.findTerm(userId, searchCriteria, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            TermsResponse termsResponse = new TermsResponse();
            termsResponse.setTerms(terms);
            response = termsResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "findTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse getTermRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getTermRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermRelationships");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermRelationships");
            TermHandler handler = instanceHandler.getTermHandler(serverName, userId, "getTermRelationships");
            List<Line> lines = handler.getTermRelationships(userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
            LinesResponse linesResponse = new LinesResponse();
            linesResponse.setLines(lines);
            response = linesResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "getTermRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse updateTerm(String serverName, String userId, String guid, Term term, Boolean isReplace) {
        String methodName = "updateTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTerm");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTerm");
            TermHandler handler = instanceHandler.getTermHandler(serverName, userId, "updateTerm");
            if (isReplace == null) {
                isReplace = false;
            }
            Term updatedTerm = isReplace != false ? handler.replaceTerm(userId, guid, term) : handler.updateTerm(userId, guid, term);
            TermResponse termResponse = new TermResponse();
            termResponse.setTerm(updatedTerm);
            response = termResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "updateTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse deleteTerm(String serverName, String userId, String guid, Boolean isPurge) {
        String methodName = "deleteTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTerm");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTerm");
            TermHandler handler = instanceHandler.getTermHandler(serverName, userId, "deleteTerm");
            if (isPurge == null) {
                isPurge = false;
            }
            if (isPurge.booleanValue()) {
                handler.purgeTerm(userId, guid);
                response = new VoidResponse();
            } else {
                Term term = handler.deleteTerm(userId, guid);
                TermResponse termResponse = new TermResponse();
                termResponse.setTerm(term);
                response = termResponse;
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "deleteTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse restoreTerm(String serverName, String userId, String guid) {
        String methodName = "restoreTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreTerm");
        SubjectAreaOMASAPIResponse response = null;
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreTerm");
            TermHandler handler = instanceHandler.getTermHandler(serverName, userId, "restoreTerm");
            Term term = handler.restoreTerm(userId, guid);
            TermResponse termResponse = new TermResponse();
            termResponse.setTerm(term);
            response = termResponse;
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, "restoreTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

