/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.SubjectAreaErrorCode;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.SubjectAreaCheckedException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UnexpectedResponseException;
import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.subjectarea.responses.InvalidParameterExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UnexpectedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.responses.UserNotAuthorizedExceptionResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.DetectUtils;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.viewservices.glossaryauthor.auditlog.GlossaryAuthorViewAuditCode;
import org.odpi.openmetadata.viewservices.glossaryauthor.initialization.GlossaryAuthorViewInstanceHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewGlossaryRESTServices;
import org.slf4j.LoggerFactory;

public abstract class BaseGlossaryAuthorView {
    protected static GlossaryAuthorViewInstanceHandler instanceHandler = new GlossaryAuthorViewInstanceHandler();
    protected static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryAuthorViewGlossaryRESTServices.class), instanceHandler.getServiceName());

    protected SubjectAreaOMASAPIResponse getResponseForError(Throwable error, AuditLog auditLog, String className, String methodName) {
        SubjectAreaOMASAPIResponse response = null;
        if (error instanceof OCFCheckedExceptionBase) {
            response = this.getResponseFromOCFCheckedExceptionBase((OCFCheckedExceptionBase)error, className, methodName);
        } else if (error instanceof SubjectAreaCheckedException) {
            response = DetectUtils.getResponseFromException((SubjectAreaCheckedException)((SubjectAreaCheckedException)error));
        } else {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition();
            messageDefinition.setMessageParameters(new String[]{error.getMessage()});
            response = new UnexpectedExceptionResponse((SubjectAreaCheckedException)new UnexpectedResponseException(messageDefinition, className, methodName, error));
            if (auditLog != null) {
                auditLog.logException(methodName, GlossaryAuthorViewAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), methodName, error.getMessage()), error);
            }
        }
        return response;
    }

    private SubjectAreaOMASAPIResponse getResponseFromOCFCheckedExceptionBase(OCFCheckedExceptionBase ocfCheckedExceptionBase, String className, String methodName) {
        UserNotAuthorizedExceptionResponse response = null;
        if (ocfCheckedExceptionBase instanceof InvalidParameterException) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_PARAMETER.getMessageDefinition();
            String invalidPropertyName = ((InvalidParameterException)ocfCheckedExceptionBase).getParameterName();
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException e = new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, methodName, invalidPropertyName, null);
            response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)e);
        } else if (ocfCheckedExceptionBase instanceof org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException) {
            String userId = ((org.odpi.openmetadata.commonservices.ffdc.exceptions.UserNotAuthorizedException)ocfCheckedExceptionBase).getUserId();
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(new String[]{userId});
            UserNotAuthorizedException e = new UserNotAuthorizedException(messageDefinition, className, methodName, userId);
            response = new UserNotAuthorizedExceptionResponse((SubjectAreaCheckedException)e);
        } else if (ocfCheckedExceptionBase instanceof PropertyServerException) {
            ExceptionMessageDefinition messageDefinition = SubjectAreaErrorCode.INVALID_PARAMETER.getMessageDefinition();
            String invalidPropertyName = ((InvalidParameterException)ocfCheckedExceptionBase).getParameterName();
            messageDefinition.setMessageParameters(new String[]{invalidPropertyName, null});
            org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException e = new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, methodName, invalidPropertyName, null);
            response = new InvalidParameterExceptionResponse((SubjectAreaCheckedException)e);
        }
        return response;
    }
}

