/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.handlers;

import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.categories.SubjectAreaCategory;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class CategoryHandler {
    private SubjectAreaCategory subjectAreaCategory;

    public CategoryHandler(SubjectAreaCategory subjectAreaCategory) {
        this.subjectAreaCategory = subjectAreaCategory;
    }

    public Category createCategory(String userId, Category suppliedCategory) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return (Category)this.subjectAreaCategory.category().create(userId, (Object)suppliedCategory);
    }

    public Category getCategoryByGuid(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Category)this.subjectAreaCategory.category().getByGUID(userId, guid);
    }

    public List<Category> findCategory(String userId, FindRequest findRequest) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.subjectAreaCategory.category().find(userId, findRequest);
    }

    public Category replaceCategory(String userId, String guid, Category suppliedCategory) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Category)this.subjectAreaCategory.category().replace(userId, guid, (Object)suppliedCategory);
    }

    public Category updateCategory(String userId, String guid, Category suppliedCategory) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Category)this.subjectAreaCategory.category().update(userId, guid, (Object)suppliedCategory);
    }

    public void deleteCategory(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.subjectAreaCategory.category().delete(userId, guid);
    }

    public void purgeCategory(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.subjectAreaCategory.category().purge(userId, guid);
    }

    public Category restoreCategory(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Category)this.subjectAreaCategory.category().restore(userId, guid);
    }

    public List<Line> getCategoryRelationships(String userId, String guid, FindRequest findRequest) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return this.subjectAreaCategory.category().getRelationships(userId, guid, findRequest);
    }
}

