/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.handlers;

import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.entities.projects.SubjectAreaProject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class ProjectHandler {
    private SubjectAreaProject subjectAreaProject;

    public ProjectHandler(SubjectAreaProject subjectAreaProject) {
        this.subjectAreaProject = subjectAreaProject;
    }

    public Project createProject(String userId, Project suppliedProject) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return (Project)this.subjectAreaProject.project().create(userId, (Object)suppliedProject);
    }

    public Project getProjectByGuid(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Project)this.subjectAreaProject.project().getByGUID(userId, guid);
    }

    public List<Line> getProjectRelationships(String userId, String guid, FindRequest findRequest) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.subjectAreaProject.project().getRelationships(userId, guid, findRequest);
    }

    public List<Project> findProject(String userId, FindRequest findRequest) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.subjectAreaProject.project().find(userId, findRequest);
    }

    public Project replaceProject(String userId, String guid, Project suppliedProject) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Project)this.subjectAreaProject.project().replace(userId, guid, (Object)suppliedProject);
    }

    public Project updateProject(String userId, String guid, Project suppliedProject) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Project)this.subjectAreaProject.project().update(userId, guid, (Object)suppliedProject);
    }

    public void deleteProject(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.subjectAreaProject.project().delete(userId, guid);
    }

    public void purgeProject(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.subjectAreaProject.project().purge(userId, guid);
    }

    public Project restoreProject(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return (Project)this.subjectAreaProject.project().restore(userId, guid);
    }
}

