/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.GlossaryHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewGlossaryRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewGlossaryRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(String serverName, String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "createGlossary");
            Glossary createdGlossary = handler.createGlossary(userId, suppliedGlossary);
            response.addResult((Object)createdGlossary);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "createGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> getGlossary(String serverName, String userId, String guid) {
        String methodName = "getGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "getGlossary");
            Glossary obtainedGlossary = handler.getGlossaryByGuid(userId, guid);
            response.addResult((Object)obtainedGlossary);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(String serverName, String userId, Date asOfTime, String searchCriteria, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "findGlossary");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset.intValue());
            findRequest.setPageSize(pageSize.intValue());
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List<Glossary> glossaries = handler.findGlossary(userId, findRequest);
            response.addAllResults(glossaries);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "findGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getGlossaryRelationships(String serverName, String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryRelationships");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryRelationships");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "getGlossaryRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset);
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List<Line> lines = handler.getGlossaryRelationships(userId, guid, findRequest);
            response.addAllResults(lines);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getGlossaryRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(String serverName, String userId, String guid, Glossary glossary, boolean isReplace) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "updateGlossary");
            Glossary updatedGlossary = isReplace ? handler.replaceGlossary(userId, guid, glossary) : handler.updateGlossary(userId, guid, glossary);
            response.addResult((Object)updatedGlossary);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "updateGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(String serverName, String userId, String guid, boolean isPurge) {
        String methodName = "deleteGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "deleteGlossary");
            if (isPurge) {
                handler.purgeGlossary(userId, guid);
            } else {
                handler.deleteGlossary(userId, guid);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "deleteGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(String serverName, String userId, String guid) {
        String methodName = "restoreGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreGlossary");
            GlossaryHandler handler = instanceHandler.getGlossaryHandler(serverName, userId, "restoreGlossary");
            Glossary glossary = handler.restoreGlossary(userId, guid);
            response.addResult((Object)glossary);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "restoreGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

