/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.ProjectHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewProjectRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewProjectRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Project> createProject(String serverName, String userId, Project suppliedProject) {
        String methodName = "createProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "createProject");
            Project createdProject = handler.createProject(userId, suppliedProject);
            response.addResult((Object)createdProject);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "createProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> getProject(String serverName, String userId, String guid) {
        String methodName = "getProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "getProject");
            Project obtainedProject = handler.getProjectByGuid(userId, guid);
            response.addResult((Object)obtainedProject);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> findProject(String serverName, String userId, Date asOfTime, String searchCriteria, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "findProject");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset);
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List<Project> projects = handler.findProject(userId, findRequest);
            response.addAllResults(projects);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "findProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getProjectRelationships(String serverName, String userId, String guid, Date asOfTime, Integer offset, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getProjectRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProjectRelationships");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectRelationships");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "getProjectRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset.intValue());
            findRequest.setPageSize(pageSize.intValue());
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List<Line> lines = handler.getProjectRelationships(userId, guid, findRequest);
            response.addAllResults(lines);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getProjectRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> updateProject(String serverName, String userId, String guid, Project project, boolean isReplace) {
        String methodName = "updateProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "updateProject");
            Project updatedProject = isReplace ? handler.replaceProject(userId, guid, project) : handler.updateProject(userId, guid, project);
            response.addResult((Object)updatedProject);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "updateProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> deleteProject(String serverName, String userId, String guid, boolean isPurge) {
        String methodName = "deleteProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "deleteProject");
            if (isPurge) {
                handler.purgeProject(userId, guid);
            } else {
                handler.deleteProject(userId, guid);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "deleteProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> restoreProject(String serverName, String userId, String guid) {
        String methodName = "restoreProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreProject");
            ProjectHandler handler = instanceHandler.getProjectHandler(serverName, userId, "restoreProject");
            Project project = handler.restoreProject(userId, guid);
            response.addResult((Object)project);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "restoreProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

