/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewCategoryRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewCategoryRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Category> createCategory(String serverName, String userId, Category suppliedCategory) {
        String methodName = "createCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "createCategory");
            Category createdCategory = (Category)clients.categories().create(userId, (Object)suppliedCategory);
            response.addResult((Object)createdCategory);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "createCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategory(String serverName, String userId, String guid) {
        String methodName = "getCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getCategory");
            Category obtainedCategory = (Category)clients.categories().getByGUID(userId, guid);
            response.addResult((Object)obtainedCategory);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> findCategory(String serverName, String userId, Date asOfTime, String searchCriteria, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "findCategory");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset);
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List categories = clients.categories().find(userId, findRequest);
            response.addAllResults((Collection)categories);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "findCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getCategoryRelationships(String serverName, String userId, String guid, Date asOfTime, int offset, int pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getCategoryRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoryRelationships");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoryRelationships");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getCategoryRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setOffset(offset);
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List lines = clients.categories().getRelationships(userId, guid, findRequest);
            response.addAllResults((Collection)lines);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getCategoryRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> updateCategory(String serverName, String userId, String guid, Category category, boolean isReplace) {
        String methodName = "updateCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "updateCategory");
            Category updatedCategory = isReplace ? (Category)clients.categories().replace(userId, guid, (Object)category) : (Category)clients.categories().update(userId, guid, (Object)category);
            response.addResult((Object)updatedCategory);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "updateCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> deleteCategory(String serverName, String userId, String guid, boolean isPurge) {
        String methodName = "deleteCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "deleteCategory");
            if (isPurge) {
                clients.categories().purge(userId, guid);
            } else {
                clients.categories().delete(userId, guid);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "deleteCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> restoreCategory(String serverName, String userId, String guid) {
        String methodName = "restoreCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "restoreCategory");
            Category category = (Category)clients.categories().restore(userId, guid);
            response.addResult((Object)category);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "restoreCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

