/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.configs.SubjectAreaConfigClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.terms.SubjectAreaTermClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Config;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewTermRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewTermRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Term> createTerm(String serverName, String userId, Term suppliedTerm) {
        String methodName = "createTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTerm");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createTerm");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "createTerm");
            Term createdTerm = (Term)clients.terms().create(userId, (Object)suppliedTerm);
            response.addResult((Object)createdTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "createTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getTerm(String serverName, String userId, String guid) {
        String methodName = "getTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTerm");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTerm");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getTerm");
            Term obtainedTerm = (Term)clients.terms().getByGUID(userId, guid);
            response.addResult((Object)obtainedTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> findTerm(String serverName, String userId, Date asOfTime, String searchCriteria, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTerm");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            if (startingFrom == null) {
                startingFrom = 0;
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "findTerm");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTerm");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "findTerm");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            SubjectAreaConfigClient client = instanceHandler.getSubjectAreaConfigClient(serverName, userId, "findTerm");
            Config subjectAreaConfig = client.getConfig(userId);
            List terms = clients.terms().find(userId, findRequest, subjectAreaConfig.getMaxPageSize());
            response.addAllResults((Collection)terms);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "findTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getTermRelationships(String serverName, String userId, String guid, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getTermRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermRelationships");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            if (startingFrom == null) {
                startingFrom = 0;
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getTermRelationships");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermRelationships");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getTermRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List lines = clients.terms().getRelationships(userId, guid, findRequest);
            response.addAllResults((Collection)lines);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getTermRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> updateTerm(String serverName, String userId, String guid, Term term, boolean isReplace) {
        String methodName = "updateTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTerm");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTerm");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "updateTerm");
            Term updatedTerm = isReplace ? (Term)clients.terms().replace(userId, guid, (Object)term) : (Term)clients.terms().update(userId, guid, (Object)term);
            response.addResult((Object)updatedTerm);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "updateTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> deleteTerm(String serverName, String userId, String guid, boolean isPurge) {
        String methodName = "deleteTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTerm");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTerm");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "deleteTerm");
            if (isPurge) {
                clients.terms().purge(userId, guid);
            } else {
                clients.terms().delete(userId, guid);
            }
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "deleteTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> restoreTerm(String serverName, String userId, String guid) {
        String methodName = "restoreTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreTerm");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreTerm");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "restoreTerm");
            Term term = (Term)clients.terms().restore(userId, guid);
            response.addResult((Object)term);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "restoreTerm");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategories(String serverName, String userId, String guid, Integer startingFrom, Integer pageSize) {
        String methodName = "getCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategories");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        FindRequest findRequest = new FindRequest();
        if (pageSize == null) {
            pageSize = invalidParameterHandler.getMaxPagingSize();
        }
        if (startingFrom == null) {
            startingFrom = 0;
        }
        try {
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getCategories");
            findRequest.setPageSize(pageSize);
            findRequest.setStartingFrom(startingFrom.intValue());
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategories");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getCategories");
            List categories = ((SubjectAreaTermClient)clients.categories()).getCategories(userId, guid, findRequest);
            response.addAllResults((Collection)categories);
        }
        catch (Throwable error) {
            response = this.getResponseForError(error, auditLog, className, "getCategories");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

