/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.configs.SubjectAreaConfigClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Config;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Line;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewProjectRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewProjectRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Project> createProject(String serverName, String userId, Project suppliedProject) {
        String methodName = "createProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createProject");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "createProject");
            Project createdProject = (Project)clients.projects().create(userId, (Object)suppliedProject);
            response.addResult((Object)createdProject);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "createProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> getProject(String serverName, String userId, String guid) {
        String methodName = "getProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProject");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getProject");
            Project obtainedProject = (Project)clients.projects().getByGUID(userId, guid);
            response.addResult((Object)obtainedProject);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> findProject(String serverName, String userId, Date asOfTime, String searchCriteria, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (startingFrom == null) {
                startingFrom = 0;
            }
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "findProject");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findProject");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "findProject");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            SubjectAreaConfigClient client = instanceHandler.getSubjectAreaConfigClient(serverName, userId, "findProject");
            Config subjectAreaConfig = client.getConfig(userId);
            List projects = clients.projects().find(userId, findRequest, subjectAreaConfig.getMaxPageSize());
            response.addAllResults((Collection)projects);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "findProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Line> getProjectRelationships(String serverName, String userId, String guid, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getProjectRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getProjectRelationships");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (startingFrom == null) {
                startingFrom = 0;
            }
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getProjectRelationships");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getProjectRelationships");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getProjectRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List lines = clients.projects().getRelationships(userId, guid, findRequest);
            response.addAllResults((Collection)lines);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getProjectRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> updateProject(String serverName, String userId, String guid, Project project, boolean isReplace) {
        String methodName = "updateProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateProject");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "updateProject");
            Project updatedProject = isReplace ? (Project)clients.projects().replace(userId, guid, (Object)project) : (Project)clients.projects().update(userId, guid, (Object)project);
            response.addResult((Object)updatedProject);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "updateProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> deleteProject(String serverName, String userId, String guid, boolean isPurge) {
        String methodName = "deleteProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteProject");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "deleteProject");
            if (isPurge) {
                clients.projects().purge(userId, guid);
            } else {
                clients.projects().delete(userId, guid);
            }
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "deleteProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Project> restoreProject(String serverName, String userId, String guid) {
        String methodName = "restoreProject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreProject");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreProject");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "restoreProject");
            Project project = (Project)clients.projects().restore(userId, guid);
            response.addResult((Object)project);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "restoreProject");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

