/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.configs.SubjectAreaConfigClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.glossaries.SubjectAreaGlossaryClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Config;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.handlers.BreadCrumbHandler;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.BreadCrumb;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewGlossaryRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewGlossaryRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(String serverName, String userId, Glossary suppliedGlossary) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "createGlossary");
            Glossary createdGlossary = (Glossary)clients.glossaries().create(userId, (Object)suppliedGlossary);
            response.addResult((Object)createdGlossary);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "createGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> getGlossary(String serverName, String userId, String guid) {
        String methodName = "getGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossary");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getGlossary");
            Glossary obtainedGlossary = (Glossary)clients.glossaries().getByGUID(userId, guid);
            response.addResult((Object)obtainedGlossary);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(String serverName, String userId, Date asOfTime, String searchCriteria, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (startingFrom == null) {
                startingFrom = 0;
            }
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            if (sequencingOrder == null) {
                sequencingOrder = SequencingOrder.ANY;
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "findGlossary");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossary");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "findGlossary");
            FindRequest findRequest = this.getFindRequest(searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder.name(), sequencingProperty, invalidParameterHandler.getMaxPagingSize());
            SubjectAreaConfigClient client = instanceHandler.getSubjectAreaConfigClient(serverName, userId, "findGlossary");
            Config subjectAreaConfig = client.getConfig(userId);
            List glossaries = clients.glossaries().find(userId, findRequest, subjectAreaConfig.getMaxPageSize());
            response.addAllResults((Collection)glossaries);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "findGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getGlossaryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getGlossaryRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryRelationships");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getGlossaryRelationships");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryRelationships");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getGlossaryRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List relationships = clients.glossaries().getRelationships(userId, guid, findRequest);
            response.addAllResults((Collection)relationships);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getGlossaryRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(String serverName, String userId, String guid, Glossary glossary, boolean isReplace) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "updateGlossary");
            Glossary updatedGlossary = isReplace ? (Glossary)clients.glossaries().replace(userId, guid, (Object)glossary) : (Glossary)clients.glossaries().update(userId, guid, (Object)glossary);
            response.addResult((Object)updatedGlossary);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "updateGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(String serverName, String userId, String guid, boolean isPurge) {
        String methodName = "deleteGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteGlossary");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "deleteGlossary");
            if (isPurge) {
                clients.glossaries().purge(userId, guid);
            } else {
                clients.glossaries().delete(userId, guid);
            }
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "deleteGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(String serverName, String userId, String guid) {
        String methodName = "restoreGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreGlossary");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "restoreGlossary");
            Glossary glossary = (Glossary)clients.glossaries().restore(userId, guid);
            response.addResult((Object)glossary);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "restoreGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<SubjectAreaOMASAPIResponse<Term>> createMultipleTermsInAGlossary(String serverName, String userId, String guid, Term[] terms) {
        String methodName = "createMultipleTermsInAGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMultipleTermsInAGlossary");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMultipleTermsInAGlossary");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "createMultipleTermsInAGlossary");
            for (Term term : terms) {
                GlossarySummary glossarySummary = new GlossarySummary();
                glossarySummary.setGuid(guid);
                term.setGlossary(glossarySummary);
                SubjectAreaOMASAPIResponse termResponse = new SubjectAreaOMASAPIResponse();
                try {
                    Term createdTerm = (Term)clients.terms().create(userId, (Object)term);
                    termResponse.addResult((Object)createdTerm);
                }
                catch (Exception exception) {
                    termResponse = this.getResponseForException(exception, auditLog, className, "createMultipleTermsInAGlossary");
                }
                response.addResult(termResponse);
            }
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "createMultipleTermsInAGlossary");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<BreadCrumb> getBreadCrumbTrail(String serverName, String userId, String guid, String rootCategoryGuid, String leafCategoryGuid, String termGuid) {
        String methodName = "getBreadCrumbTrail";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getBreadCrumbTrail");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getBreadCrumbTrail");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getBreadCrumbTrail");
            BreadCrumbHandler breadCrumbHandler = new BreadCrumbHandler(clients, userId);
            List<BreadCrumb> breadCrumbs = breadCrumbHandler.getBreadCrumbTrail(guid, rootCategoryGuid, leafCategoryGuid, termGuid);
            response.addAllResults(breadCrumbs);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getBreadCrumbTrail");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategories(String serverName, String userId, String guid, String searchCriteria, Date asOfTime, Boolean onlyTop, Integer startingFrom, Integer pageSize, String sequencingOrder, String sequencingProperty) {
        String methodName = "getCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategories");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        FindRequest findRequest = this.getFindRequest(searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty, invalidParameterHandler.getMaxPagingSize());
        try {
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getCategories");
            findRequest.setPageSize(pageSize);
            findRequest.setStartingFrom(startingFrom.intValue());
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategories");
            SubjectAreaConfigClient client = instanceHandler.getSubjectAreaConfigClient(serverName, userId, "getCategories");
            Config subjectAreaConfig = client.getConfig(userId);
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getCategories");
            List categories = ((SubjectAreaGlossaryClient)clients.glossaries()).getCategories(userId, guid, findRequest, onlyTop, subjectAreaConfig.getMaxPageSize());
            response.addAllResults((Collection)categories);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getCategories");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getTerms(String serverName, String userId, String guid, String searchCriteria, Date asOfTime, Integer startingFrom, Integer pageSize, String sequencingOrder, String sequencingProperty) {
        String methodName = "getTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTerms");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        FindRequest findRequest = this.getFindRequest(searchCriteria, asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty, invalidParameterHandler.getMaxPagingSize());
        try {
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getTerms");
            findRequest.setPageSize(pageSize);
            findRequest.setStartingFrom(startingFrom.intValue());
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTerms");
            SubjectAreaConfigClient client = instanceHandler.getSubjectAreaConfigClient(serverName, userId, "getTerms");
            Config subjectAreaConfig = client.getConfig(userId);
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getTerms");
            List terms = ((SubjectAreaGlossaryClient)clients.glossaries()).getTerms(userId, guid, findRequest, subjectAreaConfig.getMaxPageSize());
            response.addAllResults((Collection)terms);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getTerms");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

