/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.categories.SubjectAreaCategoryClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Config;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewConfigRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewConfigRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Config> getConfig(String serverName, String userId, String guid) {
        String methodName = "getConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfig");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfig");
            int glossaryViewMaxMageSize = instanceHandler.getGlossaryViewMaxPageSize(serverName, userId, "getConfig");
            Config config = new Config();
            config.setMaxPageSize(Integer.valueOf(glossaryViewMaxMageSize));
            response.addResult((Object)config);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getConfig");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> findCategory(String serverName, String userId, Date asOfTime, String searchCriteria, boolean exactValue, boolean ignoreCase, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "findCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (startingFrom == null) {
                startingFrom = 0;
            }
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "findCategory");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "findCategory");
            FindRequest findRequest = new FindRequest();
            findRequest.setSearchCriteria(searchCriteria);
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List categories = clients.categories().find(userId, findRequest, exactValue, ignoreCase);
            response.addAllResults((Collection)categories);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "findCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Relationship> getCategoryRelationships(String serverName, String userId, String guid, Date asOfTime, Integer startingFrom, Integer pageSize, SequencingOrder sequencingOrder, String sequencingProperty) {
        String methodName = "getCategoryRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoryRelationships");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            if (pageSize == null) {
                pageSize = invalidParameterHandler.getMaxPagingSize();
            }
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getCategoryRelationships");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoryRelationships");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getCategoryRelationships");
            FindRequest findRequest = new FindRequest();
            findRequest.setAsOfTime(asOfTime);
            findRequest.setStartingFrom(startingFrom.intValue());
            findRequest.setPageSize(pageSize);
            findRequest.setSequencingOrder(sequencingOrder);
            findRequest.setSequencingProperty(sequencingProperty);
            List relationships = clients.categories().getRelationships(userId, guid, findRequest);
            response.addAllResults((Collection)relationships);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getCategoryRelationships");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> updateCategory(String serverName, String userId, String guid, Category category, boolean isReplace) {
        String methodName = "updateCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "updateCategory");
            Category updatedCategory = isReplace ? (Category)clients.categories().replace(userId, guid, (Object)category) : (Category)clients.categories().update(userId, guid, (Object)category);
            response.addResult((Object)updatedCategory);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "updateCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> deleteCategory(String serverName, String userId, String guid, boolean isPurge) {
        String methodName = "deleteCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "deleteCategory");
            if (isPurge) {
                clients.categories().purge(userId, guid);
            } else {
                clients.categories().delete(userId, guid);
            }
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "deleteCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> restoreCategory(String serverName, String userId, String guid) {
        String methodName = "restoreCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "restoreCategory");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restoreCategory");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "restoreCategory");
            Category category = (Category)clients.categories().restore(userId, guid);
            response.addResult((Object)category);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "restoreCategory");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Category> getCategoryChildren(String serverName, String userId, String guid, Integer startingFrom, Integer pageSize) {
        String methodName = "getCategoryChildren";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoryChildren");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        FindRequest findRequest = new FindRequest();
        if (startingFrom == null) {
            startingFrom = 0;
        }
        if (pageSize == null) {
            pageSize = invalidParameterHandler.getMaxPagingSize();
        }
        try {
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getCategoryChildren");
            findRequest.setPageSize(pageSize);
            findRequest.setStartingFrom(startingFrom.intValue());
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoryChildren");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getCategoryChildren");
            List categories = ((SubjectAreaCategoryClient)clients.categories()).getCategoryChildren(userId, guid, findRequest, false, true);
            response.addAllResults((Collection)categories);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getCategoryChildren");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<Term> getCategorizedTerms(String serverName, String userId, String guid, Integer startingFrom, Integer pageSize) {
        String methodName = "getCategorizedTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategorizedTerms");
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        AuditLog auditLog = null;
        FindRequest findRequest = new FindRequest();
        if (startingFrom == null) {
            startingFrom = 0;
        }
        if (pageSize == null) {
            pageSize = invalidParameterHandler.getMaxPagingSize();
        }
        try {
            invalidParameterHandler.validatePaging(startingFrom.intValue(), pageSize.intValue(), "getCategorizedTerms");
            findRequest.setPageSize(pageSize);
            findRequest.setStartingFrom(startingFrom.intValue());
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategorizedTerms");
            SubjectAreaNodeClients clients = instanceHandler.getSubjectAreaNodeClients(serverName, userId, "getCategorizedTerms");
            List terms = ((SubjectAreaCategoryClient)clients.categories()).getTerms(userId, guid, findRequest, true, false);
            response.addAllResults((Collection)terms);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getCategorizedTerms");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

