/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.services;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.accessservices.subjectarea.client.relationships.SubjectAreaGraphClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.GraphStatistics;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.NodeRelationshipStats;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.BaseGlossaryAuthorView;

public class GlossaryAuthorViewGraphRESTServices
extends BaseGlossaryAuthorView {
    private static String className = GlossaryAuthorViewGraphRESTServices.class.getName();

    public SubjectAreaOMASAPIResponse<Graph> getGraph(String serverName, String userId, String guid, Date asOfTime, String nodeFilterStr, String relationshipFilterStr, StatusFilter statusFilter) {
        String methodName = "getGraph";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGraph");
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGraph");
            Graph graph = this.getGraphObject(serverName, userId, guid, asOfTime, nodeFilterStr, relationshipFilterStr, statusFilter, "getGraph");
            response.addResult((Object)graph);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getGraph");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SubjectAreaOMASAPIResponse<GraphStatistics> getGraphCounts(String serverName, String userId, String guid, Date asOfTime, String nodeFilterStr, String relationshipFilterStr, StatusFilter statusFilter) {
        String methodName = "getGraphStatistics";
        SubjectAreaOMASAPIResponse response = new SubjectAreaOMASAPIResponse();
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGraphStatistics");
        AuditLog auditLog = null;
        try {
            int count;
            NodeRelationshipStats countForNodeOrRelationshipType;
            String typeName;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGraphStatistics");
            Graph graph = this.getGraphObject(serverName, userId, guid, asOfTime, nodeFilterStr, relationshipFilterStr, statusFilter, "getGraphStatistics");
            GraphStatistics graphStatistics = new GraphStatistics(guid, 1);
            Map nodes = graph.getNodes();
            Map relationships = graph.getRelationships();
            HashMap<String, NodeRelationshipStats> nodeCountsMap = new HashMap<String, NodeRelationshipStats>();
            HashMap<String, NodeRelationshipStats> relationshipCountsMap = new HashMap<String, NodeRelationshipStats>();
            if (nodes != null) {
                Set nodeGuids = nodes.keySet();
                for (String nodeGuid : nodeGuids) {
                    Node node = (Node)nodes.get(nodeGuid);
                    typeName = node.getNodeType().name();
                    countForNodeOrRelationshipType = (NodeRelationshipStats)nodeCountsMap.get(typeName);
                    count = 0;
                    if (countForNodeOrRelationshipType != null) {
                        count = countForNodeOrRelationshipType.getCount();
                    }
                    countForNodeOrRelationshipType = new NodeRelationshipStats(typeName, count + 1);
                    nodeCountsMap.put(typeName, countForNodeOrRelationshipType);
                }
            }
            if (relationships != null) {
                Set relationshipGuids = relationships.keySet();
                for (String relationshipGuid : relationshipGuids) {
                    Relationship relationship = (Relationship)relationships.get(relationshipGuid);
                    typeName = relationship.getRelationshipType().name();
                    countForNodeOrRelationshipType = (NodeRelationshipStats)relationshipCountsMap.get(typeName);
                    count = 0;
                    if (countForNodeOrRelationshipType != null) {
                        count = countForNodeOrRelationshipType.getCount();
                    }
                    countForNodeOrRelationshipType = new NodeRelationshipStats(typeName, count + 1);
                    relationshipCountsMap.put(typeName, countForNodeOrRelationshipType);
                }
            }
            graphStatistics.setRelationshipCounts(relationshipCountsMap);
            graphStatistics.setNodeCounts(nodeCountsMap);
            response.addResult((Object)graphStatistics);
        }
        catch (Exception exception) {
            response = this.getResponseForException(exception, auditLog, className, "getGraphStatistics");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private Graph getGraphObject(String serverName, String userId, String guid, Date asOfTime, String nodeFilterStr, String relationshipFilterStr, StatusFilter statusFilter, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Set relationshipTypes;
        Set nodeTypes;
        SubjectAreaGraphClient graphClient = instanceHandler.getSubjectAreaGraphClient(serverName, userId, methodName);
        Stream<NodeType> allNodeTypesStream = Arrays.stream(NodeType.values());
        if (nodeFilterStr == null) {
            nodeTypes = allNodeTypesStream.collect(Collectors.toSet());
            nodeTypes.remove(NodeType.Unknown);
        } else {
            Set typeNames = allNodeTypesStream.map(Enum::name).collect(Collectors.toSet());
            nodeTypes = Arrays.stream(nodeFilterStr.split(",")).filter(typeNames::contains).map(NodeType::valueOf).collect(Collectors.toSet());
        }
        Stream<RelationshipType> allRelationshipTypesStream = Arrays.stream(RelationshipType.values());
        if (relationshipFilterStr == null) {
            relationshipTypes = allRelationshipTypesStream.collect(Collectors.toSet());
            if (relationshipTypes.contains(RelationshipType.Unknown)) {
                relationshipTypes.remove(RelationshipType.Unknown);
            }
        } else {
            Set typeNames = allRelationshipTypesStream.map(Enum::name).collect(Collectors.toSet());
            relationshipTypes = Arrays.stream(relationshipFilterStr.split(",")).filter(typeNames::contains).map(RelationshipType::valueOf).collect(Collectors.toSet());
        }
        return graphClient.getGraph(userId, guid, asOfTime, nodeTypes, relationshipTypes, statusFilter, 1);
    }
}

