/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.admin;

import org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminAuditCode;
import org.odpi.openmetadata.adminservices.ffdc.OMAGAdminErrorCode;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.glossaryauthor.admin.serviceinstances.GlossaryAuthorViewServicesInstance;
import org.odpi.openmetadata.viewservices.glossaryauthor.auditlog.GlossaryAuthorViewAuditCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryAuthorViewAdmin
extends ViewServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(GlossaryAuthorViewAdmin.class);
    private static final Integer MINIMUM_GLOSSARY_AUTHOR_PAGE_SIZE = 101;
    private ViewServiceConfig viewServiceConfig = null;
    private AuditLog auditLog = null;
    private String serverUserName = null;
    private GlossaryAuthorViewServicesInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfigurationProperties, AuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        String methodName = "initialize";
        if (log.isDebugEnabled()) {
            log.debug("==> Method: initialize,userid=" + serverUserName);
        }
        if (maxPageSize < MINIMUM_GLOSSARY_AUTHOR_PAGE_SIZE) {
            String viewServiceFullName = viewServiceConfigurationProperties.getViewServiceFullName();
            auditLog.logMessage("initialize", OMAGAdminAuditCode.VIEW_SERVICE_MAX_PAGE_SIZE_TOO_LOW.getMessageDefinition(new String[]{viewServiceFullName, serverName, MINIMUM_GLOSSARY_AUTHOR_PAGE_SIZE.toString(), "" + maxPageSize}));
            throw new OMAGConfigurationErrorException(OMAGAdminErrorCode.VIEW_SERVICE_MAX_PAGE_SIZE_TOO_LOW.getMessageDefinition(new String[]{viewServiceFullName, serverName, MINIMUM_GLOSSARY_AUTHOR_PAGE_SIZE.toString(), "" + maxPageSize}), ((Object)((Object)this)).getClass().getName(), "initialize");
        }
        auditLog.logMessage("initialize", GlossaryAuthorViewAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            this.viewServiceConfig = viewServiceConfigurationProperties;
            this.auditLog = auditLog;
            this.serverUserName = serverUserName;
            this.serverName = serverName;
            this.instance = new GlossaryAuthorViewServicesInstance(this.serverName, auditLog, serverUserName, maxPageSize, this.viewServiceConfig.getOMAGServerName(), this.viewServiceConfig.getOMAGServerPlatformRootURL());
            this.writeAuditLogPassingErrorMessage(auditLog, "initialize", GlossaryAuthorViewAuditCode.SERVICE_INITIALIZED, serverName);
            if (log.isDebugEnabled()) {
                log.debug("<== Method: initialize,userid=" + serverUserName);
            }
        }
        catch (InvalidParameterException iae) {
            this.writeAuditLogPassingErrorMessage(auditLog, "initialize", GlossaryAuthorViewAuditCode.SERVICE_INSTANCE_FAILURE, iae.getMessage());
            throw new OMAGConfigurationErrorException(iae.getReportedHTTPCode(), iae.getReportingClassName(), iae.getReportingActionDescription(), iae.getReportedErrorMessage(), iae.getReportedErrorMessageId(), iae.getReportedErrorMessageParameters(), iae.getReportedSystemAction(), iae.getReportedUserAction(), iae.getReportedCaughtExceptionClassName(), iae.getRelatedProperties());
        }
    }

    private void writeAuditLogPassingErrorMessage(AuditLog auditLog, String actionDescription, GlossaryAuthorViewAuditCode auditCode, String message) {
        auditLog.logMessage(actionDescription, auditCode.getMessageDefinition(message));
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        log.debug(">>shutdown");
        GlossaryAuthorViewAuditCode auditCode = GlossaryAuthorViewAuditCode.SERVICE_TERMINATING;
        this.writeAuditLogPassingErrorMessage(this.auditLog, "shutdown", auditCode, this.serverName);
        if (this.instance != null) {
            this.instance.shutdown();
        }
        auditCode = GlossaryAuthorViewAuditCode.SERVICE_SHUTDOWN;
        this.writeAuditLogPassingErrorMessage(this.auditLog, "shutdown", auditCode, this.serverName);
        log.debug("<<shutdown");
    }
}

