/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.handlers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.SubjectAreaNodeClients;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.ffdc.GlossaryAuthorErrorCode;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.BreadCrumb;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.BreadCrumbTrail;

public class BreadCrumbHandler {
    static String className = BreadCrumbHandler.class.getName();
    static String restAPIName = "getBreadCrumbTrail";
    List<BreadCrumb> breadCrumbs = new ArrayList<BreadCrumb>();
    Category currentCategory = null;
    private Set<String> guids = new HashSet<String>();
    private SubjectAreaNodeClients clients;
    private String userId;

    public BreadCrumbHandler(SubjectAreaNodeClients clients, String userId) {
        this.clients = clients;
        this.userId = userId;
    }

    private boolean hasParentCategory() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        boolean hasParent = false;
        Category parentCategory = null;
        List categoryRelationships = this.clients.terms().getAllRelationships(this.userId, this.currentCategory.getSystemAttributes().getGUID());
        for (Relationship categoryRelationship : categoryRelationships) {
            String parentCategoryGuid;
            if (!categoryRelationship.getRelationshipType().equals((Object)RelationshipType.CategoryHierarchyLink) || (parentCategoryGuid = categoryRelationship.getEnd1().getNodeGuid()).equals(this.currentCategory.getSystemAttributes().getGUID())) continue;
            parentCategory = (Category)this.clients.categories().getByGUID(this.userId, parentCategoryGuid);
        }
        if (parentCategory != null) {
            hasParent = true;
            this.currentCategory = parentCategory;
        }
        return hasParent;
    }

    public List<BreadCrumb> getBreadCrumbTrail(String glossaryGuid, String rootCategoryGuid, String leafCategoryGuid, String termGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException {
        Category leafCategory = null;
        Category rootCategory = null;
        Glossary glossary = null;
        Term term = null;
        if (leafCategoryGuid != null) {
            leafCategory = (Category)this.clients.categories().getByGUID(this.userId, leafCategoryGuid);
        }
        if (rootCategoryGuid != null) {
            rootCategory = (Category)this.clients.categories().getByGUID(this.userId, rootCategoryGuid);
        }
        if (glossaryGuid != null) {
            glossary = (Glossary)this.clients.glossaries().getByGUID(this.userId, glossaryGuid);
        }
        if (termGuid != null) {
            term = (Term)this.clients.terms().getByGUID(this.userId, termGuid);
        }
        if (termGuid == null) {
            if (leafCategory != null) {
                this.breadCrumbs.add(new BreadCrumb(leafCategoryGuid, leafCategory.getName(), NodeType.Category));
            } else if (rootCategory != null) {
                this.breadCrumbs.add(new BreadCrumb(rootCategoryGuid, rootCategory.getName(), NodeType.Category));
            }
        } else {
            boolean termCorrectlyCategorized;
            ExceptionMessageDefinition messageDefinition;
            this.breadCrumbs.add(new BreadCrumb(termGuid, term.getName(), NodeType.Term));
            List termRelationships = this.clients.terms().getAllRelationships(this.userId, termGuid);
            if (rootCategory == null && leafCategory == null) {
                boolean termCorrectlyAnchored = false;
                for (Relationship termRelationship : termRelationships) {
                    if (!termRelationship.getRelationshipType().equals((Object)RelationshipType.TermAnchor)) continue;
                    if (termRelationship.getEnd1().getNodeGuid().equals(glossaryGuid)) {
                        termCorrectlyAnchored = true;
                        continue;
                    }
                    ExceptionMessageDefinition messageDefinition2 = GlossaryAuthorErrorCode.GET_BREADCRUMBS_TERM_NOT_IN_GLOSSARY.getMessageDefinition(term.getName(), termGuid, glossary.getName(), glossaryGuid);
                    throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition2, className, restAPIName, "TermGuid", termGuid);
                }
                if (!termCorrectlyAnchored) {
                    messageDefinition = GlossaryAuthorErrorCode.GET_BREADCRUMBS_TERM_NOT_IN_GLOSSARY.getMessageDefinition(term.getName(), termGuid, glossary.getName(), glossaryGuid);
                    throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, restAPIName, "TermGuid", termGuid);
                }
            } else if (rootCategory != null && leafCategory == null) {
                termCorrectlyCategorized = false;
                for (Relationship termRelationship : termRelationships) {
                    if (!termRelationship.getRelationshipType().equals((Object)RelationshipType.TermCategorization) || !termRelationship.getEnd1().getNodeGuid().equals(rootCategoryGuid)) continue;
                    this.breadCrumbs.add(new BreadCrumb(rootCategoryGuid, rootCategory.getName(), NodeType.Category));
                    termCorrectlyCategorized = true;
                }
                if (!termCorrectlyCategorized) {
                    messageDefinition = GlossaryAuthorErrorCode.GET_BREADCRUMBS_TERM_NOT_IN_ROOT_CATEGORY.getMessageDefinition(term.getName(), termGuid, rootCategory.getName(), rootCategoryGuid);
                    throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, restAPIName, "TermGuid", termGuid);
                }
            } else if (rootCategory != null && leafCategory != null) {
                termCorrectlyCategorized = false;
                for (Relationship termRelationship : termRelationships) {
                    if (!termRelationship.getRelationshipType().equals((Object)RelationshipType.TermCategorization) || !termRelationship.getEnd1().getNodeGuid().equals(leafCategoryGuid)) continue;
                    this.breadCrumbs.add(new BreadCrumb(leafCategoryGuid, leafCategory.getName(), NodeType.Category));
                    termCorrectlyCategorized = true;
                }
                if (!termCorrectlyCategorized) {
                    messageDefinition = GlossaryAuthorErrorCode.GET_BREADCRUMBS_TERM_NOT_IN_LEAF_CATEGORY.getMessageDefinition(termGuid, term.getName(), leafCategoryGuid, leafCategory.getName());
                    throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, restAPIName, "TermGuid", termGuid);
                }
            }
        }
        if (leafCategory != null && rootCategory != null) {
            this.currentCategory = leafCategory;
            while (this.hasParentCategory()) {
                this.breadCrumbs.add(new BreadCrumb(this.currentCategory.getSystemAttributes().getGUID(), this.currentCategory.getName(), NodeType.Category));
            }
            if (!this.currentCategory.getSystemAttributes().getGUID().equals(rootCategoryGuid)) {
                ExceptionMessageDefinition messageDefinition = GlossaryAuthorErrorCode.GET_BREADCRUMBS_ROOT_CATEGORY_NOT_ROOT.getMessageDefinition(rootCategoryGuid, rootCategory.getName());
                throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, restAPIName, "rootCategoryGuid", rootCategoryGuid);
            }
            List categoryRelationships = this.clients.terms().getAllRelationships(this.userId, this.currentCategory.getSystemAttributes().getGUID());
            for (Relationship categoryRelationship : categoryRelationships) {
                if (!categoryRelationship.getRelationshipType().equals((Object)RelationshipType.CategoryAnchor) || glossary.getSystemAttributes().getGUID().equals(glossaryGuid)) continue;
                ExceptionMessageDefinition messageDefinition = GlossaryAuthorErrorCode.GET_BREADCRUMBS_ROOT_CATEGORY_NOT_GLOSSARY.getMessageDefinition(rootCategoryGuid, rootCategory.getName(), glossaryGuid, glossary.getName());
                throw new org.odpi.openmetadata.accessservices.subjectarea.ffdc.exceptions.InvalidParameterException(messageDefinition, className, restAPIName, "rootCategoryGuid", rootCategoryGuid);
            }
        }
        this.breadCrumbs.add(new BreadCrumb(glossaryGuid, glossary.getName(), NodeType.Glossary));
        BreadCrumbTrail breadCrumbTrail = new BreadCrumbTrail(this.breadCrumbs);
        return breadCrumbTrail.getBreadCrumbs();
    }
}

