/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewGlossaryRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}/glossaries"})
public class GlossaryAuthorViewGlossaryRESTResource {
    private GlossaryAuthorViewGlossaryRESTServices restAPI = new GlossaryAuthorViewGlossaryRESTServices();

    @PostMapping
    public SubjectAreaOMASAPIResponse createGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestBody Glossary suppliedGlossary) {
        return this.restAPI.createGlossary(serverName, userId, suppliedGlossary);
    }

    @GetMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGlossary(serverName, userId, guid);
    }

    @GetMapping
    public SubjectAreaOMASAPIResponse findGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findGlossary(serverName, userId, asOfTime, searchCriteria, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getGlossaryRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getGlossaryRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Glossary suppliedGlossary, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateGlossary(serverName, userId, guid, suppliedGlossary, isReplace);
    }

    @DeleteMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge, HttpServletRequest request) {
        return this.restAPI.deleteGlossary(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, HttpServletRequest request) {
        return this.restAPI.restoreGlossary(serverName, userId, guid);
    }
}

