/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewCategoryRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}/categories"})
@Tag(name="Glossary Author OMVS", description="Develop a definition of a subject area by authoring glossaries, including terms for use by a user interface.", externalDocs=@ExternalDocumentation(description="Glossary Author View Services (OMVS)", url="https://egeria.odpi.org/open-metadata-implementation/view-services/glossary-author-view/"))
public class GlossaryAuthorViewCategoryRESTResource {
    private GlossaryAuthorViewCategoryRESTServices restAPI = new GlossaryAuthorViewCategoryRESTServices();

    @PostMapping
    public SubjectAreaOMASAPIResponse createCategory(@PathVariable String serverName, @PathVariable String userId, @RequestBody Category suppliedCategory) {
        return this.restAPI.createCategory(serverName, userId, suppliedCategory);
    }

    @GetMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategory(serverName, userId, guid);
    }

    @GetMapping
    public SubjectAreaOMASAPIResponse findCategory(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findCategory(serverName, userId, asOfTime, searchCriteria, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getCategoryRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getCategoryRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Category suppliedCategory, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateCategory(serverName, userId, guid, suppliedCategory, isReplace);
    }

    @DeleteMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge, HttpServletRequest request) {
        return this.restAPI.deleteCategory(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, HttpServletRequest request) {
        return this.restAPI.restoreCategory(serverName, userId, guid);
    }
}

