/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewTermRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}/terms"})
@Tag(name="Glossary Author OMVS", description="Develop a definition of a subject area by authoring glossaries, including terms for use by a user interface.", externalDocs=@ExternalDocumentation(description="Glossary Author View Services (OMVS)", url="https://egeria.odpi.org/open-metadata-implementation/view-services/glossary-author-view/"))
public class GlossaryAuthorViewTermRESTResource {
    private GlossaryAuthorViewTermRESTServices restAPI = new GlossaryAuthorViewTermRESTServices();

    @PostMapping
    public SubjectAreaOMASAPIResponse createTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody Term suppliedTerm) {
        return this.restAPI.createTerm(serverName, userId, suppliedTerm);
    }

    @GetMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTerm(serverName, userId, guid);
    }

    @GetMapping
    public SubjectAreaOMASAPIResponse findTerm(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findTerm(serverName, userId, asOfTime, searchCriteria, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getTermRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="SequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getTermRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Term suppliedTerm, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTerm(serverName, userId, guid, suppliedTerm, isReplace);
    }

    @DeleteMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge, HttpServletRequest request) {
        return this.restAPI.deleteTerm(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, HttpServletRequest request) {
        return this.restAPI.restoreTerm(serverName, userId, guid);
    }
}

