/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.SequencingOrder;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewProjectRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}/projects"})
@Tag(name="Glossary Author OMVS", description="Develop a definition of a subject area by authoring glossaries, including terms for use by a user interface.", externalDocs=@ExternalDocumentation(description="Glossary Author View Services (OMVS)", url="https://egeria.odpi.org/open-metadata-implementation/view-services/glossary-author-view/"))
public class GlossaryAuthorViewProjectRESTResource {
    private GlossaryAuthorViewProjectRESTServices restAPI = new GlossaryAuthorViewProjectRESTServices();

    @PostMapping
    public SubjectAreaOMASAPIResponse createProject(@PathVariable String serverName, @PathVariable String userId, @RequestBody Project suppliedProject) {
        return this.restAPI.createProject(serverName, userId, suppliedProject);
    }

    @GetMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse getProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProject(serverName, userId, guid);
    }

    @GetMapping
    public SubjectAreaOMASAPIResponse findProject(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findProject(serverName, userId, asOfTime, searchCriteria, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse getProjectRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="offset", required=false) Integer offset, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getProjectRelationships(serverName, userId, guid, asOfTime, offset, pageSize, sequencingOrder, sequencingProperty);
    }

    @PutMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse updateProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Project suppliedProject, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateProject(serverName, userId, guid, suppliedProject, isReplace);
    }

    @DeleteMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse deleteProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        return this.restAPI.deleteProject(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse restoreProject(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreProject(serverName, userId, guid);
    }
}

