/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Hasa;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Isa;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsaTypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewRelationshipRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}/relationships"})
@Tag(name="Glossary Author OMVS", description="Develop a definition of a subject area by authoring glossaries, including terms for use by a user interface.", externalDocs=@ExternalDocumentation(description="Glossary Author View Services (OMVS)", url="https://egeria.odpi.org/open-metadata-implementation/view-services/glossary-author-view/"))
public class GlossaryAuthorViewRelationshipRESTResource {
    private GlossaryAuthorViewRelationshipRESTServices restAPI = new GlossaryAuthorViewRelationshipRESTServices();

    @PostMapping(path={"/has-as"})
    public SubjectAreaOMASAPIResponse createTermHASA(@PathVariable String serverName, @PathVariable String userId, @RequestBody Hasa termHASARelationship) {
        return this.restAPI.createTermHASARelationship(serverName, userId, termHASARelationship);
    }

    @GetMapping(path={"/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse getTermHASA(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermHASARelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/has-as"})
    public SubjectAreaOMASAPIResponse updateTermHASA(@PathVariable String serverName, @PathVariable String userId, @RequestBody Hasa termHASARelationship, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermHASARelationship(serverName, userId, termHASARelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermHASA(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTermHASARelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermHASA(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermHASARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/related-terms"})
    public SubjectAreaOMASAPIResponse createRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelatedTerm relatedTermRelationshipRelationship) {
        return this.restAPI.createRelatedTerm(serverName, userId, relatedTermRelationshipRelationship);
    }

    @GetMapping(path={"/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getRelatedTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/related-terms"})
    public SubjectAreaOMASAPIResponse updateRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelatedTerm relatedTermRelationship, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateRelatedTerm(serverName, userId, relatedTermRelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteRelatedTerm(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreRelatedTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/synonyms"})
    public SubjectAreaOMASAPIResponse createSynonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Synonym synonym) {
        return this.restAPI.createSynonym(serverName, userId, synonym);
    }

    @GetMapping(path={"/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse getSynonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSynonym(serverName, userId, guid);
    }

    @PutMapping(path={"/synonyms"})
    public SubjectAreaOMASAPIResponse updateSynonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Synonym synonym, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateSynonym(serverName, userId, synonym, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteSynonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteSynonym(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreSynonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreSynonym(serverName, userId, guid);
    }

    @PostMapping(path={"/antonyms"})
    public SubjectAreaOMASAPIResponse createAntonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Antonym antonym) {
        return this.restAPI.createAntonym(serverName, userId, antonym);
    }

    @GetMapping(path={"/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse getAntonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getAntonym(serverName, userId, guid);
    }

    @PutMapping(path={"/antonyms"})
    public SubjectAreaOMASAPIResponse updateAntonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Antonym antonym, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateAntonym(serverName, userId, antonym, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteAntonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteAntonym(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreAntonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreAntonym(serverName, userId, guid);
    }

    @PostMapping(path={"/translations"})
    public SubjectAreaOMASAPIResponse createTranslation(@PathVariable String serverName, @PathVariable String userId, @RequestBody Translation translation) {
        return this.restAPI.createTranslation(serverName, userId, translation);
    }

    @GetMapping(path={"/translations/{guid}"})
    public SubjectAreaOMASAPIResponse getTranslation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTranslation(serverName, userId, guid);
    }

    @PutMapping(path={"/translations"})
    public SubjectAreaOMASAPIResponse updateTranslation(@PathVariable String serverName, @PathVariable String userId, @RequestBody Translation translation, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTranslation(serverName, userId, translation, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/translations/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTranslation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTranslation(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/translations/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTranslation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTranslation(serverName, userId, guid);
    }

    @PostMapping(path={"/used-in-contexts"})
    public SubjectAreaOMASAPIResponse createusedInContext(@PathVariable String serverName, @PathVariable String userId, @RequestBody UsedInContext usedInContext) {
        return this.restAPI.createUsedInContext(serverName, userId, usedInContext);
    }

    @GetMapping(path={"/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse getUsedInContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getUsedInContext(serverName, userId, guid);
    }

    @PutMapping(path={"/used-in-contexts"})
    public SubjectAreaOMASAPIResponse updateUsedInContext(@PathVariable String serverName, @PathVariable String userId, @RequestBody UsedInContext usedInContext, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateUsedInContext(serverName, userId, usedInContext, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse deleteUsedInContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteUsedInContext(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse restoreUsedInContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreUsedInContext(serverName, userId, guid);
    }

    @PostMapping(path={"/preferred-terms"})
    public SubjectAreaOMASAPIResponse createpreferredTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody PreferredTerm preferredTerm) {
        return this.restAPI.createPreferredTerm(serverName, userId, preferredTerm);
    }

    @GetMapping(path={"/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getPreferredTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getPreferredTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/preferred-terms"})
    public SubjectAreaOMASAPIResponse updatePreferredTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody PreferredTerm preferredTerm, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updatePreferredTerm(serverName, userId, preferredTerm, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deletePreferredTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deletePreferredTerm(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restorePreferredTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restorePreferredTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/valid-values"})
    public SubjectAreaOMASAPIResponse createvalidValue(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValue validValue) {
        return this.restAPI.createValidValue(serverName, userId, validValue);
    }

    @GetMapping(path={"/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse getValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getValidValue(serverName, userId, guid);
    }

    @PutMapping(path={"/valid-values"})
    public SubjectAreaOMASAPIResponse updateValidValue(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValue validValue, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateValidValue(serverName, userId, validValue, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse deleteValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteValidValue(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse restoreValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreValidValue(serverName, userId, guid);
    }

    @PostMapping(path={"/replacement-terms"})
    public SubjectAreaOMASAPIResponse createreplacementTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReplacementTerm replacementTerm) {
        return this.restAPI.createReplacementTerm(serverName, userId, replacementTerm);
    }

    @GetMapping(path={"/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse getReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getReplacementTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/replacement-terms"})
    public SubjectAreaOMASAPIResponse updateReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReplacementTerm replacementTerm, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateReplacementTerm(serverName, userId, replacementTerm, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse deleteReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteReplacementTerm(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse restoreReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreReplacementTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/typed-bys"})
    public SubjectAreaOMASAPIResponse createtermTYPEDBY(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypedBy termTYPEDBYRelationship) {
        return this.restAPI.createTermTYPEDBYRelationship(serverName, userId, termTYPEDBYRelationship);
    }

    @GetMapping(path={"/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse getTYPEDBY(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/typed-bys"})
    public SubjectAreaOMASAPIResponse updateTermTYPEDBY(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypedBy termTYPEDBYRelationship, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermTYPEDBYRelationship(serverName, userId, termTYPEDBYRelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTypedBy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTermTYPEDBYRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermTYPEDBY(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/is-as"})
    public SubjectAreaOMASAPIResponse createiSA(@PathVariable String serverName, @PathVariable String userId, @RequestBody Isa iSARelationship) {
        return this.restAPI.createIsaRelationship(serverName, userId, iSARelationship);
    }

    @GetMapping(path={"/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse getISA(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getISARelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/is-as"})
    public SubjectAreaOMASAPIResponse updateISA(@PathVariable String serverName, @PathVariable String userId, @RequestBody Isa isa, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateISARelationship(serverName, userId, isa, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermISA(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteISARelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse restoreIsa(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreISARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/is-a-type-ofs"})
    public SubjectAreaOMASAPIResponse createtermISATypeOF(@PathVariable String serverName, @PathVariable String userId, @RequestBody IsaTypeOf termISATypeOFRelationship) {
        return this.restAPI.createTermISATypeOFRelationship(serverName, userId, termISATypeOFRelationship);
    }

    @GetMapping(path={"/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse getTermISATypeOF(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermISATypeOFRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/is-a-type-ofs"})
    public SubjectAreaOMASAPIResponse updateISA(@PathVariable String serverName, @PathVariable String userId, @RequestBody IsaTypeOf isatypeof, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermISATypeOFRelationship(serverName, userId, isatypeof, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermIsaTypeOf(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTermISATypeOFRelationship(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermIsaTypeOf(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermISATypeOFRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/term-categorizations"})
    public SubjectAreaOMASAPIResponse createTermCategorization(@PathVariable String serverName, @PathVariable String userId, @RequestBody Categorization termCategorizationRelationship) {
        return this.restAPI.createTermCategorization(serverName, userId, termCategorizationRelationship);
    }

    @GetMapping(path={"/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse getTermCategorization(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermCategorization(serverName, userId, guid);
    }

    @PutMapping(path={"/term-categorizations"})
    public SubjectAreaOMASAPIResponse updateTermCategorization(@PathVariable String serverName, @PathVariable String userId, @RequestBody Categorization isatypeof, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateTermCategorization(serverName, userId, isatypeof, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermCategorization(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteTermCategorization(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermCategorization(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermCategorization(serverName, userId, guid);
    }

    @PostMapping(path={"/term-anchor"})
    public SubjectAreaOMASAPIResponse createTermAnchor(@PathVariable String serverName, @PathVariable String userId, @RequestBody TermAnchor termAnchorRelationship) {
        return this.restAPI.createTermAnchor(serverName, userId, termAnchorRelationship);
    }

    @GetMapping(path={"/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse getTermAnchor(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermAnchor(serverName, userId, guid);
    }

    @DeleteMapping(path={"/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse deleteTermAnchor(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        return this.restAPI.deleteTermAnchor(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/term-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse restoreTermAnchor(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermAnchor(serverName, userId, guid);
    }

    @PostMapping(path={"/category-anchor"})
    public SubjectAreaOMASAPIResponse createCategoryAnchor(@PathVariable String serverName, @PathVariable String userId, @RequestBody CategoryAnchor categoryAnchorRelationship) {
        return this.restAPI.createCategoryAnchor(serverName, userId, categoryAnchorRelationship);
    }

    @GetMapping(path={"/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse getCategoryAnchor(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategoryAnchor(serverName, userId, guid);
    }

    @DeleteMapping(path={"/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse deleteCategoryAnchor(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        return this.restAPI.deleteCategoryAnchor(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/category-anchor/{guid}"})
    public SubjectAreaOMASAPIResponse restoreCategoryAnchor(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreCategoryAnchor(serverName, userId, guid);
    }

    @PostMapping(path={"/project-scopes"})
    public SubjectAreaOMASAPIResponse createProjectScope(@PathVariable String serverName, @PathVariable String userId, @RequestBody ProjectScope projectScope) {
        return this.restAPI.createProjectScope(serverName, userId, projectScope);
    }

    @GetMapping(path={"/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse getProjectScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProjectScope(serverName, userId, guid);
    }

    @PutMapping(path={"/project-scopes"})
    public SubjectAreaOMASAPIResponse updateProjectScope(@PathVariable String serverName, @PathVariable String userId, @RequestBody ProjectScope projectScope, @RequestParam(value="isReplace", required=false) Boolean isReplace) {
        return this.restAPI.updateProjectScope(serverName, userId, projectScope, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse deleteProjectScope(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="isPurge", required=false) Boolean isPurge) {
        if (isPurge == null) {
            isPurge = false;
        }
        return this.restAPI.deleteProjectScope(serverName, userId, guid, isPurge);
    }

    @PostMapping(path={"/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse restoreProjectScoper(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreProjectScope(serverName, userId, guid);
    }

    @GetMapping(path={"/semantic-assignments/{guid}"})
    public SubjectAreaOMASAPIResponse getSemanticAssignment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSemanticAssignmentRelationship(serverName, userId, guid);
    }
}

