/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOfDeprecated;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.SemanticAssignment;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewRelationshipRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}/relationships"})
@Tag(name="Glossary Author OMVS", description="Develop a definition of a subject area by authoring glossaries, including terms for use by a user interface.", externalDocs=@ExternalDocumentation(description="Glossary Author View Services (OMVS)", url="https://egeria.odpi.org/open-metadata-implementation/view-services/glossary-author-view/"))
public class GlossaryAuthorViewRelationshipRESTResource {
    private GlossaryAuthorViewRelationshipRESTServices restAPI = new GlossaryAuthorViewRelationshipRESTServices();

    @PostMapping(path={"/has-as"})
    public SubjectAreaOMASAPIResponse<HasA> createTermHasARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody HasA termHasARelationship) {
        return this.restAPI.createTermHasARelationship(serverName, userId, termHasARelationship);
    }

    @GetMapping(path={"/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse<HasA> getTermHasARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermHasARelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse<HasA> updateTermHasARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody HasA termHasARelationship, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermHasARelationship(serverName, userId, guid, termHasARelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse<HasA> deleteTermHasARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteTermHasARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/has-as/{guid}"})
    public SubjectAreaOMASAPIResponse<HasA> restoreTermHasARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermHasARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/related-terms"})
    public SubjectAreaOMASAPIResponse<RelatedTerm> createRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelatedTerm relatedTermRelationship) {
        return this.restAPI.createRelatedTerm(serverName, userId, relatedTermRelationship);
    }

    @GetMapping(path={"/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<RelatedTerm> getRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getRelatedTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<RelatedTerm> updateRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody RelatedTerm relatedTermRelationship, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateRelatedTerm(serverName, userId, guid, relatedTermRelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<RelatedTerm> deleteRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteRelatedTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/related-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<RelatedTerm> restoreRelatedTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreRelatedTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/synonyms"})
    public SubjectAreaOMASAPIResponse<Synonym> createSynonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Synonym synonym) {
        return this.restAPI.createSynonym(serverName, userId, synonym);
    }

    @GetMapping(path={"/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Synonym> getSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSynonym(serverName, userId, guid);
    }

    @PutMapping(path={"/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Synonym> updateSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Synonym synonym, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateSynonym(serverName, userId, guid, synonym, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Synonym> deleteSynonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteSynonym(serverName, userId, guid);
    }

    @PostMapping(path={"/synonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Synonym> restoreSynonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreSynonym(serverName, userId, guid);
    }

    @PostMapping(path={"/antonyms"})
    public SubjectAreaOMASAPIResponse<Antonym> createAntonym(@PathVariable String serverName, @PathVariable String userId, @RequestBody Antonym antonym) {
        return this.restAPI.createAntonym(serverName, userId, antonym);
    }

    @GetMapping(path={"/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Antonym> getAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getAntonym(serverName, userId, guid);
    }

    @PutMapping(path={"/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Antonym> updateAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Antonym antonym, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateAntonym(serverName, userId, guid, antonym, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Antonym> deleteAntonymRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteAntonym(serverName, userId, guid);
    }

    @PostMapping(path={"/antonyms/{guid}"})
    public SubjectAreaOMASAPIResponse<Antonym> restoreAntonym(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreAntonym(serverName, userId, guid);
    }

    @PostMapping(path={"/translations"})
    public SubjectAreaOMASAPIResponse<Translation> createTranslation(@PathVariable String serverName, @PathVariable String userId, @RequestBody Translation translation) {
        return this.restAPI.createTranslation(serverName, userId, translation);
    }

    @GetMapping(path={"/translations/{guid}"})
    public SubjectAreaOMASAPIResponse<Translation> getTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTranslation(serverName, userId, guid);
    }

    @PutMapping(path={"/translations/{guid}"})
    public SubjectAreaOMASAPIResponse<Translation> updateTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Translation translation, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTranslation(serverName, userId, guid, translation, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/translations/{guid}"})
    public SubjectAreaOMASAPIResponse<Translation> deleteTranslationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteTranslation(serverName, userId, guid);
    }

    @PostMapping(path={"/translations/{guid}"})
    public SubjectAreaOMASAPIResponse<Translation> restoreTranslation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTranslation(serverName, userId, guid);
    }

    @PostMapping(path={"/used-in-contexts"})
    public SubjectAreaOMASAPIResponse<UsedInContext> createusedInContext(@PathVariable String serverName, @PathVariable String userId, @RequestBody UsedInContext usedInContext) {
        return this.restAPI.createUsedInContext(serverName, userId, usedInContext);
    }

    @GetMapping(path={"/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse<UsedInContext> getUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getUsedInContext(serverName, userId, guid);
    }

    @PutMapping(path={"/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse<UsedInContext> updateUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody UsedInContext usedInContext, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateUsedInContext(serverName, userId, guid, usedInContext, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse<UsedInContext> deleteUsedInContextRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteUsedInContext(serverName, userId, guid);
    }

    @PostMapping(path={"/used-in-contexts/{guid}"})
    public SubjectAreaOMASAPIResponse<UsedInContext> restoreUsedInContext(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreUsedInContext(serverName, userId, guid);
    }

    @PostMapping(path={"/preferred-terms"})
    public SubjectAreaOMASAPIResponse<PreferredTerm> createPreferredTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody PreferredTerm preferredTerm) {
        return this.restAPI.createPreferredTerm(serverName, userId, preferredTerm);
    }

    @GetMapping(path={"/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<PreferredTerm> getPreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getPreferredTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<PreferredTerm> updatePreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody PreferredTerm preferredTerm, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updatePreferredTerm(serverName, userId, guid, preferredTerm, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<PreferredTerm> deletePreferredTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deletePreferredTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/preferred-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<PreferredTerm> restorePreferredTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restorePreferredTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/valid-values"})
    public SubjectAreaOMASAPIResponse<ValidValue> createValidValue(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValue validValue) {
        return this.restAPI.createValidValue(serverName, userId, validValue);
    }

    @GetMapping(path={"/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse<ValidValue> getValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getValidValue(serverName, userId, guid);
    }

    @PutMapping(path={"/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse<ValidValue> updateValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody ValidValue validValue, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateValidValue(serverName, userId, guid, validValue, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse<ValidValue> deleteValidValueRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteValidValue(serverName, userId, guid);
    }

    @PostMapping(path={"/valid-values/{guid}"})
    public SubjectAreaOMASAPIResponse<ValidValue> restoreValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreValidValue(serverName, userId, guid);
    }

    @PostMapping(path={"/replacement-terms"})
    public SubjectAreaOMASAPIResponse<ReplacementTerm> createReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @RequestBody ReplacementTerm replacementTerm) {
        return this.restAPI.createReplacementTerm(serverName, userId, replacementTerm);
    }

    @GetMapping(path={"/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<ReplacementTerm> getReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getReplacementTerm(serverName, userId, guid);
    }

    @PutMapping(path={"/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<ReplacementTerm> updateReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody ReplacementTerm replacementTerm, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateReplacementTerm(serverName, userId, guid, replacementTerm, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<ReplacementTerm> deleteReplacementTermRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteReplacementTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/replacement-terms/{guid}"})
    public SubjectAreaOMASAPIResponse<ReplacementTerm> restoreReplacementTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreReplacementTerm(serverName, userId, guid);
    }

    @PostMapping(path={"/typed-bys"})
    public SubjectAreaOMASAPIResponse<TypedBy> createtermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypedBy termTYPEDBYRelationship) {
        return this.restAPI.createTermTYPEDBYRelationship(serverName, userId, termTYPEDBYRelationship);
    }

    @GetMapping(path={"/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse<TypedBy> getTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse<TypedBy> updateTermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody TypedBy termTYPEDBYRelationship, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermTYPEDBYRelationship(serverName, userId, guid, termTYPEDBYRelationship, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse<TypedBy> deleteTypedByRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/typed-bys/{guid}"})
    public SubjectAreaOMASAPIResponse<TypedBy> restoreTermTYPEDBYRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermTYPEDBYRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/is-as"})
    public SubjectAreaOMASAPIResponse<IsA> createiSARelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody IsA iSARelationship) {
        return this.restAPI.createIsaRelationship(serverName, userId, iSARelationship);
    }

    @GetMapping(path={"/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse<IsA> getIsARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIsARelationship(serverName, userId, guid);
    }

    @PutMapping(path={"/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse<IsA> updateIsARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody IsA isa, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateIsARelationship(serverName, userId, guid, isa, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse<IsA> deleteTermIsARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteIsARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/is-as/{guid}"})
    public SubjectAreaOMASAPIResponse<IsA> restoreIsaRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreIsARelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/is-a-type-of-deprecateds"})
    public SubjectAreaOMASAPIResponse<IsATypeOfDeprecated> createTermIsATypeOfDeprecated(@PathVariable String serverName, @PathVariable String userId, @RequestBody IsATypeOfDeprecated TermIsATypeOfDeprecated) {
        return this.restAPI.createTermIsATypeOfDeprecated(serverName, userId, TermIsATypeOfDeprecated);
    }

    @GetMapping(path={"/is-a-type-of-deprecateds/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOfDeprecated> getTermIsATypeOfDeprecated(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermIsATypeOfDeprecated(serverName, userId, guid);
    }

    @PutMapping(path={"/is-a-type-of-deprecateds/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOfDeprecated> updateIsARelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody IsATypeOfDeprecated isatypeof, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermIsATypeOfDeprecated(serverName, userId, guid, isatypeof, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/is-a-type-of-deprecateds/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOfDeprecated> deleteTermIsATypeOfDeprecated(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteTermIsATypeOfDeprecated(serverName, userId, guid);
    }

    @PostMapping(path={"/is-a-type-of-deprecateds/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOfDeprecated> restoreTermIsATypeOfDeprecated(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermIsATypeOfDeprecated(serverName, userId, guid);
    }

    @PostMapping(path={"/is-a-type-ofs"})
    public SubjectAreaOMASAPIResponse<IsATypeOf> createIsATypeOf(@PathVariable String serverName, @PathVariable String userId, @RequestBody IsATypeOf IsATypeOf2) {
        return this.restAPI.createIsATypeOf(serverName, userId, IsATypeOf2);
    }

    @GetMapping(path={"/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOf> getIsATypeOf(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIsATypeOf(serverName, userId, guid);
    }

    @PutMapping(path={"/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOf> updateIsATypeOf(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody IsATypeOf IsATypeOf2, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateIsATypeOf(serverName, userId, guid, IsATypeOf2, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOf> deleteIsATypeOf(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteIsATypeOf(serverName, userId, guid);
    }

    @PostMapping(path={"/is-a-type-ofs/{guid}"})
    public SubjectAreaOMASAPIResponse<IsATypeOf> restoreIsATypeOf(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreIsATypeOf(serverName, userId, guid);
    }

    @PostMapping(path={"/term-categorizations"})
    public SubjectAreaOMASAPIResponse<Categorization> createTermCategorization(@PathVariable String serverName, @PathVariable String userId, @RequestBody Categorization termCategorizationRelationship) {
        return this.restAPI.createTermCategorization(serverName, userId, termCategorizationRelationship);
    }

    @GetMapping(path={"/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse<Categorization> getTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermCategorization(serverName, userId, guid);
    }

    @PutMapping(path={"/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse<Categorization> updateTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Categorization categorization, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateTermCategorization(serverName, userId, guid, categorization, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse<Categorization> deleteTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteTermCategorization(serverName, userId, guid);
    }

    @PostMapping(path={"/term-categorizations/{guid}"})
    public SubjectAreaOMASAPIResponse<Categorization> restoreTermCategorizationRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreTermCategorization(serverName, userId, guid);
    }

    @GetMapping(path={"/term-anchors/{guid}"})
    public SubjectAreaOMASAPIResponse<TermAnchor> getTermAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTermAnchor(serverName, userId, guid);
    }

    @GetMapping(path={"/category-anchors/{guid}"})
    public SubjectAreaOMASAPIResponse<CategoryAnchor> getCategoryAnchorRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategoryAnchor(serverName, userId, guid);
    }

    @PostMapping(path={"/project-scopes"})
    public SubjectAreaOMASAPIResponse<ProjectScope> createProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody ProjectScope projectScope) {
        return this.restAPI.createProjectScope(serverName, userId, projectScope);
    }

    @GetMapping(path={"/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse<ProjectScope> getProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getProjectScope(serverName, userId, guid);
    }

    @PutMapping(path={"/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse<ProjectScope> updateProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody ProjectScope projectScope, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateProjectScope(serverName, userId, guid, projectScope, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse<ProjectScope> deleteProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteProjectScope(serverName, userId, guid);
    }

    @PostMapping(path={"/project-scopes/{guid}"})
    public SubjectAreaOMASAPIResponse<ProjectScope> restoreProjectScopeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreProjectScope(serverName, userId, guid);
    }

    @GetMapping(path={"/semantic-assignments/{guid}"})
    public SubjectAreaOMASAPIResponse<SemanticAssignment> getSemanticAssignmentRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getSemanticAssignmentRelationship(serverName, userId, guid);
    }

    @PostMapping(path={"/category-hierarchy-links"})
    public SubjectAreaOMASAPIResponse<CategoryHierarchyLink> createCategoryHierarchyLink(@PathVariable String serverName, @PathVariable String userId, @RequestBody CategoryHierarchyLink categoryHierarchyLink) {
        return this.restAPI.createCategoryHierarchyLink(serverName, userId, categoryHierarchyLink);
    }

    @GetMapping(path={"/category-hierarchy-links/{guid}"})
    public SubjectAreaOMASAPIResponse<CategoryHierarchyLink> getCategoryHierarchyLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getCategoryHierarchyLink(serverName, userId, guid);
    }

    @PutMapping(path={"/category-hierarchy-links/{guid}"})
    public SubjectAreaOMASAPIResponse<CategoryHierarchyLink> updateCategoryHierarchyLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody CategoryHierarchyLink categoryHierarchyLink, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateCategoryHierarchyLink(serverName, userId, guid, categoryHierarchyLink, isReplace);
    }

    @DeleteMapping(path={"/category-hierarchy-links/{guid}"})
    public SubjectAreaOMASAPIResponse<CategoryHierarchyLink> deleteCategoryHierarchyLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteCategoryHierarchyLink(serverName, userId, guid);
    }

    @PostMapping(path={"/category-hierarchy-links/{guid}"})
    public SubjectAreaOMASAPIResponse<CategoryHierarchyLink> restoreCategoryHierarchyLink(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreCategoryHierarchyLink(serverName, userId, guid);
    }
}

