/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.BreadCrumb;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewGlossaryRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}/glossaries"})
@Tag(name="Glossary Author OMVS", description="Develop a definition of a subject area by authoring glossaries, including terms for use by a user interface.", externalDocs=@ExternalDocumentation(description="Glossary Author View Services (OMVS)", url="https://egeria.odpi.org/open-metadata-implementation/view-services/glossary-author-view/"))
public class GlossaryAuthorViewGlossaryRESTResource {
    private final GlossaryAuthorViewGlossaryRESTServices restAPI = new GlossaryAuthorViewGlossaryRESTServices();

    @PostMapping
    public SubjectAreaOMASAPIResponse<Glossary> createGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestBody Glossary suppliedGlossary) {
        return this.restAPI.createGlossary(serverName, userId, suppliedGlossary);
    }

    @GetMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> getGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getGlossary(serverName, userId, guid);
    }

    @GetMapping
    public SubjectAreaOMASAPIResponse<Glossary> findGlossary(@PathVariable String serverName, @PathVariable String userId, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") int startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.findGlossary(serverName, userId, asOfTime, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), Integer.valueOf(startingFrom), pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/{guid}/relationships"})
    public SubjectAreaOMASAPIResponse<Relationship> getGlossaryRelationships(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") int startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) SequencingOrder sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getGlossaryRelationships(serverName, userId, guid, asOfTime, Integer.valueOf(startingFrom), pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/{guid}/terms"})
    public SubjectAreaOMASAPIResponse<Term> getGlossaryTerms(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) String sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getTerms(serverName, userId, guid, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), asOfTime, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @GetMapping(path={"/{guid}/categories"})
    public SubjectAreaOMASAPIResponse<Category> getGlossaryCategories(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="searchCriteria", required=false) String searchCriteria, @RequestParam(value="exactValue", required=false, defaultValue="false") Boolean exactValue, @RequestParam(value="ignoreCase", required=false, defaultValue="true") Boolean ignoreCase, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="onlyTop", required=false, defaultValue="true") Boolean onlyTop, @RequestParam(value="startingFrom", required=false, defaultValue="0") Integer startingFrom, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="sequencingOrder", required=false) String sequencingOrder, @RequestParam(value="sequencingProperty", required=false) String sequencingProperty) {
        return this.restAPI.getCategories(serverName, userId, guid, searchCriteria, exactValue.booleanValue(), ignoreCase.booleanValue(), asOfTime, onlyTop, startingFrom, pageSize, sequencingOrder, sequencingProperty);
    }

    @PostMapping(path={"/{guid}/terms"})
    public SubjectAreaOMASAPIResponse<SubjectAreaOMASAPIResponse<Term>> createMultipleTermsInAGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Term[] terms) {
        return this.restAPI.createMultipleTermsInAGlossary(serverName, userId, guid, terms);
    }

    @GetMapping(path={"/{guid}/breadcrumbs"})
    public SubjectAreaOMASAPIResponse<BreadCrumb> getBreadCrumbTrail(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="rootCategoryGuid", required=false) String rootCategoryGuid, @RequestParam(value="leafCategoryGuid", required=false) String leafCategoryGuid, @RequestParam(value="termGuid", required=false) String termGuid) {
        return this.restAPI.getBreadCrumbTrail(serverName, userId, guid, rootCategoryGuid, leafCategoryGuid, termGuid);
    }

    @PutMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> updateGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody Glossary suppliedGlossary, @RequestParam(value="isReplace", required=false, defaultValue="false") Boolean isReplace) {
        return this.restAPI.updateGlossary(serverName, userId, guid, suppliedGlossary, isReplace.booleanValue());
    }

    @DeleteMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> deleteGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.deleteGlossary(serverName, userId, guid);
    }

    @PostMapping(path={"/{guid}"})
    public SubjectAreaOMASAPIResponse<Glossary> restoreGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.restoreGlossary(serverName, userId, guid);
    }
}

