/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.GraphStatistics;
import org.odpi.openmetadata.viewservices.glossaryauthor.services.GlossaryAuthorViewGraphRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-author/users/{userId}"})
@Tag(name="Subject Area OMAS", description="The Subject Area OMAS supports subject matter experts who are documenting their knowledge about a particular subject. This includes glossary terms, reference data, validation rules.", externalDocs=@ExternalDocumentation(description="Glossary Author Open Metadata View Service (OMVS)", url="https://odpi.github.io/egeria-docs/services/omvs/glossary-view/overview/"))
public class GlossaryAuthorGraphRESTResource {
    private final GlossaryAuthorViewGraphRESTServices restAPI = new GlossaryAuthorViewGraphRESTServices();

    @GetMapping(path={"/graph/{guid}"})
    public SubjectAreaOMASAPIResponse<Graph> getGraph(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="nodeFilter", required=false) String nodeFilterStr, @RequestParam(value="relationshipFilter", required=false) String relationshipFilterStr, @RequestParam(value="statusFilter", required=false) StatusFilter statusFilter) {
        return this.restAPI.getGraph(serverName, userId, guid, asOfTime, nodeFilterStr, relationshipFilterStr, statusFilter);
    }

    @GetMapping(path={"/graph-counts/{guid}"})
    public SubjectAreaOMASAPIResponse<GraphStatistics> getGraphCounts(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam(value="asOfTime", required=false) Date asOfTime, @RequestParam(value="nodeFilter", required=false) String nodeFilterStr, @RequestParam(value="relationshipFilter", required=false) String relationshipFilterStr, @RequestParam(value="statusFilter", required=false) StatusFilter statusFilter) {
        return this.restAPI.getGraphCounts(serverName, userId, guid, asOfTime, nodeFilterStr, relationshipFilterStr, statusFilter);
    }
}

