/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarybrowser.server;

import java.util.Arrays;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.CollaborationManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.GlossaryManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.StewardshipManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.CommentProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.DataFieldQueryProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FeedbackProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FindNameProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FindProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermActivityType;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.GlossaryTermStatus;
import org.odpi.openmetadata.accessservices.assetmanager.properties.LevelIdentifierProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TagProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.HistoryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.GlossaryBrowserInstanceHandler;
import org.slf4j.LoggerFactory;

public class GlossaryBrowserRESTServices {
    private static final GlossaryBrowserInstanceHandler instanceHandler = new GlossaryBrowserInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryBrowserRESTServices.class), instanceHandler.getServiceName());

    public GlossaryTermStatusListResponse getGlossaryTermStatuses(String serverName, String userId) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermStatuses");
        GlossaryTermStatusListResponse response = new GlossaryTermStatusListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermStatus.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(String serverName, String userId) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermStatuses");
        GlossaryTermRelationshipStatusListResponse response = new GlossaryTermRelationshipStatusListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermRelationshipStatus.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(String serverName, String userId) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermStatuses");
        GlossaryTermActivityTypeListResponse response = new GlossaryTermActivityTypeListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setTypes(Arrays.asList(GlossaryTermActivityType.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse findGlossaries(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findGlossaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaries");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaries");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "findGlossaries");
                response.setElementList(handler.findGlossaries(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaries", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getGlossariesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossariesByName");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesByName");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossariesByName");
                response.setElementList(handler.getGlossariesByName(userId, requestBody.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossariesByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossariesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryByGUID(String serverName, String userId, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryByGUID");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryByGUID");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryByGUID(userId, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryByGUID(userId, glossaryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryForCategory(String serverName, String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryForCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryForCategory");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryForCategory");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryForCategory");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryForCategory(userId, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryForCategory(userId, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryForCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryForTerm(String serverName, String userId, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryForTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryForTerm");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryForTerm");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryForTerm");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryForTerm(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryForTerm(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryForTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse findGlossaryCategories(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaryCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryCategories");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "findGlossaryCategories");
                response.setElementList(handler.findGlossaryCategories(userId, requestBody.getGlossaryGUID(), instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaryCategories", serverName, GlossarySearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaryCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getCategoriesForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoriesForGlossary");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getCategoriesForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForGlossary(userId, glossaryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getCategoriesForGlossary(userId, glossaryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCategoriesForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForTerm(String serverName, String userId, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getCategoriesForTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCategoriesForTerm");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForTerm");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getCategoriesForTerm");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForTerm(userId, glossaryTermGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getCategoriesForTerm(userId, glossaryTermGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCategoriesForTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryCategoriesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoriesByName");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoriesByName");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryCategoriesByName");
                response.setElementList(handler.getGlossaryCategoriesByName(userId, requestBody.getGlossaryGUID(), requestBody.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryCategoriesByName", serverName, GlossaryNameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoriesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(String serverName, String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoryByGUID");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryByGUID");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryCategoryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryParent(String serverName, String userId, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryCategoryParent");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryParent");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryCategoryParent");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryParent(userId, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryCategoryParent(userId, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossarySubCategories(String serverName, String userId, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossarySubCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossarySubCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossarySubCategories");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossarySubCategories");
            if (requestBody != null) {
                response.setElementList(handler.getGlossarySubCategories(userId, glossaryCategoryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getGlossarySubCategories(userId, glossaryCategoryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossarySubCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse findGlossaryTerms(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findGlossaryTerms");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryTerms");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "findGlossaryTerms");
                response.setElementList(handler.findGlossaryTerms(userId, requestBody.getGlossaryGUID(), instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaryTerms", serverName, GlossarySearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaryTerms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossary(String serverName, String userId, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getTermsForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermsForGlossary");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getTermsForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossary(userId, glossaryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getTermsForGlossary(userId, glossaryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossaryCategory(String serverName, String userId, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getTermsForGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermsForGlossaryCategory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossaryCategory");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getTermsForGlossaryCategory");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getRelatedTerms(String serverName, String userId, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getTermsForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTermsForGlossary");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getTermsForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getRelatedTerms(userId, glossaryTermGUID, requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getRelatedTerms(userId, glossaryTermGUID, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryTermsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermsByName");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermsByName");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryTermsByName");
                response.setElementList(handler.getGlossaryTermsByName(userId, requestBody.getGlossaryGUID(), requestBody.getName(), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermsByName", serverName, GlossaryNameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse getGlossaryTermByGUID(String serverName, String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryTermByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermByGUID");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermByGUID");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryTermByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryTermByGUID(userId, guid, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryTermByGUID(userId, guid, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermHistory(String serverName, String userId, String guid, int startFrom, int pageSize, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, HistoryRequestBody requestBody) {
        String methodName = "getGlossaryTermHistory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGlossaryTermHistory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermHistory");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryTermHistory");
                response.setElementList(handler.getGlossaryTermHistory(userId, guid, requestBody.getFromTime(), requestBody.getToTime(), startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermHistory", serverName, HistoryRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addRatingToElement(String serverName, String userId, String guid, boolean isPublic, RatingProperties requestBody) {
        String methodName = "addRatingToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addRatingToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "addRatingToElement");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addRatingToElement");
                handler.addRatingToElement(userId, guid, isPublic, requestBody);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addRatingToElement", serverName, RatingProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addRatingToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeRatingFromElement(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRatingFromElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeRatingFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "removeRatingFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeRatingFromElement");
            handler.removeRatingFromElement(userId, guid);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeRatingFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addLikeToElement(String serverName, String userId, String guid, boolean isPublic, NullRequestBody requestBody) {
        String methodName = "addLikeToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addLikeToElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "addLikeToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addLikeToElement");
            handler.addLikeToElement(userId, guid, isPublic);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addLikeToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeLikeFromElement(String serverName, String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLikeFromElement";
        String guidParameterName = "guid";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeLikeFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "removeLikeFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeLikeFromElement");
            handler.removeLikeFromElement(userId, guid);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeLikeFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentToElement(String serverName, String userId, String guid, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "addCommentToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentToElement");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCommentToElement");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "addCommentToElement");
                    response.setGUID(handler.addCommentToElement(userId, guid, isPublic, commentProperties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentToElement");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCommentToElement", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String serverName, String userId, String commentGUID, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "addCommentReply";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCommentReply");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "addCommentReply");
                    response.setGUID(handler.addCommentReply(userId, commentGUID, isPublic, commentProperties, null, forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "addCommentReply");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "addCommentReply", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCommentReply", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateComment(String serverName, String userId, String commentGUID, boolean isMergeUpdate, boolean isPublic, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateComment");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof CommentProperties) {
                    CommentProperties commentProperties = (CommentProperties)referenceableProperties;
                    CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "updateComment");
                    handler.updateComment(userId, commentGUID, isMergeUpdate, isPublic, commentProperties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "updateComment");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateComment", serverName, ReferenceableUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupAcceptedAnswer(String serverName, String userId, String questionCommentGUID, String answerCommentGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "setupAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupAcceptedAnswer");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "setupAcceptedAnswer");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof FeedbackProperties) {
                    FeedbackProperties feedbackProperties = (FeedbackProperties)relationshipProperties;
                    handler.setupAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, feedbackProperties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CommentProperties.class.getName(), "setupAcceptedAnswer");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupAcceptedAnswer", serverName, RelationshipRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "setupAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearAcceptedAnswer(String serverName, String userId, String questionCommentGUID, String answerCommentGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearAcceptedAnswer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "clearAcceptedAnswer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearAcceptedAnswer");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "clearAcceptedAnswer");
            if (requestBody != null) {
                handler.clearAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearAcceptedAnswer(userId, questionCommentGUID, answerCommentGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "clearAcceptedAnswer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCommentFromElement(String serverName, String userId, String elementGUID, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String guidParameterName = "commentGUID";
        String methodName = "removeElementComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeElementComment");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeElementComment");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "removeElementComment");
            if (requestBody != null) {
                handler.removeComment(userId, commentGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeComment(userId, commentGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeElementComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementResponse getCommentByGUID(String serverName, String userId, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getComment";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getComment");
        CommentElementResponse response = new CommentElementResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getComment");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getComment");
            if (requestBody != null) {
                response.setElement(handler.getComment(userId, commentGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getComment(userId, commentGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getComment", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementsResponse getAttachedComments(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getAttachedComments";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAttachedComments");
        CommentElementsResponse response = new CommentElementsResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getAttachedComments");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAttachedComments");
            if (requestBody != null) {
                response.setElementList(handler.getAttachedComments(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getAttachedComments(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAttachedComments", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentElementsResponse findComments(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findComments";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findComments");
        CommentElementsResponse response = new CommentElementsResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "findComments");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findComments");
            if (requestBody != null) {
                response.setElementList(handler.findComments(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findComments", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findComments", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createInformalTag(String serverName, String userId, TagProperties requestBody) {
        String methodName = "createTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createTag");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "createTag");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createTag");
                response.setGUID(handler.createInformalTag(userId, requestBody));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createTag", serverName, TagProperties.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTagDescription(String serverName, String userId, String tagGUID, InformalTagUpdateRequestBody requestBody) {
        String methodName = "updateTagDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateTagDescription");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "updateTagDescription");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTagDescription");
                handler.updateTagDescription(userId, tagGUID, requestBody.getDescription());
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateTagDescription", serverName, InformalTagUpdateRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateTagDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteTag(String serverName, String userId, String tagGUID, NullRequestBody requestBody) {
        String methodName = "deleteTag";
        String tagGUIDParameterName = "tagGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteTag");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "deleteTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteTag");
            handler.deleteTag(userId, tagGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagResponse getTag(String serverName, String userId, String guid) {
        String methodName = "getTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTag");
        InformalTagResponse response = new InformalTagResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTag");
            response.setTag(handler.getTag(userId, guid));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getTagsByName(userId, requestBody.getName(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getTagsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getMyTagsByName(String serverName, String userId, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMyTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getMyTagsByName(userId, requestBody.getName(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getMyTagsByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findTags(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, SearchStringRequestBody requestBody) {
        String methodName = "findTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            if (requestBody != null) {
                response.setTags(handler.findTags(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findTags", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findMyTags(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, SearchStringRequestBody requestBody) {
        String methodName = "findMyTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findMyTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            if (requestBody != null) {
                response.setTags(handler.findMyTags(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findMyTags", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addTagToElement(String serverName, String userId, String elementGUID, String tagGUID, FeedbackProperties requestBody) {
        String methodName = "addTagToElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addTagToElement");
        boolean isPublic = false;
        if (requestBody != null) {
            isPublic = requestBody.getIsPublic();
        }
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "addTagToElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addTagToElement");
            handler.addTagToElement(userId, elementGUID, tagGUID, isPublic);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addTagToElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeTagFromElement(String serverName, String userId, String elementGUID, String tagGUID, NullRequestBody requestBody) {
        String methodName = "removeTagFromElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeTagFromElement");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "removeTagFromElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeTagFromElement");
            handler.removeTagFromElement(userId, elementGUID, tagGUID);
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeTagFromElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getElementsByTag(String serverName, String userId, String tagGUID, int startFrom, int pageSize) {
        String methodName = "getElementsByTag";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsByTag");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getElementsByTag");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsByTag");
            response.setGUIDs(handler.getElementsByTag(userId, tagGUID, startFrom, pageSize));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsByTag", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementsResponse findNoteLogs(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findNoteLogs";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findNoteLogs");
        NoteLogElementsResponse response = new NoteLogElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNoteLogs");
            if (requestBody != null) {
                CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "findNoteLogs");
                response.setElementList(handler.findNoteLogs(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findNoteLogs", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNoteLogs", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementsResponse getNoteLogsByName(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getNoteLogsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNoteLogsByName");
        NoteLogElementsResponse response = new NoteLogElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogsByName");
            if (requestBody != null) {
                CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getNoteLogsByName");
                response.setElementList(handler.getNoteLogsByName(userId, requestBody.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getNoteLogsByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementsResponse getNoteLogsForElement(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNotesForNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNotesForNoteLog");
        NoteLogElementsResponse response = new NoteLogElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getNotesForNoteLog");
            if (requestBody != null) {
                response.setElementList(handler.getNoteLogsForElement(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getNoteLogsForElement(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogElementResponse getNoteLogByGUID(String serverName, String userId, String noteLogGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNoteLogByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNoteLogByGUID");
        NoteLogElementResponse response = new NoteLogElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogByGUID");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getNoteLogByGUID");
            if (requestBody != null) {
                response.setElement(handler.getNoteLogByGUID(userId, noteLogGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getNoteLogByGUID(userId, noteLogGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteElementsResponse findNotes(String serverName, String userId, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findNotes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findNotes");
        NoteElementsResponse response = new NoteElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findNotes");
            if (requestBody != null) {
                CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "findNotes");
                response.setElementList(handler.findNotes(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findNotes", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findNotes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteElementsResponse getNotesForNoteLog(String serverName, String userId, String noteLogGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNotesForNoteLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNotesForNoteLog");
        NoteElementsResponse response = new NoteElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotesForNoteLog");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getNotesForNoteLog");
            if (requestBody != null) {
                response.setElementList(handler.getNotesForNoteLog(userId, noteLogGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getNotesForNoteLog(userId, noteLogGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotesForNoteLog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteElementResponse getNoteByGUID(String serverName, String userId, String noteGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getNoteByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNoteByGUID");
        NoteElementResponse response = new NoteElementResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteByGUID");
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getNoteByGUID");
            if (requestBody != null) {
                response.setElement(handler.getNoteByGUID(userId, noteGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getNoteByGUID(userId, noteGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getDataFieldClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getDataFieldClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getDataFieldClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFieldClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getDataFieldClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof DataFieldQueryProperties) {
                    DataFieldQueryProperties properties = (DataFieldQueryProperties)findProperties;
                    response.setElementList(handler.getDataFieldClassifiedElements(userId, properties, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getDataFieldClassifiedElements(userId, null, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getDataFieldClassifiedElements");
                }
            } else {
                response.setElementList(handler.getDataFieldClassifiedElements(userId, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFieldClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getConfidenceClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getConfidenceClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfidenceClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfidenceClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getConfidenceClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElementList(handler.getConfidenceClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getConfidenceClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getConfidenceClassifiedElements");
                }
            } else {
                response.setElementList(handler.getConfidenceClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConfidenceClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getCriticalityClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getCriticalityClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCriticalityClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCriticalityClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getCriticalityClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElementList(handler.getCriticalityClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getCriticalityClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getCriticalityClassifiedElements");
                }
            } else {
                response.setElementList(handler.getCriticalityClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCriticalityClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getConfidentialityClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getConfidentialityClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConfidentialityClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfidentialityClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getConfidentialityClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElementList(handler.getConfidentialityClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getConfidentialityClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getConfidentialityClassifiedElements");
                }
            } else {
                response.setElementList(handler.getConfidentialityClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConfidentialityClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getRetentionClassifiedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getRetentionClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRetentionClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRetentionClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getRetentionClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElementList(handler.getRetentionClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getRetentionClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getRetentionClassifiedElements");
                }
            } else {
                response.setElementList(handler.getRetentionClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRetentionClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getSecurityTaggedElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getSecurityTaggedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityTaggedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityTaggedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getSecurityTaggedElements");
            if (requestBody != null) {
                response.setElementList(handler.getSecurityTaggedElements(userId, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getSecurityTaggedElements(userId, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSecurityTaggedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getOwnersElements(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getOwnersElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOwnersElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOwnersElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getOwnersElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof FindNameProperties) {
                    FindNameProperties properties = (FindNameProperties)findProperties;
                    response.setElementList(handler.getOwnersElements(userId, properties.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getOwnersElements(userId, null, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FindNameProperties.class.getName(), "getOwnersElements");
                }
            } else {
                response.setElementList(handler.getOwnersElements(userId, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOwnersElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getMembersOfSubjectArea(String serverName, String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getMembersOfSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMembersOfSubjectArea");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMembersOfSubjectArea");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getMembersOfSubjectArea");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof FindNameProperties) {
                    FindNameProperties properties = (FindNameProperties)findProperties;
                    response.setElementList(handler.getMembersOfSubjectArea(userId, properties.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElementList(handler.getMembersOfSubjectArea(userId, null, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FindNameProperties.class.getName(), "getMembersOfSubjectArea");
                }
            } else {
                response.setElementList(handler.getMembersOfSubjectArea(userId, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMembersOfSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getMeanings(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getMeanings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMeanings");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeanings");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getMeanings");
            if (requestBody == null) {
                response.setElementList(handler.getMeanings(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getMeanings(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMeanings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getSemanticAssignees(String serverName, String userId, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSemanticAssignees";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSemanticAssignees");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSemanticAssignees");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getSemanticAssignees");
            if (requestBody == null) {
                response.setElementList(handler.getSemanticAssignees(userId, glossaryTermGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getSemanticAssignees(userId, glossaryTermGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSemanticAssignees", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getGovernedElements(String serverName, String userId, String governanceDefinitionGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGovernedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernedElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getGovernedElements");
            if (requestBody == null) {
                response.setElementList(handler.getGovernedElements(userId, governanceDefinitionGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getGovernedElements(userId, governanceDefinitionGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionsResponse getGovernedByDefinitions(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGovernedByDefinitions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getGovernedByDefinitions");
        GovernanceDefinitionsResponse response = new GovernanceDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedByDefinitions");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getGovernedByDefinitions");
            if (requestBody == null) {
                response.setElements(handler.getGovernedByDefinitions(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElements(handler.getGovernedByDefinitions(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernedByDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getSourceElements(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSourceElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSourceElements");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSourceElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getSourceElements");
            if (requestBody == null) {
                response.setElementList(handler.getSourceElements(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getSourceElements(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSourceElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedElementsResponse getElementsSourceFrom(String serverName, String userId, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getElementsSourceFrom";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getElementsSourceFrom");
        RelatedElementsResponse response = new RelatedElementsResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsSourceFrom");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getElementsSourceFrom");
            if (requestBody == null) {
                response.setElementList(handler.getElementsSourceFrom(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getElementsSourceFrom(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsSourceFrom", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

