/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarybrowser.server;

import java.util.Arrays;
import java.util.Date;
import org.odpi.openmetadata.accessservices.assetmanager.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.CollaborationManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.GlossaryManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.management.StewardshipManagementClient;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedMetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindNameProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.FindProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LevelIdentifierProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.DataFieldQueryProperties;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.HistoryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.GlossaryBrowserInstanceHandler;
import org.slf4j.LoggerFactory;

public class GlossaryBrowserRESTServices
extends TokenController {
    private static final GlossaryBrowserInstanceHandler instanceHandler = new GlossaryBrowserInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryBrowserRESTServices.class), instanceHandler.getServiceName());

    public OpenMetadataElementResponse getMetadataElementByGUID(String serverName, String elementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) {
        String methodName = "getMetadataElementByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMetadataElementByGUID");
        AuditLog auditLog = null;
        OpenMetadataElementResponse response = new OpenMetadataElementResponse();
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMetadataElementByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataElementByGUID");
            OpenMetadataStoreClient handler = instanceHandler.getOpenMetadataStoreClient(userId, serverName, "getMetadataElementByGUID");
            response.setElement(handler.getMetadataElementByGUID(userId, elementGUID, forLineage, forDuplicateProcessing, effectiveTime));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataElementByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermStatusListResponse getGlossaryTermStatuses(String serverName) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermStatuses");
        GlossaryTermStatusListResponse response = new GlossaryTermStatusListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermStatuses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermStatus.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(String serverName) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermStatuses");
        GlossaryTermRelationshipStatusListResponse response = new GlossaryTermRelationshipStatusListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermStatuses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermRelationshipStatus.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(String serverName) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermStatuses");
        GlossaryTermActivityTypeListResponse response = new GlossaryTermActivityTypeListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermStatuses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setTypes(Arrays.asList(GlossaryTermActivityType.values()));
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse findGlossaries(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findGlossaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGlossaries");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGlossaries");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaries");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "findGlossaries");
                response.setElementList(handler.findGlossaries(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaries", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesByName(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getGlossariesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossariesByName");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossariesByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesByName");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossariesByName");
                response.setElementList(handler.getGlossariesByName(userId, requestBody.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossariesByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossariesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryByGUID(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryByGUID");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryByGUID");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryByGUID(userId, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryByGUID(userId, glossaryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryForCategory(String serverName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryForCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryForCategory");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryForCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryForCategory");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryForCategory");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryForCategory(userId, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryForCategory(userId, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryForCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryForTerm(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryForTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryForTerm");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryForTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryForTerm");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryForTerm");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryForTerm(userId, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryForTerm(userId, glossaryTermGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryForTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse findGlossaryCategories(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGlossaryCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGlossaryCategories");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryCategories");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "findGlossaryCategories");
                response.setElementList(handler.findGlossaryCategories(userId, requestBody.getGlossaryGUID(), instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaryCategories", serverName, GlossarySearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaryCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForGlossary(String serverName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getCategoriesForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCategoriesForGlossary");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCategoriesForGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getCategoriesForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForGlossary(userId, glossaryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getCategoriesForGlossary(userId, glossaryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCategoriesForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForTerm(String serverName, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getCategoriesForTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCategoriesForTerm");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCategoriesForTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForTerm");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getCategoriesForTerm");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForTerm(userId, glossaryTermGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getCategoriesForTerm(userId, glossaryTermGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCategoriesForTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryCategoriesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryCategoriesByName");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryCategoriesByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoriesByName");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryCategoriesByName");
                response.setElementList(handler.getGlossaryCategoriesByName(userId, requestBody.getGlossaryGUID(), requestBody.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryCategoriesByName", serverName, GlossaryNameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoriesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(String serverName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryCategoryByGUID");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryCategoryByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryByGUID");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryCategoryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryParent(String serverName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryCategoryParent");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryCategoryParent");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryParent");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryCategoryParent");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryParent(userId, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryCategoryParent(userId, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossarySubCategories(String serverName, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossarySubCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossarySubCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossarySubCategories");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossarySubCategories");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossarySubCategories");
            if (requestBody != null) {
                response.setElementList(handler.getGlossarySubCategories(userId, glossaryCategoryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getGlossarySubCategories(userId, glossaryCategoryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossarySubCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse findGlossaryTerms(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGlossaryTerms");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGlossaryTerms");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryTerms");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "findGlossaryTerms");
                response.setElementList(handler.findGlossaryTerms(userId, requestBody.getGlossaryGUID(), instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaryTerms", serverName, GlossarySearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findGlossaryTerms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossary(String serverName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getTermsForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTermsForGlossary");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTermsForGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getTermsForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossary(userId, glossaryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getTermsForGlossary(userId, glossaryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossaryCategory(String serverName, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getTermsForGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTermsForGlossaryCategory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTermsForGlossaryCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossaryCategory");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getTermsForGlossaryCategory");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, glossaryCategoryGUID, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getRelatedTerms(String serverName, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getTermsForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTermsForGlossary");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTermsForGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossary");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getTermsForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getRelatedTerms(userId, glossaryTermGUID, requestBody.getRelationshipTypeName(), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getRelatedTerms(userId, glossaryTermGUID, null, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTermsForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermsByName(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryTermsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermsByName");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermsByName");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryTermsByName");
                response.setElementList(handler.getGlossaryTermsByName(userId, requestBody.getGlossaryGUID(), requestBody.getName(), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermsByName", serverName, GlossaryNameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse getGlossaryTermByGUID(String serverName, String guid, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryTermByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermByGUID");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermByGUID");
            GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryTermByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryTermByGUID(userId, guid, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryTermByGUID(userId, guid, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermHistory(String serverName, String guid, int startFrom, int pageSize, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, HistoryRequestBody requestBody) {
        String methodName = "getGlossaryTermHistory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermHistory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermHistory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermHistory");
            if (requestBody != null) {
                GlossaryManagementClient handler = instanceHandler.getGlossaryManagementClient(userId, serverName, "getGlossaryTermHistory");
                response.setElementList(handler.getGlossaryTermHistory(userId, guid, requestBody.getFromTime(), requestBody.getToTime(), startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermHistory", serverName, HistoryRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGlossaryTermHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getTagsByName(String serverName, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTagsByName");
            restCallLogger.setUserId(token, userId);
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getTagsByName(userId, requestBody.getName(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getTagsByName", serverName);
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getMyTagsByName(String serverName, NameRequestBody requestBody, int startFrom, int pageSize) {
        String methodName = "getMyTagsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMyTagsByName");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMyTagsByName");
            restCallLogger.setUserId(token, userId);
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "getMyTagsByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMyTagsByName");
            if (requestBody != null) {
                response.setTags(handler.getMyTagsByName(userId, requestBody.getName(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getMyTagsByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMyTagsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findTags(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, SearchStringRequestBody requestBody) {
        String methodName = "findTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findTags");
            restCallLogger.setUserId(token, userId);
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "findTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findTags");
            if (requestBody != null) {
                response.setTags(handler.findTags(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findTags", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse findMyTags(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, SearchStringRequestBody requestBody) {
        String methodName = "findMyTags";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findMyTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findMyTags");
            restCallLogger.setUserId(token, userId);
            CollaborationManagementClient handler = instanceHandler.getCollaborationManagementClient(userId, serverName, "findMyTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findMyTags");
            if (requestBody != null) {
                response.setTags(handler.findMyTags(userId, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findMyTags", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findMyTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getDataFieldClassifiedElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getDataFieldClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getDataFieldClassifiedElements");
        ElementStubsResponse response = new ElementStubsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getDataFieldClassifiedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDataFieldClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getDataFieldClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof DataFieldQueryProperties) {
                    DataFieldQueryProperties properties = (DataFieldQueryProperties)findProperties;
                    response.setElements(handler.getDataFieldClassifiedElements(userId, properties, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getDataFieldClassifiedElements(userId, null, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getDataFieldClassifiedElements");
                }
            } else {
                response.setElements(handler.getDataFieldClassifiedElements(userId, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getDataFieldClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getConfidenceClassifiedElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getConfidenceClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getConfidenceClassifiedElements");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getConfidenceClassifiedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfidenceClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getConfidenceClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElements(handler.getConfidenceClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getConfidenceClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getConfidenceClassifiedElements");
                }
            } else {
                response.setElements(handler.getConfidenceClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConfidenceClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getCriticalityClassifiedElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getCriticalityClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCriticalityClassifiedElements");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCriticalityClassifiedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCriticalityClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getCriticalityClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElements(handler.getCriticalityClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getCriticalityClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getCriticalityClassifiedElements");
                }
            } else {
                response.setElements(handler.getCriticalityClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCriticalityClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getConfidentialityClassifiedElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getConfidentialityClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getConfidentialityClassifiedElements");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getConfidentialityClassifiedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfidentialityClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getConfidentialityClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElements(handler.getConfidentialityClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getConfidentialityClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getConfidentialityClassifiedElements");
                }
            } else {
                response.setElements(handler.getConfidentialityClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConfidentialityClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getRetentionClassifiedElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getRetentionClassifiedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRetentionClassifiedElements");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRetentionClassifiedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRetentionClassifiedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getRetentionClassifiedElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof LevelIdentifierProperties) {
                    LevelIdentifierProperties properties = (LevelIdentifierProperties)findProperties;
                    response.setElements(handler.getRetentionClassifiedElements(userId, properties.getReturnSpecificLevel(), properties.getLevelIdentifier(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getRetentionClassifiedElements(userId, false, 0, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(LevelIdentifierProperties.class.getName(), "getRetentionClassifiedElements");
                }
            } else {
                response.setElements(handler.getRetentionClassifiedElements(userId, false, 0, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRetentionClassifiedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getSecurityTaggedElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getSecurityTaggedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getSecurityTaggedElements");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getSecurityTaggedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityTaggedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getSecurityTaggedElements");
            if (requestBody != null) {
                response.setElements(handler.getSecurityTaggedElements(userId, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElements(handler.getSecurityTaggedElements(userId, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSecurityTaggedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getOwnersElements(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getOwnersElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getOwnersElements");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getOwnersElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOwnersElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getOwnersElements");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof FindNameProperties) {
                    FindNameProperties properties = (FindNameProperties)findProperties;
                    response.setElements(handler.getOwnersElements(userId, properties.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getOwnersElements(userId, null, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FindNameProperties.class.getName(), "getOwnersElements");
                }
            } else {
                response.setElements(handler.getOwnersElements(userId, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOwnersElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MetadataElementSummariesResponse getMembersOfSubjectArea(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, FindByPropertiesRequestBody requestBody) {
        String methodName = "getMembersOfSubjectArea";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMembersOfSubjectArea");
        MetadataElementSummariesResponse response = new MetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMembersOfSubjectArea");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMembersOfSubjectArea");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getMembersOfSubjectArea");
            if (requestBody != null) {
                FindProperties findProperties = requestBody.getProperties();
                if (findProperties instanceof FindNameProperties) {
                    FindNameProperties properties = (FindNameProperties)findProperties;
                    response.setElements(handler.getMembersOfSubjectArea(userId, properties.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else if (requestBody.getProperties() == null) {
                    response.setElements(handler.getMembersOfSubjectArea(userId, null, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(FindNameProperties.class.getName(), "getMembersOfSubjectArea");
                }
            } else {
                response.setElements(handler.getMembersOfSubjectArea(userId, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMembersOfSubjectArea", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getMeanings(String serverName, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getMeanings";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getMeanings");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getMeanings");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMeanings");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getMeanings");
            if (requestBody == null) {
                response.setElementList(handler.getMeanings(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getMeanings(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMeanings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementSummariesResponse getSemanticAssignees(String serverName, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSemanticAssignees";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getSemanticAssignees");
        RelatedMetadataElementSummariesResponse response = new RelatedMetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getSemanticAssignees");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSemanticAssignees");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getSemanticAssignees");
            if (requestBody == null) {
                response.setElements(handler.getSemanticAssignees(userId, glossaryTermGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElements(handler.getSemanticAssignees(userId, glossaryTermGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSemanticAssignees", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementSummariesResponse getGovernedElements(String serverName, String governanceDefinitionGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGovernedElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernedElements");
        RelatedMetadataElementSummariesResponse response = new RelatedMetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernedElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getGovernedElements");
            if (requestBody == null) {
                response.setElements(handler.getGovernedElements(userId, governanceDefinitionGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElements(handler.getGovernedElements(userId, governanceDefinitionGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernedElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GovernanceDefinitionsResponse getGovernedByDefinitions(String serverName, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGovernedByDefinitions";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGovernedByDefinitions");
        GovernanceDefinitionsResponse response = new GovernanceDefinitionsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGovernedByDefinitions");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGovernedByDefinitions");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getGovernedByDefinitions");
            if (requestBody == null) {
                response.setElements(handler.getGovernedByDefinitions(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElements(handler.getGovernedByDefinitions(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getGovernedByDefinitions", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementSummariesResponse getSourceElements(String serverName, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getSourceElements";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getSourceElements");
        RelatedMetadataElementSummariesResponse response = new RelatedMetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getSourceElements");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSourceElements");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getSourceElements");
            if (requestBody == null) {
                response.setElements(handler.getSourceElements(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElements(handler.getSourceElements(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSourceElements", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMetadataElementSummariesResponse getElementsSourceFrom(String serverName, String elementGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getElementsSourceFrom";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getElementsSourceFrom");
        RelatedMetadataElementSummariesResponse response = new RelatedMetadataElementSummariesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getElementsSourceFrom");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getElementsSourceFrom");
            StewardshipManagementClient handler = instanceHandler.getStewardshipManagementClient(userId, serverName, "getElementsSourceFrom");
            if (requestBody == null) {
                response.setElements(handler.getElementsSourceFrom(userId, elementGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            } else {
                response.setElements(handler.getElementsSourceFrom(userId, elementGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Exception error) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getElementsSourceFrom", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

