/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarybrowser.server;

import java.util.Arrays;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermStatus;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.HistoryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.GlossaryBrowserInstanceHandler;
import org.slf4j.LoggerFactory;

public class GlossaryBrowserRESTServices
extends TokenController {
    private static final GlossaryBrowserInstanceHandler instanceHandler = new GlossaryBrowserInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryBrowserRESTServices.class), instanceHandler.getServiceName());

    public GlossaryTermStatusListResponse getGlossaryTermStatuses(String serverName) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermStatuses");
        GlossaryTermStatusListResponse response = new GlossaryTermStatusListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermStatuses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermStatus.values()));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(String serverName) {
        String methodName = "getGlossaryTermRelationshipStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermRelationshipStatuses");
        GlossaryTermRelationshipStatusListResponse response = new GlossaryTermRelationshipStatusListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermRelationshipStatuses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermRelationshipStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermRelationshipStatus.values()));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermRelationshipStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(String serverName) {
        String methodName = "getGlossaryTermActivityTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermActivityTypes");
        GlossaryTermActivityTypeListResponse response = new GlossaryTermActivityTypeListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermActivityTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermActivityTypes");
            response.setTypes(Arrays.asList(GlossaryTermActivityType.values()));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermActivityTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse findGlossaries(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, SearchStringRequestBody requestBody) {
        String methodName = "findGlossaries";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGlossaries");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGlossaries");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaries");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "findGlossaries");
                response.setElementList(handler.findGlossaries(userId, null, null, instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaries", serverName, SearchStringRequestBody.class.getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findGlossaries", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementsResponse getGlossariesByName(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, NameRequestBody requestBody) {
        String methodName = "getGlossariesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossariesByName");
        GlossaryElementsResponse response = new GlossaryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossariesByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossariesByName");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossariesByName");
                response.setElementList(handler.getGlossariesByName(userId, null, null, requestBody.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossariesByName", serverName, NameRequestBody.class.getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossariesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryByGUID(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryByGUID");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryByGUID");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryByGUID(userId, null, null, glossaryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryByGUID(userId, null, null, glossaryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryForCategory(String serverName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryForCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryForCategory");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryForCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryForCategory");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryForCategory");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryForCategory(userId, null, null, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryForCategory(userId, null, null, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryForCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryElementResponse getGlossaryForTerm(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryForTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryForTerm");
        GlossaryElementResponse response = new GlossaryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryForTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryForTerm");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryForTerm");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryForTerm(userId, null, null, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryForTerm(userId, null, null, glossaryTermGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryForTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse findGlossaryCategories(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGlossaryCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGlossaryCategories");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryCategories");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "findGlossaryCategories");
                response.setElementList(handler.findGlossaryCategories(userId, null, null, requestBody.getGlossaryGUID(), instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaryCategories", serverName, GlossarySearchStringRequestBody.class.getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findGlossaryCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForGlossary(String serverName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getCategoriesForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCategoriesForGlossary");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCategoriesForGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForGlossary");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getCategoriesForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getCategoriesForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCategoriesForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getCategoriesForTerm(String serverName, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getCategoriesForTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getCategoriesForTerm");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getCategoriesForTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCategoriesForTerm");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getCategoriesForTerm");
            if (requestBody != null) {
                response.setElementList(handler.getCategoriesForTerm(userId, null, null, glossaryTermGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getCategoriesForTerm(userId, null, null, glossaryTermGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getCategoriesForTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryCategoriesByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryCategoriesByName");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryCategoriesByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoriesByName");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryCategoriesByName");
                response.setElementList(handler.getGlossaryCategoriesByName(userId, null, null, requestBody.getGlossaryGUID(), requestBody.getName(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryCategoriesByName", serverName, GlossaryNameRequestBody.class.getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryCategoriesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(String serverName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryCategoryByGUID");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryCategoryByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryByGUID");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryCategoryByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, null, null, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryCategoryByGUID(userId, null, null, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryCategoryByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementResponse getGlossaryCategoryParent(String serverName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryCategoryParent");
        GlossaryCategoryElementResponse response = new GlossaryCategoryElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryCategoryParent");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryCategoryParent");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryCategoryParent");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryCategoryParent(userId, null, null, glossaryCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryCategoryParent(userId, null, null, glossaryCategoryGUID, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryCategoryElementsResponse getGlossarySubCategories(String serverName, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossarySubCategories";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossarySubCategories");
        GlossaryCategoryElementsResponse response = new GlossaryCategoryElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossarySubCategories");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossarySubCategories");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossarySubCategories");
            if (requestBody != null) {
                response.setElementList(handler.getGlossarySubCategories(userId, null, null, glossaryCategoryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getGlossarySubCategories(userId, null, null, glossaryCategoryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossarySubCategories", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse findGlossaryTerms(String serverName, int startFrom, int pageSize, boolean startsWith, boolean endsWith, boolean ignoreCase, boolean forLineage, boolean forDuplicateProcessing, GlossarySearchStringRequestBody requestBody) {
        String methodName = "findGlossaryTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "findGlossaryTerms");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "findGlossaryTerms");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findGlossaryTerms");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "findGlossaryTerms");
                response.setElementList(handler.findGlossaryTerms(userId, null, null, requestBody.getGlossaryGUID(), instanceHandler.getSearchString(requestBody.getSearchString(), startsWith, endsWith, ignoreCase), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "findGlossaryTerms", serverName, GlossarySearchStringRequestBody.class.getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "findGlossaryTerms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossary(String serverName, String glossaryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getTermsForGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTermsForGlossary");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTermsForGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossary");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getTermsForGlossary");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getTermsForGlossary(userId, null, null, glossaryGUID, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTermsForGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getTermsForGlossaryCategory(String serverName, String glossaryCategoryGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getTermsForGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTermsForGlossaryCategory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTermsForGlossaryCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermsForGlossaryCategory");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getTermsForGlossaryCategory");
            if (requestBody != null) {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, null, null, glossaryCategoryGUID, requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getTermsForGlossaryCategory(userId, null, null, glossaryCategoryGUID, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTermsForGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getRelatedTerms(String serverName, String glossaryTermGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermRelationshipRequestBody requestBody) {
        String methodName = "getRelatedTerms";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getRelatedTerms");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getRelatedTerms");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedTerms");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getRelatedTerms");
            if (requestBody != null) {
                response.setElementList(handler.getRelatedTerms(userId, null, null, glossaryTermGUID, requestBody.getRelationshipTypeName(), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElementList(handler.getRelatedTerms(userId, null, null, glossaryTermGUID, null, null, startFrom, pageSize, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRelatedTerms", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermsByName(String serverName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, GlossaryNameRequestBody requestBody) {
        String methodName = "getGlossaryTermsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermsByName");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermsByName");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryTermsByName");
                response.setElementList(handler.getGlossaryTermsByName(userId, null, null, requestBody.getGlossaryGUID(), requestBody.getName(), requestBody.getLimitResultsByStatus(), startFrom, pageSize, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermsByName", serverName, GlossaryNameRequestBody.class.getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse getGlossaryTermByGUID(String serverName, String guid, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getGlossaryTermByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermByGUID");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermByGUID");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryTermByGUID");
            if (requestBody != null) {
                response.setElement(handler.getGlossaryTermByGUID(userId, null, null, guid, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.getGlossaryTermByGUID(userId, null, null, guid, null, forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementsResponse getGlossaryTermHistory(String serverName, String guid, int startFrom, int pageSize, boolean oldestFirst, boolean forLineage, boolean forDuplicateProcessing, HistoryRequestBody requestBody) {
        String methodName = "getGlossaryTermHistory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermHistory");
        GlossaryTermElementsResponse response = new GlossaryTermElementsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermHistory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermHistory");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getGlossaryTermHistory");
                response.setElementList(handler.getGlossaryTermHistory(userId, null, null, guid, requestBody.getFromTime(), requestBody.getToTime(), startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, requestBody.getEffectiveTime()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getGlossaryTermHistory", serverName, HistoryRequestBody.class.getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermHistory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

