/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarybrowser.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.properties.FeedbackProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.RatingProperties;
import org.odpi.openmetadata.accessservices.assetmanager.properties.TagProperties;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.CommentElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.InformalTagsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.NoteLogElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.HistoryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.InformalTagUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.GlossaryBrowserRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/glossary-browser/users/{userId}"})
@Tag(name="Glossary Browser OMVS", description="Explore the contents of a glossary, such as its top-level glossary element, glossary categories and glossary terms, along with the elements that are linked to the terms, such assets.  Each operation includes optional forLineage and forDuplicateProcessing request parameters and an optional request body that includes an effective time field.  These affect the elements that are returned on the query.", externalDocs=@ExternalDocumentation(description="Glossary Browser View Service (OMVS)", url="https://egeria-project.org/services/omvs/glossary-browser/overview/"))
public class GlossaryBrowserResource {
    private final GlossaryBrowserRESTServices restAPI = new GlossaryBrowserRESTServices();

    @GetMapping(path={"/glossaries/terms/status-list"})
    @Operation(summary="getGlossaryTermStatuses", description="Return the list of glossary term status enum values.  These values are used in a glossary workflow to describe the state of the content of the term.", externalDocs=@ExternalDocumentation(description="Controlled glossary terms", url="https://egeria-project.org/services/omvs/glossary-workflow/overview/#controlled-glossary-terms"))
    public GlossaryTermStatusListResponse getGlossaryTermStatuses(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGlossaryTermStatuses(serverName, userId);
    }

    @GetMapping(path={"/glossaries/terms/relationships/status-list"})
    @Operation(summary="getGlossaryTermRelationshipStatuses", description="Return the list of glossary term relationship status enum values.  These values are stored in a term-ot-term, or term-to-category, relationship and are used to indicate how much the relationship should be trusted", externalDocs=@ExternalDocumentation(description="Relationship statuses", url="https://egeria-project.org/services/omvs/glossary-workflow/overview/#relationship-statuses"))
    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGlossaryTermRelationshipStatuses(serverName, userId);
    }

    @GetMapping(path={"/glossaries/terms/activity-types"})
    @Operation(summary="getGlossaryTermActivityTypes", description="Return the list of glossary term activity type enum values.  These values are used in the ActivityDescription classification that is attached to a glossary term that represents some type of activity.", externalDocs=@ExternalDocumentation(description="Activity description", url="https://egeria-project.org/types/3/0340-Dictionary/#activitydescription"))
    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getGlossaryTermActivityTypes(serverName, userId);
    }

    @PostMapping(path={"/glossaries/by-search-string"})
    @Operation(summary="findGlossaries", description="Retrieve the list of glossary metadata elements that contain the search string.  The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementsResponse findGlossaries(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaries(serverName, userId, startFrom, pageSize, startsWith, endsWith, ignoreCase, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/by-name"})
    @Operation(summary="getGlossariesByName", description="Retrieve the list of glossary metadata elements with an exactly matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementsResponse getGlossariesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGlossariesByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/retrieve"})
    @Operation(summary="getGlossaryByGUID", description="Retrieve the glossary metadata element with the supplied unique identifier.  The optional request body allows you to specify that the glossary element should only be returned if it was effective at a particular time.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementResponse getGlossaryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryByGUID(serverName, userId, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/for-category/{glossaryCategoryGUID}/retrieve"})
    @Operation(summary="getGlossaryForCategory", description="Retrieve the glossary metadata element for the requested category.  The optional request body allows you to specify that the glossary element should only be returned if it was effective at a particular time.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementResponse getGlossaryForCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryForCategory(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/for-term/{glossaryTermGUID}/retrieve"})
    @Operation(summary="getGlossaryForTerm", description="Retrieve the glossary metadata element for the requested term.  The optional request body allows you to specify that the glossary element should only be returned if it was effective at a particular time.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementResponse getGlossaryForTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryForTerm(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-search-string"})
    @Operation(summary="findGlossaryCategories", description="Retrieve the list of glossary category metadata elements that contain the search string.  The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of a glossaryGUID to restrict the search to within a single glossary.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse findGlossaryCategories(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossarySearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryCategories(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, startsWith, endsWith, ignoreCase, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories/retrieve"})
    @Operation(summary="getCategoriesForGlossary", description="Return the list of categories associated with a glossary.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getCategoriesForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCategoriesForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/categories/retrieve"})
    @Operation(summary="getCategoriesForTerm", description="Return the list of categories associated with a term.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getCategoriesForTerm(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCategoriesForTerm(serverName, userId, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-name"})
    @Operation(summary="getGlossaryCategoriesByName", description="Retrieve the list of glossary category metadata elements that either have the requested qualified name or display name.  The name to search for is located in the request body and is interpreted as a plain string.  The request body also supports the specification of a glossaryGUID to restrict the search to within a single glossary.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryNameRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoriesByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/retrieve"})
    @Operation(summary="getGlossaryCategoryByGUID", description="Retrieve the requested glossary category metadata element.  The optional request body contain an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryByGUID(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/parent/retrieve"})
    @Operation(summary="getGlossaryCategoryParent", description="Glossary categories can be organized in a hierarchy. Retrieve the parent glossary category metadata element for the glossary category with the supplied unique identifier.  If the requested category does not have a parent category, null is returned.  The optional request body contain an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementResponse getGlossaryCategoryParent(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryParent(serverName, userId, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/subcategories/retrieve"})
    @Operation(summary="getGlossarySubCategories", description="Glossary categories can be organized in a hierarchy. Retrieve the subcategories for the glossary category metadata element with the supplied unique identifier.  If the requested category does not have any subcategories, null is returned.  The optional request body contain an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getGlossarySubCategories(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossarySubCategories(serverName, userId, glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-search-string"})
    @Operation(summary="findGlossaryTerms", description="Retrieve the list of glossary term metadata elements that contain the search string.  The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of a glossaryGUID to restrict the search to within a single glossary.", externalDocs=@ExternalDocumentation(description="Glossary term metadata element", url="https://egeria-project.org/types/3/0330-Terms/"))
    public GlossaryTermElementsResponse findGlossaryTerms(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossarySearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryTerms(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, startsWith, endsWith, ignoreCase, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/retrieve"})
    @Operation(summary="getTermsForGlossary", description="Retrieve the list of glossary terms associated with a glossary.  The request body also supports the specification of an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary term metadata element", url="https://egeria-project.org/types/3/0330-Terms/"))
    public GlossaryTermElementsResponse getTermsForGlossary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getTermsForGlossary(serverName, userId, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/retrieve"})
    public GlossaryTermElementsResponse getTermsForGlossaryCategory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) GlossaryTermRelationshipRequestBody requestBody) {
        return this.restAPI.getTermsForGlossaryCategory(serverName, userId, glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/related-terms"})
    public GlossaryTermElementsResponse getRelatedTerms(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) GlossaryTermRelationshipRequestBody requestBody) {
        return this.restAPI.getRelatedTerms(serverName, userId, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-name"})
    public GlossaryTermElementsResponse getGlossaryTermsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryNameRequestBody requestBody) {
        return this.restAPI.getGlossaryTermsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/retrieve"})
    public GlossaryTermElementResponse getGlossaryTermByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryTermByGUID(serverName, userId, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/history"})
    public GlossaryTermElementsResponse getGlossaryTermHistory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean oldestFirst, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) HistoryRequestBody requestBody) {
        return this.restAPI.getGlossaryTermHistory(serverName, userId, glossaryTermGUID, startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}/replies"})
    @Operation(summary="addCommentReply", description="Adds a reply to a comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentReply(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestParam boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentReply(serverName, userId, commentGUID, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments"})
    @Operation(summary="addCommentToElement", description="Creates a comment and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public GUIDResponse addCommentToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.addCommentToElement(serverName, userId, elementGUID, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes"})
    @Operation(summary="addLikeToElement", description="Creates a <i>like</i> object and attaches it to an element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addLikeToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.addLikeToElement(serverName, userId, elementGUID, isPublic, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings"})
    @Operation(summary="addRatingToElement", description="Adds a star rating and optional review text to the element.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse addRatingToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam boolean isPublic, @RequestBody RatingProperties requestBody) {
        return this.restAPI.addRatingToElement(serverName, userId, elementGUID, isPublic, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}"})
    @Operation(summary="addTagToElement", description="Adds an informal tag (either private of public) to an element.", externalDocs=@ExternalDocumentation(description="Element Classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse addTagToElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody FeedbackProperties requestBody) {
        return this.restAPI.addTagToElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/tags"})
    @Operation(summary="createInformalTag", description="Creates a new informal tag and returns the unique identifier for it.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public GUIDResponse createInformalTag(@PathVariable String serverName, @PathVariable String userId, @RequestBody TagProperties requestBody) {
        return this.restAPI.createInformalTag(serverName, userId, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/remove"})
    @Operation(summary="deleteTag", description="Removes an informal tag from the repository.  All the tagging relationships to this informal tag are lost.  A private tag can be deleted by its creator and all the references are lost; a public tag can be deleted by anyone, but only if it is not attached to any referenceable.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse deleteTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteTag(serverName, userId, tagGUID, requestBody);
    }

    @GetMapping(path={"/elements/by-tag/{tagGUID}"})
    @Operation(summary="getElementsByTag", description="Return the list of unique identifiers for elements that are linked to a specific tag either directly, or via one of its schema elements.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public GUIDListResponse getElementsByTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getElementsByTag(serverName, userId, tagGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/tags/{tagGUID}"})
    @Operation(summary="getTag", description="Return the informal tag for the supplied unique identifier (tagGUID).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagResponse getTag(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID) {
        return this.restAPI.getTag(serverName, userId, tagGUID);
    }

    @PostMapping(path={"/tags/by-name"})
    @Operation(summary="getTagsByName", description="Return the tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getTagsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/tags/private/by-name"})
    @Operation(summary="getMyTagsByName", description="Return the list of the calling user's private informal tags exactly matching the supplied name.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse getMyTagsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMyTagsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/comments/by-search-string"})
    @Operation(summary="findComment", description="Return the list of comments containing the supplied string. The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of an effective time to restrict the search to element that are/were effective at a particular time.", externalDocs=@ExternalDocumentation(description="Comment", url="https://egeria-project.org/concepts/comment/"))
    public CommentElementsResponse findComments(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findComments(serverName, userId, startFrom, pageSize, startsWith, endsWith, ignoreCase, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/tags/by-search-string"})
    @Operation(summary="findTags", description="Return the list of informal tags containing the supplied string in their name or description. The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of an effective time to restrict the search to element that are/were effective at a particular time.", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findTags(serverName, userId, startFrom, pageSize, startsWith, endsWith, ignoreCase, requestBody);
    }

    @PostMapping(path={"/tags/private/by-search-string"})
    @Operation(summary="findMyTags", description="Return the list of the calling user's private tags containing the supplied string in either the name or description.  The search string is a regular expression (RegEx).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public InformalTagsResponse findMyTags(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findMyTags(serverName, userId, startFrom, pageSize, startsWith, endsWith, ignoreCase, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments/{commentGUID}/remove"})
    @Operation(summary="removeCommentFromElement", description="Removes a comment added to the element by this user.  This deletes the link to the comment, the comment itself and any comment replies attached to it.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeCommentFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeCommentFromElement(serverName, userId, elementGUID, commentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}"})
    public CommentElementResponse getComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCommentByGUID(serverName, userId, commentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/comments/retrieve"})
    public CommentElementsResponse getAttachedComments(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getAttachedComments(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/likes/remove"})
    @Operation(summary="removeLikeFromElement", description="Removes a <i>Like</i> added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#element-feedback"))
    public VoidResponse removeLikeFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeLikeFromElement(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/ratings/remove"})
    @Operation(summary="removeRatingFromElement", description="Removes of a star rating/review that was added to the element by this user.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse removeRatingFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeRatingFromElement(serverName, userId, elementGUID, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/tags/{tagGUID}/remove"})
    @Operation(summary="removeTagFromElement", description="Removes a link between a tag and an element that was added by this user.", externalDocs=@ExternalDocumentation(description="Element classifiers", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-classifiers"))
    public VoidResponse removeTagFromElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @PathVariable String tagGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeTagFromElement(serverName, userId, elementGUID, tagGUID, requestBody);
    }

    @PostMapping(path={"/comments/{commentGUID}/update"})
    @Operation(summary="updateComment", description="Update an existing comment.", externalDocs=@ExternalDocumentation(description="Element Feedback", url="https://egeria-project.org/patterns/metadata-manager/overview/#asset-feedback"))
    public VoidResponse updateComment(@PathVariable String serverName, @PathVariable String userId, @PathVariable String commentGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam boolean isPublic, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateComment(serverName, userId, commentGUID, isMergeUpdate, isPublic, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}"})
    public VoidResponse setupAcceptedAnswer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupAcceptedAnswer(serverName, userId, questionCommentGUID, answerCommentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/comments/questions/{questionCommentGUID}/answers/{answerCommentGUID}/remove"})
    public VoidResponse clearAcceptedAnswer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String questionCommentGUID, @PathVariable String answerCommentGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearAcceptedAnswer(serverName, userId, questionCommentGUID, answerCommentGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/tags/{tagGUID}/update"})
    @Operation(summary="updateTagDescription", description="Updates the description of an existing tag (either private or public).", externalDocs=@ExternalDocumentation(description="Informal Tag", url="https://egeria-project.org/concepts/informal-tag/"))
    public VoidResponse updateTagDescription(@PathVariable String serverName, @PathVariable String userId, @PathVariable String tagGUID, @RequestBody InformalTagUpdateRequestBody requestBody) {
        return this.restAPI.updateTagDescription(serverName, userId, tagGUID, requestBody);
    }

    @PostMapping(value={"/note-logs/by-search-string"})
    public NoteLogElementsResponse findNoteLogs(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findNoteLogs(serverName, userId, startFrom, pageSize, startsWith, endsWith, ignoreCase, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/by-name"})
    public NoteLogElementsResponse getNoteLogsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getNoteLogsByName(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/elements/{elementGUID}/note-logs/retrieve"})
    public NoteLogElementsResponse getNoteLogsForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteLogsForElement(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/retrieve"})
    public NoteLogElementResponse getNoteLogByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteLogByGUID(serverName, userId, noteLogGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/by-search-string"})
    public NoteElementsResponse findNotes(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findNotes(serverName, userId, startFrom, pageSize, startsWith, endsWith, ignoreCase, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/{noteLogGUID}/notes/retrieve"})
    public NoteElementsResponse getNotesForNoteLog(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNotesForNoteLog(serverName, userId, noteLogGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/note-logs/notes/{noteGUID}/retrieve"})
    public NoteElementResponse getNoteByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String noteGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getNoteByGUID(serverName, userId, noteGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-data-field"})
    public ElementStubsResponse getDataFieldClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getDataFieldClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-confidence"})
    public ElementStubsResponse getConfidenceClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getConfidenceClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-criticality"})
    public ElementStubsResponse getCriticalityClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getCriticalityClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-confidentiality"})
    public ElementStubsResponse getConfidentialityClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getConfidentialityClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-retention"})
    public ElementStubsResponse getRetentionClassifiedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getRetentionClassifiedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-security-tags"})
    public ElementStubsResponse getSecurityTaggedElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getSecurityTaggedElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-ownership"})
    public ElementStubsResponse getOwnersElements(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getOwnersElements(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-subject-area-membership"})
    public ElementStubsResponse getMembersOfSubjectArea(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getMembersOfSubjectArea(serverName, userId, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/glossaries/terms/by-semantic-assignment/{elementGUID}"})
    public GlossaryTermElementsResponse getMeanings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getMeanings(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/elements/by-semantic-assignment/{glossaryTermGUID}"})
    public RelatedElementsResponse getSemanticAssignees(@PathVariable String serverName, @PathVariable String userId, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSemanticAssignees(serverName, userId, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/governed-by/{governanceDefinitionGUID}"})
    public RelatedElementsResponse getGovernedElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String governanceDefinitionGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGovernedElements(serverName, userId, governanceDefinitionGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by"})
    public GovernanceDefinitionsResponse getGovernedByDefinitions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGovernedByDefinitions(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/sourced-from/{elementGUID}"})
    public RelatedElementsResponse getSourceElements(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSourceElements(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/sourced-from"})
    public RelatedElementsResponse getElementsSourceFrom(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getElementsSourceFrom(serverName, userId, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }
}

