/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarybrowser.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.accessservices.assetmanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.RelatedElementsResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworkservices.gaf.rest.OpenMetadataElementResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.GlossaryBrowserRESTServices;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.spring.beans.ExternalGlossaryLink;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.spring.beans.Glossary;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.spring.beans.GlossaryCategory;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.spring.beans.GlossaryTerm;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.spring.beans.GlossaryViewClassification;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.spring.beans.GlossaryViewEntityDetail;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/glossary-browser/old/glossaries"})
@Tag(name="API: Glossary Browser OMVS", description="Explore the contents of a glossary, such as its top-level glossary element, glossary categories and glossary terms, along with the elements that are linked to the terms, such assets.  Each operation includes optional forLineage and forDuplicateProcessing request parameters and an optional request body that includes an effective time field.  These affect the elements that are returned on the query.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/glossary-browser/overview/"))
@Deprecated
public class GlossaryViewController {
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final GlossaryBrowserRESTServices restAPI = new GlossaryBrowserRESTServices();

    @GetMapping
    public List<Glossary> getAllGlossaries(@PathVariable String serverName, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getAllGlossaries";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        GlossaryElementsResponse restResult = this.restAPI.findGlossaries(serverName, from.intValue(), size.intValue(), false, false, true, false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAllGlossaries", (FFDCResponse)restResult);
        return this.convertGlossaries(restResult.getElementList());
    }

    @GetMapping(value={"/terms"})
    public List<GlossaryTerm> getAllGlossaryTerms(@PathVariable String serverName, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getAllGlossaryTerms";
        GlossarySearchStringRequestBody requestBody = new GlossarySearchStringRequestBody();
        GlossaryTermElementsResponse restResult = this.restAPI.findGlossaryTerms(serverName, from.intValue(), size.intValue(), false, false, true, false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAllGlossaryTerms", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/categories"})
    public List<GlossaryCategory> getAllGlossaryCategories(@PathVariable String serverName, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getAllGlossaryCategories";
        GlossarySearchStringRequestBody requestBody = new GlossarySearchStringRequestBody();
        GlossaryCategoryElementsResponse restResult = this.restAPI.findGlossaryCategories(serverName, from.intValue(), size.intValue(), false, false, true, false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAllGlossaryCategories", (FFDCResponse)restResult);
        return this.convertGlossaryCategories(restResult.getElementList());
    }

    @GetMapping(value={"/{glossaryGUID}"})
    public Glossary getGlossary(@PathVariable String serverName, @PathVariable(value="glossaryGUID") String glossaryGUID) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getGlossary";
        GlossaryElementResponse restResult = this.restAPI.getGlossaryByGUID(serverName, glossaryGUID, false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getGlossary", (FFDCResponse)restResult);
        return this.convertGlossary(restResult.getElement());
    }

    @GetMapping(value={"/{glossaryGUID}/categories"})
    public List<GlossaryCategory> getCategories(@PathVariable String serverName, @PathVariable(value="glossaryGUID") String glossaryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getCategories";
        GlossaryCategoryElementsResponse restResult = this.restAPI.getCategoriesForGlossary(serverName, glossaryGUID, from.intValue(), size.intValue(), false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getCategories", (FFDCResponse)restResult);
        return this.convertGlossaryCategories(restResult.getElementList());
    }

    @GetMapping(value={"/{glossaryGUID}/terms"})
    public List<GlossaryTerm> getTermsOfGlossary(@PathVariable String serverName, @PathVariable(value="glossaryGUID") String glossaryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getTermsOfGlossary";
        GlossaryTermElementsResponse restResult = this.restAPI.getTermsForGlossary(serverName, glossaryGUID, from.intValue(), size.intValue(), false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getTermsOfGlossary", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/{glossaryGUID}/externalGlossaryLinks"})
    public List<ExternalGlossaryLink> getExternalGlossaryLinksOfGlossary(@PathVariable String serverName, @PathVariable(value="glossaryGUID") String glossaryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return null;
    }

    @GetMapping(value={"/terms/{termGUID}"})
    public GlossaryTerm getTerm(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getTerm";
        GlossaryTermElementResponse restResult = this.restAPI.getGlossaryTermByGUID(serverName, termGUID, false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getTerm", (FFDCResponse)restResult);
        return this.convertGlossaryTerm(restResult.getElement());
    }

    @GetMapping(value={"/terms/{termGUID}/antonyms"})
    public List<GlossaryTerm> getAntonyms(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getAntonyms";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("Antonym");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAntonyms", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/assignedElements"})
    public List<GlossaryViewEntityDetail> getAssignedElements(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getAssignedElements";
        RelatedElementsResponse restResult = this.restAPI.getSemanticAssignees(serverName, termGUID, from.intValue(), size.intValue(), false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAssignedElements", (FFDCResponse)restResult);
        if (restResult != null && restResult.getElementList() != null) {
            ArrayList<GlossaryViewEntityDetail> results = new ArrayList<GlossaryViewEntityDetail>();
            for (RelatedElement relatedElement : restResult.getElementList()) {
                OpenMetadataElementResponse openMetadataElement = this.restAPI.getMetadataElementByGUID(serverName, relatedElement.getRelatedElement().getGUID(), false, false, null);
                this.exceptionHandler.detectAndThrowStandardExceptions("getAssignedElements", (FFDCResponse)restResult);
                if (openMetadataElement.getElement() == null) continue;
                results.add(this.convertOpenMetadataElement(openMetadataElement.getElement()));
            }
            return results;
        }
        return null;
    }

    @GetMapping(value={"/terms/{termGUID}/attributes"})
    public List<GlossaryTerm> getAttributes(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getAttributes";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("TermHASARelationship");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAttributes", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/isA"})
    public List<GlossaryTerm> getIsATerms(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getIsATerms";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("ISARelationship");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getIsATerms", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/preferredTerms"})
    public List<GlossaryTerm> getPreferredTerms(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getPreferredTerms";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("PreferredTerm");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getPreferredTerms", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/relatedTerms"})
    public List<GlossaryTerm> getRelatedTerms(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getRelatedTerms";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("RelatedTerm");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getRelatedTerms", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/replacementTerms"})
    public List<GlossaryTerm> getReplacementTerms(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getReplacementTerms";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("ReplacementTerm");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getReplacementTerms", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/subtypes"})
    public List<GlossaryTerm> getSubtypes(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getSubtypes";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("TermISATYPEOFRelationship");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getSubtypes", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/synonyms"})
    public List<GlossaryTerm> getSynonyms(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getSynonyms";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("Synonym");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getSynonyms", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/translations"})
    public List<GlossaryTerm> getTranslations(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getTranslations";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("Translation");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getTranslations", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/types"})
    public List<GlossaryTerm> getTypedBys(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getTypedBys";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("TermTYPEDBYRelationship");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getTypedBys", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/usedInContext"})
    public List<GlossaryTerm> getUsedInContexts(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getUsedInContexts";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("UsedInContext");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getUsedInContexts", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/validValues"})
    public List<GlossaryTerm> getValidValues(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getValidValues";
        GlossaryTermRelationshipRequestBody requestBody = new GlossaryTermRelationshipRequestBody();
        requestBody.setRelationshipTypeName("ValidValue");
        GlossaryTermElementsResponse restResult = this.restAPI.getRelatedTerms(serverName, termGUID, from.intValue(), size.intValue(), false, false, requestBody);
        this.exceptionHandler.detectAndThrowStandardExceptions("getValidValues", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/terms/{termGUID}/homeGlossary"})
    public Glossary getTermHomeGlossary(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getTermHomeGlossary";
        GlossaryElementResponse restResult = this.restAPI.getGlossaryForTerm(serverName, termGUID, false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getTermHomeGlossary", (FFDCResponse)restResult);
        return this.convertGlossary(restResult.getElement());
    }

    @GetMapping(value={"/terms/{termGUID}/externalGlossaryLinks"})
    public List<ExternalGlossaryLink> getExternalGlossaryLinksOfTerm(@PathVariable String serverName, @PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return null;
    }

    @GetMapping(value={"/categories/{categoryGUID}"})
    public GlossaryCategory getCategory(@PathVariable String serverName, @PathVariable(value="categoryGUID") String categoryGUID) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getCategory";
        GlossaryCategoryElementResponse restResult = this.restAPI.getGlossaryCategoryByGUID(serverName, categoryGUID, false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getCategory", (FFDCResponse)restResult);
        return this.convertGlossaryCategory(restResult.getElement());
    }

    @GetMapping(value={"/categories/{categoryGUID}/homeGlossary"})
    public Glossary getCategoryHomeGlossary(@PathVariable String serverName, @PathVariable(value="categoryGUID") String categoryGUID) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getCategoryHomeGlossary";
        GlossaryElementResponse restResult = this.restAPI.getGlossaryForCategory(serverName, categoryGUID, false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getCategoryHomeGlossary", (FFDCResponse)restResult);
        return this.convertGlossary(restResult.getElement());
    }

    @GetMapping(value={"/categories/{categoryGUID}/subcategories"})
    public List<GlossaryCategory> getSubcategories(@PathVariable String serverName, @PathVariable(value="categoryGUID") String categoryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getSubcategories";
        GlossaryCategoryElementsResponse restResult = this.restAPI.getGlossarySubCategories(serverName, categoryGUID, from.intValue(), size.intValue(), false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getSubcategories", (FFDCResponse)restResult);
        return this.convertGlossaryCategories(restResult.getElementList());
    }

    @GetMapping(value={"/categories/{categoryGUID}/terms"})
    public List<GlossaryTerm> getTermsOfCategory(@PathVariable String serverName, @PathVariable(value="categoryGUID") String categoryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        String methodName = "getTermsOfCategory";
        GlossaryTermElementsResponse restResult = this.restAPI.getTermsForGlossaryCategory(serverName, categoryGUID, from.intValue(), size.intValue(), false, false, null);
        this.exceptionHandler.detectAndThrowStandardExceptions("getTermsOfCategory", (FFDCResponse)restResult);
        return this.convertGlossaryTerms(restResult.getElementList());
    }

    @GetMapping(value={"/categories/{categoryGUID}/externalGlossaryLinks"})
    public List<ExternalGlossaryLink> getExternalGlossaryLinks(@PathVariable String serverName, @PathVariable(value="categoryGUID") String categoryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws UserNotAuthorizedException, InvalidParameterException, PropertyServerException {
        return null;
    }

    private List<Glossary> convertGlossaries(List<GlossaryElement> openMetadataGlossaryElements) {
        if (openMetadataGlossaryElements != null) {
            ArrayList<Glossary> results = new ArrayList<Glossary>();
            for (GlossaryElement openMetadataGlossaryElement : openMetadataGlossaryElements) {
                results.add(this.convertGlossary(openMetadataGlossaryElement));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private Glossary convertGlossary(GlossaryElement openMetadataGlossaryElement) {
        if (openMetadataGlossaryElement != null) {
            Glossary glossary = new Glossary();
            glossary.setGuid(openMetadataGlossaryElement.getElementHeader().getGUID());
            glossary.setTypeDefName(openMetadataGlossaryElement.getElementHeader().getType().getTypeName());
            glossary.setVersion(openMetadataGlossaryElement.getElementHeader().getVersions().getVersion());
            glossary.setCreatedBy(openMetadataGlossaryElement.getElementHeader().getVersions().getCreatedBy());
            glossary.setCreateTime(openMetadataGlossaryElement.getElementHeader().getVersions().getCreateTime());
            glossary.setUpdatedBy(openMetadataGlossaryElement.getElementHeader().getVersions().getUpdatedBy());
            glossary.setUpdateTime(openMetadataGlossaryElement.getElementHeader().getVersions().getUpdateTime());
            glossary.setStatus(openMetadataGlossaryElement.getElementHeader().getStatus().getName());
            glossary.setEffectiveFromTime(openMetadataGlossaryElement.getGlossaryProperties().getEffectiveFrom());
            glossary.setEffectiveToTime(openMetadataGlossaryElement.getGlossaryProperties().getEffectiveTo());
            glossary.setClassifications(this.convertClassifications(openMetadataGlossaryElement.getElementHeader().getClassifications()));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(OpenMetadataProperty.QUALIFIED_NAME.name, openMetadataGlossaryElement.getGlossaryProperties().getQualifiedName());
            properties.put(OpenMetadataProperty.DISPLAY_NAME.name, openMetadataGlossaryElement.getGlossaryProperties().getDisplayName());
            properties.put(OpenMetadataProperty.DESCRIPTION.name, openMetadataGlossaryElement.getGlossaryProperties().getDescription());
            properties.put("language", openMetadataGlossaryElement.getGlossaryProperties().getLanguage());
            properties.put(OpenMetadataProperty.USAGE.name, openMetadataGlossaryElement.getGlossaryProperties().getUsage());
            if (openMetadataGlossaryElement.getGlossaryProperties().getExtendedProperties() != null) {
                for (String propertyName : openMetadataGlossaryElement.getGlossaryProperties().getExtendedProperties().keySet()) {
                    if (openMetadataGlossaryElement.getGlossaryProperties().getExtendedProperties().get(propertyName) != null) {
                        properties.put(propertyName, openMetadataGlossaryElement.getGlossaryProperties().getExtendedProperties().get(propertyName).toString());
                        continue;
                    }
                    properties.put(propertyName, null);
                }
            }
            glossary.setProperties(properties);
            return glossary;
        }
        return null;
    }

    private List<GlossaryTerm> convertGlossaryTerms(List<GlossaryTermElement> openMetadataGlossaryTermElements) {
        if (openMetadataGlossaryTermElements != null) {
            ArrayList<GlossaryTerm> results = new ArrayList<GlossaryTerm>();
            for (GlossaryTermElement openMetadataGlossaryTermElement : openMetadataGlossaryTermElements) {
                results.add(this.convertGlossaryTerm(openMetadataGlossaryTermElement));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private GlossaryTerm convertGlossaryTerm(GlossaryTermElement openMetadataGlossaryTermElement) {
        if (openMetadataGlossaryTermElement != null) {
            GlossaryTerm glossaryTerm = new GlossaryTerm();
            glossaryTerm.setGuid(openMetadataGlossaryTermElement.getElementHeader().getGUID());
            glossaryTerm.setTypeDefName(openMetadataGlossaryTermElement.getElementHeader().getType().getTypeName());
            glossaryTerm.setVersion(openMetadataGlossaryTermElement.getElementHeader().getVersions().getVersion());
            glossaryTerm.setCreatedBy(openMetadataGlossaryTermElement.getElementHeader().getVersions().getCreatedBy());
            glossaryTerm.setCreateTime(openMetadataGlossaryTermElement.getElementHeader().getVersions().getCreateTime());
            glossaryTerm.setUpdatedBy(openMetadataGlossaryTermElement.getElementHeader().getVersions().getUpdatedBy());
            glossaryTerm.setUpdateTime(openMetadataGlossaryTermElement.getElementHeader().getVersions().getUpdateTime());
            glossaryTerm.setStatus(openMetadataGlossaryTermElement.getElementHeader().getStatus().getName());
            glossaryTerm.setEffectiveFromTime(openMetadataGlossaryTermElement.getGlossaryTermProperties().getEffectiveFrom());
            glossaryTerm.setEffectiveToTime(openMetadataGlossaryTermElement.getGlossaryTermProperties().getEffectiveTo());
            glossaryTerm.setClassifications(this.convertClassifications(openMetadataGlossaryTermElement.getElementHeader().getClassifications()));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(OpenMetadataProperty.QUALIFIED_NAME.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getQualifiedName());
            properties.put(OpenMetadataProperty.DISPLAY_NAME.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getDisplayName());
            properties.put(OpenMetadataProperty.SUMMARY.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getSummary());
            properties.put(OpenMetadataProperty.DESCRIPTION.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getDescription());
            properties.put(OpenMetadataProperty.EXAMPLES.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getExamples());
            properties.put(OpenMetadataProperty.ABBREVIATION.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getUsage());
            properties.put(OpenMetadataProperty.USAGE.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getUsage());
            properties.put(OpenMetadataProperty.PUBLISH_VERSION_ID.name, openMetadataGlossaryTermElement.getGlossaryTermProperties().getPublishVersionIdentifier());
            if (openMetadataGlossaryTermElement.getGlossaryTermProperties().getExtendedProperties() != null) {
                for (String propertyName : openMetadataGlossaryTermElement.getGlossaryTermProperties().getExtendedProperties().keySet()) {
                    if (openMetadataGlossaryTermElement.getGlossaryTermProperties().getExtendedProperties().get(propertyName) != null) {
                        properties.put(propertyName, openMetadataGlossaryTermElement.getGlossaryTermProperties().getExtendedProperties().get(propertyName).toString());
                        continue;
                    }
                    properties.put(propertyName, null);
                }
            }
            glossaryTerm.setProperties(properties);
            return glossaryTerm;
        }
        return null;
    }

    private List<GlossaryCategory> convertGlossaryCategories(List<GlossaryCategoryElement> openMetadataGlossaryCategoryElements) {
        if (openMetadataGlossaryCategoryElements != null) {
            ArrayList<GlossaryCategory> results = new ArrayList<GlossaryCategory>();
            for (GlossaryCategoryElement openMetadataGlossaryCategoryElement : openMetadataGlossaryCategoryElements) {
                results.add(this.convertGlossaryCategory(openMetadataGlossaryCategoryElement));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private GlossaryCategory convertGlossaryCategory(GlossaryCategoryElement openMetadataGlossaryCategoryElement) {
        if (openMetadataGlossaryCategoryElement != null) {
            GlossaryCategory glossaryCategory = new GlossaryCategory();
            glossaryCategory.setGuid(openMetadataGlossaryCategoryElement.getElementHeader().getGUID());
            glossaryCategory.setTypeDefName(openMetadataGlossaryCategoryElement.getElementHeader().getType().getTypeName());
            glossaryCategory.setVersion(openMetadataGlossaryCategoryElement.getElementHeader().getVersions().getVersion());
            glossaryCategory.setCreatedBy(openMetadataGlossaryCategoryElement.getElementHeader().getVersions().getCreatedBy());
            glossaryCategory.setCreateTime(openMetadataGlossaryCategoryElement.getElementHeader().getVersions().getCreateTime());
            glossaryCategory.setUpdatedBy(openMetadataGlossaryCategoryElement.getElementHeader().getVersions().getUpdatedBy());
            glossaryCategory.setUpdateTime(openMetadataGlossaryCategoryElement.getElementHeader().getVersions().getUpdateTime());
            glossaryCategory.setStatus(openMetadataGlossaryCategoryElement.getElementHeader().getStatus().getName());
            glossaryCategory.setEffectiveFromTime(openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getEffectiveFrom());
            glossaryCategory.setEffectiveToTime(openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getEffectiveTo());
            glossaryCategory.setClassifications(this.convertClassifications(openMetadataGlossaryCategoryElement.getElementHeader().getClassifications()));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(OpenMetadataProperty.QUALIFIED_NAME.name, openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getQualifiedName());
            properties.put(OpenMetadataProperty.DISPLAY_NAME.name, openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getDisplayName());
            properties.put(OpenMetadataProperty.DESCRIPTION.name, openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getDescription());
            if (openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getExtendedProperties() != null) {
                for (String propertyName : openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getExtendedProperties().keySet()) {
                    if (openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getExtendedProperties().get(propertyName) != null) {
                        properties.put(propertyName, openMetadataGlossaryCategoryElement.getGlossaryCategoryProperties().getExtendedProperties().get(propertyName).toString());
                        continue;
                    }
                    properties.put(propertyName, null);
                }
            }
            glossaryCategory.setProperties(properties);
            return glossaryCategory;
        }
        return null;
    }

    private List<GlossaryViewClassification> convertClassifications(List<ElementClassification> openMetadataClassifications) {
        if (openMetadataClassifications != null) {
            ArrayList<GlossaryViewClassification> results = new ArrayList<GlossaryViewClassification>();
            for (ElementClassification openMetadataClassification : openMetadataClassifications) {
                GlossaryViewClassification glossaryViewClassification = new GlossaryViewClassification();
                glossaryViewClassification.setClassificationType(openMetadataClassification.getClassificationName());
                glossaryViewClassification.setName(openMetadataClassification.getClassificationName());
                glossaryViewClassification.setCreatedBy(openMetadataClassification.getVersions().getCreatedBy());
                glossaryViewClassification.setCreateTime(openMetadataClassification.getVersions().getCreateTime());
                glossaryViewClassification.setUpdatedBy(openMetadataClassification.getVersions().getUpdatedBy());
                glossaryViewClassification.setUpdateTime(openMetadataClassification.getVersions().getUpdateTime());
                glossaryViewClassification.setStatus(openMetadataClassification.getStatus().getName());
                if (openMetadataClassification.getClassificationProperties() == null) continue;
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String propertyName : openMetadataClassification.getClassificationProperties().keySet()) {
                    if (openMetadataClassification.getClassificationProperties().get(propertyName) != null) {
                        properties.put(propertyName, openMetadataClassification.getClassificationProperties().get(propertyName).toString());
                        continue;
                    }
                    properties.put(propertyName, null);
                }
                glossaryViewClassification.setProperties(properties);
            }
            return results;
        }
        return null;
    }

    private GlossaryViewEntityDetail convertOpenMetadataElement(OpenMetadataElement openMetadataElement) {
        if (openMetadataElement != null) {
            GlossaryViewEntityDetail glossaryViewEntityDetail = new GlossaryViewEntityDetail();
            glossaryViewEntityDetail.setGuid(openMetadataElement.getElementGUID());
            glossaryViewEntityDetail.setTypeDefName(openMetadataElement.getType().getTypeName());
            glossaryViewEntityDetail.setVersion(openMetadataElement.getVersions().getVersion());
            glossaryViewEntityDetail.setCreatedBy(openMetadataElement.getVersions().getCreatedBy());
            glossaryViewEntityDetail.setCreateTime(openMetadataElement.getVersions().getCreateTime());
            glossaryViewEntityDetail.setUpdatedBy(openMetadataElement.getVersions().getUpdatedBy());
            glossaryViewEntityDetail.setUpdateTime(openMetadataElement.getVersions().getUpdateTime());
            glossaryViewEntityDetail.setStatus(openMetadataElement.getStatus().getName());
            glossaryViewEntityDetail.setEffectiveFromTime(openMetadataElement.getEffectiveFromTime());
            glossaryViewEntityDetail.setEffectiveToTime(openMetadataElement.getEffectiveToTime());
            glossaryViewEntityDetail.setClassifications(this.convertAttachedClassifications(openMetadataElement.getClassifications()));
            HashMap<String, String> properties = new HashMap<String, String>();
            if (openMetadataElement.getElementProperties() != null) {
                for (String propertyName : openMetadataElement.getElementProperties().getPropertyValueMap().keySet()) {
                    if (openMetadataElement.getElementProperties().getPropertyValue(propertyName) != null) {
                        properties.put(propertyName, openMetadataElement.getElementProperties().getPropertyValue(propertyName).valueAsString());
                        continue;
                    }
                    properties.put(propertyName, null);
                }
            }
            glossaryViewEntityDetail.setProperties(properties);
            return glossaryViewEntityDetail;
        }
        return null;
    }

    private List<GlossaryViewClassification> convertAttachedClassifications(List<AttachedClassification> openMetadataClassifications) {
        if (openMetadataClassifications != null) {
            ArrayList<GlossaryViewClassification> results = new ArrayList<GlossaryViewClassification>();
            for (AttachedClassification openMetadataClassification : openMetadataClassifications) {
                GlossaryViewClassification glossaryViewClassification = new GlossaryViewClassification();
                glossaryViewClassification.setClassificationType(openMetadataClassification.getClassificationName());
                glossaryViewClassification.setName(openMetadataClassification.getClassificationName());
                glossaryViewClassification.setCreatedBy(openMetadataClassification.getVersions().getCreatedBy());
                glossaryViewClassification.setCreateTime(openMetadataClassification.getVersions().getCreateTime());
                glossaryViewClassification.setUpdatedBy(openMetadataClassification.getVersions().getUpdatedBy());
                glossaryViewClassification.setUpdateTime(openMetadataClassification.getVersions().getUpdateTime());
                glossaryViewClassification.setStatus(openMetadataClassification.getStatus().getName());
                if (openMetadataClassification.getClassificationProperties() == null) continue;
                glossaryViewClassification.setProperties(openMetadataClassification.getClassificationProperties().getPropertiesAsStrings());
            }
            return results;
        }
        return null;
    }
}

