/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarybrowser.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryCategoryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementsResponse;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermRelationshipRequestBody;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GovernanceDefinitionsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.RelatedMetadataElementSummariesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.FindByPropertiesRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryNameRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossarySearchStringRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarybrowser.rest.HistoryRequestBody;
import org.odpi.openmetadata.viewservices.glossarybrowser.server.GlossaryBrowserRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/glossary-browser"})
@Tag(name="API: Glossary Browser OMVS", description="Explore the contents of a glossary, such as its top-level glossary element, glossary categories and glossary terms, along with the elements that are linked to the terms, such assets.  Each operation includes optional forLineage and forDuplicateProcessing request parameters and an optional request body that includes an effective time field.  These affect the elements that are returned on the query.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/glossary-browser/overview/"))
public class GlossaryBrowserResource {
    private final GlossaryBrowserRESTServices restAPI = new GlossaryBrowserRESTServices();

    @GetMapping(path={"/glossaries/terms/status-list"})
    @Operation(summary="getGlossaryTermStatuses", description="Return the list of glossary term status enum values.  These values are used in a glossary workflow to describe the state of the content of the term.", externalDocs=@ExternalDocumentation(description="Controlled glossary terms", url="https://egeria-project.org/services/omvs/glossary-manager/overview/#controlled-glossary-terms"))
    public GlossaryTermStatusListResponse getGlossaryTermStatuses(@PathVariable String serverName) {
        return this.restAPI.getGlossaryTermStatuses(serverName);
    }

    @GetMapping(path={"/glossaries/terms/relationships/status-list"})
    @Operation(summary="getGlossaryTermRelationshipStatuses", description="Return the list of glossary term relationship status enum values.  These values are stored in a term-to-term, or term-to-category, relationship and are used to indicate how much the relationship should be trusted.", externalDocs=@ExternalDocumentation(description="Relationship statuses", url="https://egeria-project.org/services/omvs/glossary-manager/overview/#relationship-statuses"))
    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(@PathVariable String serverName) {
        return this.restAPI.getGlossaryTermRelationshipStatuses(serverName);
    }

    @GetMapping(path={"/glossaries/terms/activity-types"})
    @Operation(summary="getGlossaryTermActivityTypes", description="Return the list of glossary term activity type enum values.  These values are used in the ActivityDescription classification that is attached to a glossary term that represents some type of activity.", externalDocs=@ExternalDocumentation(description="Activity description", url="https://egeria-project.org/types/3/0340-Dictionary/#activitydescription"))
    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(@PathVariable String serverName) {
        return this.restAPI.getGlossaryTermActivityTypes(serverName);
    }

    @PostMapping(path={"/glossaries/by-search-string"})
    @Operation(summary="findGlossaries", description="Retrieve the list of glossary metadata elements that contain the search string.  The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementsResponse findGlossaries(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaries(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/by-name"})
    @Operation(summary="getGlossariesByName", description="Retrieve the list of glossary metadata elements with an exactly matching qualified or display name. There are no wildcards supported on this request.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementsResponse getGlossariesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getGlossariesByName(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/retrieve"})
    @Operation(summary="getGlossaryByGUID", description="Retrieve the glossary metadata element with the supplied unique identifier.  The optional request body allows you to specify that the glossary element should only be returned if it was effective at a particular time.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementResponse getGlossaryByGUID(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryByGUID(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/for-category/{glossaryCategoryGUID}/retrieve"})
    @Operation(summary="getGlossaryForCategory", description="Retrieve the glossary metadata element for the requested category.  The optional request body allows you to specify that the glossary element should only be returned if it was effective at a particular time.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementResponse getGlossaryForCategory(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryForCategory(serverName, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/for-term/{glossaryTermGUID}/retrieve"})
    @Operation(summary="getGlossaryForTerm", description="Retrieve the glossary metadata element for the requested term.  The optional request body allows you to specify that the glossary element should only be returned if it was effective at a particular time.", externalDocs=@ExternalDocumentation(description="Glossary metadata element", url="https://egeria-project.org/types/3/0310-Glossary/"))
    public GlossaryElementResponse getGlossaryForTerm(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryForTerm(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-search-string"})
    @Operation(summary="findGlossaryCategories", description="Retrieve the list of glossary category metadata elements that contain the search string.  The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of a glossaryGUID to restrict the search to within a single glossary.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse findGlossaryCategories(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossarySearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryCategories(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories/retrieve"})
    @Operation(summary="getCategoriesForGlossary", description="Return the list of categories associated with a glossary.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getCategoriesForGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCategoriesForGlossary(serverName, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/categories/retrieve"})
    @Operation(summary="getCategoriesForTerm", description="Return the list of categories associated with a term.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getCategoriesForTerm(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getCategoriesForTerm(serverName, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/by-name"})
    @Operation(summary="getGlossaryCategoriesByName", description="Retrieve the list of glossary category metadata elements that either have the requested qualified name or display name.  The name to search for is located in the request body and is interpreted as a plain string.  The request body also supports the specification of a glossaryGUID to restrict the search to within a single glossary.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getGlossaryCategoriesByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryNameRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoriesByName(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/retrieve"})
    @Operation(summary="getGlossaryCategoryByGUID", description="Retrieve the requested glossary category metadata element.  The optional request body contain an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementResponse getGlossaryCategoryByGUID(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryByGUID(serverName, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/parent/retrieve"})
    @Operation(summary="getGlossaryCategoryParent", description="Glossary categories can be organized in a hierarchy. Retrieve the parent glossary category metadata element for the glossary category with the supplied unique identifier.  If the requested category does not have a parent category, null is returned.  The optional request body contain an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementResponse getGlossaryCategoryParent(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryCategoryParent(serverName, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/subcategories/retrieve"})
    @Operation(summary="getGlossarySubCategories", description="Glossary categories can be organized in a hierarchy. Retrieve the subcategories for the glossary category metadata element with the supplied unique identifier.  If the requested category does not have any subcategories, null is returned.  The optional request body contain an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary category metadata element", url="https://egeria-project.org/types/3/0320-Category-Hierarchy/"))
    public GlossaryCategoryElementsResponse getGlossarySubCategories(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossarySubCategories(serverName, glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-search-string"})
    @Operation(summary="findGlossaryTerms", description="Retrieve the list of glossary term metadata elements that contain the search string.  The search string is located in the request body and is interpreted as a plain string.  The request parameters, startsWith, endsWith and ignoreCase can be used to allow a fuzzy search.  The request body also supports the specification of a glossaryGUID to restrict the search to within a single glossary.", externalDocs=@ExternalDocumentation(description="Glossary term metadata element", url="https://egeria-project.org/types/3/0330-Terms/"))
    public GlossaryTermElementsResponse findGlossaryTerms(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossarySearchStringRequestBody requestBody) {
        return this.restAPI.findGlossaryTerms(serverName, startFrom, pageSize, startsWith, endsWith, ignoreCase, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/retrieve"})
    @Operation(summary="getTermsForGlossary", description="Retrieve the list of glossary terms associated with a glossary.  The request body also supports the specification of an effective time for the query.", externalDocs=@ExternalDocumentation(description="Glossary term metadata element", url="https://egeria-project.org/types/3/0330-Terms/"))
    public GlossaryTermElementsResponse getTermsForGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getTermsForGlossary(serverName, glossaryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/retrieve"})
    public GlossaryTermElementsResponse getTermsForGlossaryCategory(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) GlossaryTermRelationshipRequestBody requestBody) {
        return this.restAPI.getTermsForGlossaryCategory(serverName, glossaryCategoryGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/related-terms"})
    public GlossaryTermElementsResponse getRelatedTerms(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) GlossaryTermRelationshipRequestBody requestBody) {
        return this.restAPI.getRelatedTerms(serverName, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/by-name"})
    public GlossaryTermElementsResponse getGlossaryTermsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryNameRequestBody requestBody) {
        return this.restAPI.getGlossaryTermsByName(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/retrieve"})
    public GlossaryTermElementResponse getGlossaryTermByGUID(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGlossaryTermByGUID(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/history"})
    public GlossaryTermElementsResponse getGlossaryTermHistory(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean oldestFirst, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) HistoryRequestBody requestBody) {
        return this.restAPI.getGlossaryTermHistory(serverName, glossaryTermGUID, startFrom, pageSize, oldestFirst, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-data-field"})
    public ElementStubsResponse getDataFieldClassifiedElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getDataFieldClassifiedElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-confidence"})
    public MetadataElementSummariesResponse getConfidenceClassifiedElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getConfidenceClassifiedElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-criticality"})
    public MetadataElementSummariesResponse getCriticalityClassifiedElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getCriticalityClassifiedElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-confidentiality"})
    public MetadataElementSummariesResponse getConfidentialityClassifiedElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getConfidentialityClassifiedElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-retention"})
    public MetadataElementSummariesResponse getRetentionClassifiedElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getRetentionClassifiedElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-security-tags"})
    public MetadataElementSummariesResponse getSecurityTaggedElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getSecurityTaggedElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-ownership"})
    public MetadataElementSummariesResponse getOwnersElements(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getOwnersElements(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/by-subject-area-membership"})
    public MetadataElementSummariesResponse getMembersOfSubjectArea(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) FindByPropertiesRequestBody requestBody) {
        return this.restAPI.getMembersOfSubjectArea(serverName, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/glossaries/terms/by-semantic-assignment/{elementGUID}"})
    public GlossaryTermElementsResponse getMeanings(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getMeanings(serverName, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(value={"/elements/by-semantic-assignment/{glossaryTermGUID}"})
    public RelatedMetadataElementSummariesResponse getSemanticAssignees(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSemanticAssignees(serverName, glossaryTermGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/governed-by/{governanceDefinitionGUID}"})
    public RelatedMetadataElementSummariesResponse getGovernedElements(@PathVariable String serverName, @PathVariable String governanceDefinitionGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGovernedElements(serverName, governanceDefinitionGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/governed-by"})
    public GovernanceDefinitionsResponse getGovernedByDefinitions(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getGovernedByDefinitions(serverName, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/sourced-from/{elementGUID}"})
    public RelatedMetadataElementSummariesResponse getSourceElements(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getSourceElements(serverName, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/elements/{elementGUID}/sourced-from"})
    public RelatedMetadataElementSummariesResponse getElementsSourceFrom(@PathVariable String serverName, @PathVariable String elementGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getElementsSourceFrom(serverName, elementGUID, startFrom, pageSize, forLineage, forDuplicateProcessing, requestBody);
    }
}

