/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Literal;
import org.odpi.openmetadata.archiveutilities.designmodels.base.DesignModelArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel.CanonicalGlossaryOwlParser;
import org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel.properties.GlossaryModel;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CanonicalGlossaryOwlModelArchiveBuilder
extends DesignModelArchiveBuilder {
    private static final String archiveDescription = "Archive produced using the Owl Canonical Glossary Model";
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private static final Logger log = LoggerFactory.getLogger(CanonicalGlossaryOwlModelArchiveBuilder.class);
    private GlossaryModel model;

    CanonicalGlossaryOwlModelArchiveBuilder(CanonicalGlossaryOwlParser parser) throws Exception {
        String methodName = "CanonicalGlossaryOwlModelArchiveBuilder";
        if (parser != null) {
            this.model = parser.getModel();
            if (this.model == null) {
                super.logBadArchiveContent("CanonicalGlossaryOwlModelArchiveBuilder");
                throw new Exception("no parser model supplied to the archive builder");
            }
        } else {
            super.logBadArchiveContent("CanonicalGlossaryOwlModelArchiveBuilder");
            throw new Exception("no parser supplied to the archive builder");
        }
        String archiveGUID = UUID.randomUUID().toString();
        String archiveName = this.model.getModelName();
        String archiveDescription = this.model.getModelDescription();
        OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
        String archiveRootName = this.model.getModelName();
        String originatorName = "...";
        String archiveLicense = this.model.getLicense();
        Date creationDate = new Date();
        this.initialize(archiveGUID, archiveName, archiveDescription, archiveType, archiveRootName, originatorName, archiveLicense, creationDate, 1L, versionName);
    }

    CanonicalGlossaryOwlModelArchiveBuilder(CanonicalGlossaryOwlParser parser, boolean writeToFile) throws Exception {
        this(parser);
        this.writeToFile = writeToFile;
    }

    /*
     * WARNING - void declaration
     */
    protected OpenMetadataArchive getOpenMetadataArchive() {
        Map<String, String> isDefinedByMap = this.model.getIsDefinedByMap();
        Map<String, Set<String>> conceptTermMemberMap = this.model.getConceptTermMemberMap();
        Map<String, Set<String>> propertyTermMemberMap = this.model.getPropertyTermMemberMap();
        Map<String, Set<String>> containmentMemberMap = this.model.getContainmentMemberMap();
        String glossaryId = super.addGlossary(this.model.getModelTechnicalName(), this.model.getModelName(), this.model.getModelDescription(), this.model.getModelLanguage(), archiveDescription, this.model.getModelLocation(), this.model.getModelScope());
        Map<String, Map<String, Literal>> categoryLiteralMap = this.model.getCategoryLiteralMap();
        for (String string : categoryLiteralMap.keySet()) {
            Map<String, Literal> map = categoryLiteralMap.get(string);
            if (this.model.getModelTechnicalName().equals(isDefinedByMap.get(string))) {
                super.addCategory(glossaryId, string, map.get("displayName").getString(), map.get("description").getString(), null);
                continue;
            }
            System.err.println("expected category " + string + " to be in the isDefined map for glossary " + this.model.getModelTechnicalName());
        }
        Map<String, Map<String, Literal>> conceptTermLiteralMap = this.model.getConceptTermLiteralMap();
        for (String string : conceptTermLiteralMap.keySet()) {
            Map<String, Literal> map = conceptTermLiteralMap.get(string);
            if (this.model.getModelTechnicalName().equals(isDefinedByMap.get(string))) {
                void var12_28;
                Set<String> set = conceptTermMemberMap.get(string);
                Object var12_29 = null;
                if (set != null && !set.isEmpty()) {
                    List list = set.stream().collect(Collectors.toList());
                }
                String termGuid = super.addTerm(glossaryId, (List)var12_28, string, map.get("displayName").getString(), map.get("description").getString(), null, true, false, true);
                log.debug("Adding concept term name=" + string + " guid=" + termGuid);
                continue;
            }
            System.err.println("expected concept term " + string + " to be in the isDefined map for glossary " + this.model.getModelTechnicalName());
        }
        Map<String, Map<String, Literal>> map = this.model.getObjectPropertyTermLiteralMap();
        for (String string : map.keySet()) {
            Map<String, Literal> map2 = map.get(string);
            if (this.model.getModelTechnicalName().equals(isDefinedByMap.get(string))) {
                Set<String> set = propertyTermMemberMap.get(string);
                List containerNamesList = null;
                if (set != null && !set.isEmpty()) {
                    containerNamesList = set.stream().collect(Collectors.toList());
                }
                String termGuid = super.addTerm(glossaryId, containerNamesList, string, map2.get("displayName").getString(), map2.get("description").getString(), null, false, true, true);
                log.debug("Adding property term name=" + string + " guid=" + termGuid);
                continue;
            }
            System.err.println("expected property term " + string + " to be in the isDefined map for glossary " + this.model.getModelTechnicalName());
        }
        Map<String, Map<String, Literal>> map3 = this.model.getDatatypePropertyTermLiteralMap();
        for (String string : map3.keySet()) {
            Map<String, Literal> map4 = map3.get(string);
            if (this.model.getModelTechnicalName().equals(isDefinedByMap.get(string))) {
                Set<String> containerNamesSet = propertyTermMemberMap.get(string);
                Object containerNamesList = null;
                if (containerNamesSet != null && !containerNamesSet.isEmpty()) {
                    containerNamesList = containerNamesSet.stream().collect(Collectors.toList());
                }
                String exampleValue = null;
                Set<String> examplesSet = this.model.getExampleMap().get(string);
                if (examplesSet != null && !examplesSet.isEmpty()) {
                    StringBuffer exampleValueSB = new StringBuffer();
                    for (String example : examplesSet) {
                        exampleValueSB.append(example);
                        exampleValueSB.append("\r\n");
                    }
                    exampleValue = exampleValueSB.toString();
                }
                String termGuid = super.addTerm(glossaryId, (List)containerNamesList, string, map4.get("displayName").getString(), map4.get("description").getString(), exampleValue, false, true, true);
                log.debug("Adding property term name=" + string + " guid=" + termGuid);
                continue;
            }
            System.err.println("expected property term " + string + " to be in the isDefined map for glossary " + this.model.getModelTechnicalName());
        }
        Map<String, Set<String>> map5 = this.model.getDomainsMap();
        for (String string : map5.keySet()) {
            Set<String> conceptSet = map5.get(string);
            for (String nameOfConcept : conceptSet) {
                log.debug("Adding HAS-A nameOfConcept=" + nameOfConcept + " propertyName=" + string);
                super.addHasARelationship(string, nameOfConcept);
            }
        }
        Map<String, Set<String>> map6 = this.model.getRangesMap();
        for (String nameOfProperty : map6.keySet()) {
            Set<String> conceptSet = map6.get(nameOfProperty);
            for (String nameOfConcept : conceptSet) {
                if (nameOfConcept.startsWith("http://www.w3.org")) continue;
                log.debug("Adding related nameOfConcept=" + nameOfConcept + " propertyName=" + nameOfProperty);
                super.addRelatedTermRelationship(nameOfProperty, nameOfConcept);
            }
        }
        Map<String, String> map7 = this.model.getResourceSubClassMap();
        for (String subclass : map7.keySet()) {
            super.addISARelationship(subclass, map7.get(subclass));
        }
        for (String containerName : containmentMemberMap.keySet()) {
            super.addCategoryHierarchy(containerName, containmentMemberMap.get(containerName));
        }
        return super.getOpenMetadataArchive();
    }
}

