/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel.properties.GlossaryModel;

class CanonicalGlossaryOwlParser {
    private static String JSONLD = "JSON-LD";
    Set<String> containerURIs = new HashSet<String>();
    Set<String> classURIs = new HashSet<String>();
    Set<String> ontologyURIs = new HashSet<String>();
    Set<String> objectPropertyURIs = new HashSet<String>();
    Set<String> dataPropertyURIs = new HashSet<String>();
    Map<String, Literal> labelMap = new HashMap<String, Literal>();
    Map<String, Literal> commentMap = new HashMap<String, Literal>();
    Map<String, Literal> licenseMap = new HashMap<String, Literal>();
    Map<String, Set<String>> memberMap = new HashMap<String, Set<String>>();
    private List<String> errorReport = new ArrayList<String>();
    private GlossaryModel glossaryModel = new GlossaryModel();

    CanonicalGlossaryOwlParser(String modelLocation) throws IOException {
        System.out.println("\nModel file Name: " + modelLocation);
        File modelContent = new File(modelLocation);
        if (modelContent.isDirectory()) {
            System.out.println("\nDo not support directories");
            System.exit(-1);
        } else {
            this.parseSingleFile(modelLocation);
            this.validate();
            this.populateModel();
            this.displaySummary();
        }
        if (!this.errorReport.isEmpty()) {
            System.out.println("Error Report");
            System.out.println(this.errorReport);
        }
    }

    private void validate() {
        Map<String, String> isDefinedByMap;
        if (this.ontologyURIs != null && this.ontologyURIs.size() != 1) {
            System.err.println("Please supply a file that contains 1 and only 1 owl:Ontology. Found " + this.ontologyURIs.size());
            System.exit(-1);
        }
        if ((isDefinedByMap = this.glossaryModel.getIsDefinedByMap()) != null) {
            int glossaryContentCount = 0;
            if (this.classURIs != null) {
                glossaryContentCount = this.classURIs.size();
            }
            if (this.objectPropertyURIs != null) {
                glossaryContentCount += this.objectPropertyURIs.size();
            }
            if (this.dataPropertyURIs != null) {
                glossaryContentCount += this.dataPropertyURIs.size();
            }
            if (this.containerURIs != null) {
                glossaryContentCount += this.containerURIs.size();
            }
            if (glossaryContentCount != isDefinedByMap.keySet().size()) {
                System.err.println("Expecting the number of relationships (" + isDefinedByMap.keySet().size() + ")  and glossary elements (" + glossaryContentCount + ") to be equal.");
                System.exit(-1);
            }
        }
    }

    private void parseSingleFile(String fileName) throws IOException {
        System.out.println("\nRetrieving model contents from: " + fileName);
        Model m = ModelFactory.createDefaultModel();
        FileReader fileReader = new FileReader(fileName);
        Model model = m.read((Reader)fileReader, null, JSONLD);
        StmtIterator it = model.listStatements();
        while (it.hasNext()) {
            String predicate;
            Statement statement = (Statement)it.next();
            Resource s = statement.getSubject();
            Property p = statement.getPredicate();
            RDFNode o = statement.getObject();
            String subjectURI = s.getURI();
            block15 : switch (predicate = p.getLocalName()) {
                case "type": {
                    if (o.isURIResource()) {
                        String object;
                        switch (object = o.toString()) {
                            case "http://www.w3.org/2002/07/owl#Ontology": {
                                this.ontologyURIs.add(subjectURI);
                                break block15;
                            }
                            case "http://www.w3.org/2002/07/owl#Class": {
                                this.classURIs.add(subjectURI);
                                break block15;
                            }
                            case "http://www.w3.org/2000/01/rdf-schema#Container": {
                                this.containerURIs.add(subjectURI);
                                break block15;
                            }
                            case "http://www.w3.org/2002/07/owl#ObjectProperty": {
                                this.objectPropertyURIs.add(subjectURI);
                                break block15;
                            }
                            case "http://www.w3.org/2002/07/owl#DatatypeProperty": {
                                this.dataPropertyURIs.add(subjectURI);
                            }
                        }
                        break;
                    }
                    if (o.isResource()) {
                        System.out.println("Not expecting a non uri resource subject:" + subjectURI + ",object: " + o.asResource());
                        break;
                    }
                    if (!o.isLiteral()) break;
                    System.out.println("Not expecting type literal");
                    break;
                }
                case "member": {
                    Set<String> containerURIs = this.glossaryModel.getConceptTermMemberMap().get(subjectURI);
                    if (containerURIs == null) {
                        containerURIs = new HashSet<String>();
                    }
                    containerURIs.add(o.asResource().getURI());
                    this.memberMap.put(subjectURI, containerURIs);
                    break;
                }
                case "example": {
                    Map<String, Set<String>> examplesMap = this.glossaryModel.getExampleMap();
                    Set<String> examples = examplesMap.get(subjectURI);
                    if (examples == null) {
                        examples = new HashSet<String>();
                    }
                    examples.add((String)o.asLiteral().getValue());
                    examplesMap.put(subjectURI, examples);
                    this.glossaryModel.setExampleMap(examplesMap);
                    break;
                }
                case "subClassOf": {
                    if (o.isResource()) {
                        this.glossaryModel.getResourceSubClassMap().put(subjectURI, o.asResource().getURI());
                        break;
                    }
                    if (!o.isLiteral()) break;
                    this.glossaryModel.getLiteralSubClassMap().put(subjectURI, o.asLiteral().getValue().toString());
                    break;
                }
                case "domain": {
                    Map<String, Set<String>> domainsMap = this.glossaryModel.getDomainsMap();
                    Set<String> domains = domainsMap.get(subjectURI);
                    boolean createDomainsMap = false;
                    if (domains == null) {
                        domains = new HashSet<String>();
                        createDomainsMap = true;
                    }
                    if (!o.isResource()) break;
                    domains.add(o.asResource().getURI());
                    domainsMap.put(subjectURI, domains);
                    if (!createDomainsMap) break;
                    this.glossaryModel.setDomainsMap(domainsMap);
                    break;
                }
                case "range": {
                    Map<String, Set<String>> rangesMap = this.glossaryModel.getRangesMap();
                    Set<String> ranges = rangesMap.get(subjectURI);
                    boolean createRangesMap = false;
                    if (ranges == null) {
                        ranges = new HashSet<String>();
                        createRangesMap = true;
                    }
                    if (!o.isResource()) break;
                    ranges.add(o.asResource().getURI());
                    rangesMap.put(subjectURI, ranges);
                    if (!createRangesMap) break;
                    this.glossaryModel.setRangesMap(rangesMap);
                    break;
                }
                case "label": {
                    this.labelMap.put(subjectURI, o.asLiteral());
                    break;
                }
                case "comment": {
                    this.commentMap.put(subjectURI, o.asLiteral());
                    break;
                }
                case "isDefinedBy": {
                    this.glossaryModel.getIsDefinedByMap().put(subjectURI, o.asResource().getURI());
                    break;
                }
                case "license": {
                    this.licenseMap.put(subjectURI, o.asLiteral());
                    break;
                }
            }
        }
    }

    private void displaySummary() {
        System.out.println("Found " + this.glossaryModel.getGlossaryLiteralMap().keySet().size() + " glossaries");
        System.out.println("Found " + this.glossaryModel.getCategoryLiteralMap().keySet().size() + " categories");
        System.out.println("Found " + this.glossaryModel.getConceptTermLiteralMap().keySet().size() + " concept terms");
        System.out.println("Found " + this.glossaryModel.getObjectPropertyTermLiteralMap().keySet().size() + "object property terms");
        Map<String, Set<String>> memberMap = this.glossaryModel.getConceptTermMemberMap();
        Map<String, String> resourceSubClassMap = this.glossaryModel.getResourceSubClassMap();
        Map<String, String> literalSubClassMap = this.glossaryModel.getLiteralSubClassMap();
        Map<String, Set<String>> rangesMap = this.glossaryModel.getRangesMap();
        Map<String, Set<String>> domainsMap = this.glossaryModel.getDomainsMap();
        Map<String, String> isDefinedByMap = this.glossaryModel.getIsDefinedByMap();
        if (resourceSubClassMap != null) {
            System.out.println("No resourceSubClassMap");
        } else {
            System.out.println("Found " + resourceSubClassMap.keySet().size() + " resourceSubclasses");
        }
        if (literalSubClassMap == null) {
            System.out.println("No literalSubClassMap");
        } else {
            System.out.println("Found " + literalSubClassMap.keySet().size() + " literalSubClassMap");
        }
        if (rangesMap == null) {
            System.out.println("No ranges");
        } else {
            System.out.println("Found " + rangesMap.keySet().size() + " rangesMap");
        }
        if (domainsMap == null) {
            System.out.println("No domains");
        } else {
            System.out.println("Found " + domainsMap.keySet().size() + " domainsMap");
        }
        if (isDefinedByMap == null) {
            System.out.println("No is defined by");
        } else {
            System.out.println("Found " + isDefinedByMap.keySet().size() + " is defined by Map");
        }
        if (memberMap == null) {
            System.out.println("No members");
        } else {
            System.out.println("Found " + memberMap.keySet().size() + " members Map");
        }
    }

    private void populateModel() {
        String ontologyURI = this.ontologyURIs.iterator().next();
        this.glossaryModel.setModelTechnicalName(ontologyURI);
        this.glossaryModel.setModelLanguage("us_en");
        this.glossaryModel.setModelScope("Owl Canonical Vocabulary");
        this.processLabels();
        this.processComments();
        this.processLicense();
        this.processMembers();
        this.glossaryModel.setModelLanguage("us_en");
        Literal glossaryDisplayNameLiteral = this.glossaryModel.getGlossaryLiteralMap().get(ontologyURI).get("displayName");
        this.glossaryModel.setModelName((String)glossaryDisplayNameLiteral.getValue());
        Literal glossaryDescriptionLiteral = this.glossaryModel.getGlossaryLiteralMap().get(ontologyURI).get("description");
        this.glossaryModel.setModelDescription((String)glossaryDescriptionLiteral.getValue());
        Literal glossaryLicenseLiteral = this.glossaryModel.getGlossaryLiteralMap().get(ontologyURI).get("license");
        this.glossaryModel.setLicense((String)glossaryLicenseLiteral.getValue());
    }

    private void processMembers() {
        for (String member : this.memberMap.keySet()) {
            if (this.containerURIs.contains(member)) {
                this.glossaryModel.getContainmentMemberMap().put(member, this.memberMap.get(member));
            }
            if (this.classURIs.contains(member)) {
                this.glossaryModel.getConceptTermMemberMap().put(member, this.memberMap.get(member));
            }
            if (!this.objectPropertyURIs.contains(member)) continue;
            this.glossaryModel.getPropertyTermMemberMap().put(member, this.memberMap.get(member));
        }
    }

    private void processLicense() {
        for (String subject : this.licenseMap.keySet()) {
            if (!this.ontologyURIs.contains(subject)) continue;
            Map<String, Map<String, Literal>> glossaryLiteralMap = this.glossaryModel.getGlossaryLiteralMap();
            Map<String, Literal> literalMap = glossaryLiteralMap.get(subject);
            literalMap = this.setLicense(subject, literalMap);
            glossaryLiteralMap.put(subject, literalMap);
        }
    }

    private void processComments() {
        for (String subject : this.commentMap.keySet()) {
            Map<String, Map<String, Literal>> termLiteralMap;
            Map<String, Literal> literalMap;
            if (this.ontologyURIs.contains(subject)) {
                Map<String, Map<String, Literal>> glossaryLiteralMap = this.glossaryModel.getGlossaryLiteralMap();
                literalMap = glossaryLiteralMap.get(subject);
                literalMap = this.setDescription(subject, literalMap);
                glossaryLiteralMap.put(subject, literalMap);
            }
            if (this.containerURIs.contains(subject)) {
                Map<String, Map<String, Literal>> categoryLiteralMap = this.glossaryModel.getCategoryLiteralMap();
                literalMap = categoryLiteralMap.get(subject);
                literalMap = this.setDescription(subject, literalMap);
                categoryLiteralMap.put(subject, literalMap);
            }
            if (this.classURIs.contains(subject)) {
                termLiteralMap = this.glossaryModel.getConceptTermLiteralMap();
                literalMap = termLiteralMap.get(subject);
                literalMap = this.setDescription(subject, literalMap);
                termLiteralMap.put(subject, literalMap);
            }
            if (this.objectPropertyURIs.contains(subject)) {
                termLiteralMap = this.glossaryModel.getObjectPropertyTermLiteralMap();
                literalMap = termLiteralMap.get(subject);
                literalMap = this.setDescription(subject, literalMap);
                termLiteralMap.put(subject, literalMap);
            }
            if (!this.dataPropertyURIs.contains(subject)) continue;
            termLiteralMap = this.glossaryModel.getDatatypePropertyTermLiteralMap();
            literalMap = termLiteralMap.get(subject);
            literalMap = this.setDescription(subject, literalMap);
            termLiteralMap.put(subject, literalMap);
        }
    }

    private void processLabels() {
        for (String subject : this.labelMap.keySet()) {
            Map<String, Map<String, Literal>> termLiteralMap;
            Map<String, Literal> literalMap;
            if (this.ontologyURIs.contains(subject)) {
                Map<String, Map<String, Literal>> glossaryLiteralMap = this.glossaryModel.getGlossaryLiteralMap();
                literalMap = glossaryLiteralMap.get(subject);
                literalMap = this.setDisplayName(subject, literalMap);
                glossaryLiteralMap.put(subject, literalMap);
            }
            if (this.containerURIs.contains(subject)) {
                Map<String, Map<String, Literal>> categoryLiteralMap = this.glossaryModel.getCategoryLiteralMap();
                literalMap = categoryLiteralMap.get(subject);
                literalMap = this.setDisplayName(subject, literalMap);
                categoryLiteralMap.put(subject, literalMap);
            }
            if (this.classURIs.contains(subject)) {
                termLiteralMap = this.glossaryModel.getConceptTermLiteralMap();
                literalMap = termLiteralMap.get(subject);
                literalMap = this.setDisplayName(subject, literalMap);
                termLiteralMap.put(subject, literalMap);
            }
            if (this.objectPropertyURIs.contains(subject)) {
                termLiteralMap = this.glossaryModel.getObjectPropertyTermLiteralMap();
                literalMap = termLiteralMap.get(subject);
                literalMap = this.setDisplayName(subject, literalMap);
                termLiteralMap.put(subject, literalMap);
            }
            if (!this.dataPropertyURIs.contains(subject)) continue;
            termLiteralMap = this.glossaryModel.getDatatypePropertyTermLiteralMap();
            literalMap = termLiteralMap.get(subject);
            literalMap = this.setDisplayName(subject, literalMap);
            termLiteralMap.put(subject, literalMap);
        }
    }

    private Map<String, Literal> setDisplayName(String subject, Map<String, Literal> literalMap) {
        if (literalMap == null) {
            literalMap = new HashMap<String, Literal>();
        }
        Literal literal = this.labelMap.get(subject);
        literalMap.put("displayName", literal);
        return literalMap;
    }

    private Map<String, Literal> setDescription(String subject, Map<String, Literal> literalMap) {
        if (literalMap == null) {
            literalMap = new HashMap<String, Literal>();
        }
        Literal literal = this.commentMap.get(subject);
        literalMap.put("description", literal);
        return literalMap;
    }

    private Map<String, Literal> setLicense(String subject, Map<String, Literal> literalMap) {
        if (literalMap == null) {
            literalMap = new HashMap<String, Literal>();
        }
        Literal literal = this.licenseMap.get(subject);
        literalMap.put("license", literal);
        return literalMap;
    }

    public GlossaryModel getModel() {
        this.glossaryModel.setErrorReport(this.errorReport);
        return this.glossaryModel;
    }
}

