/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel;

import org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel.CanonicalGlossaryOwlModelArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.designmodels.owlcanonicalglossarymodel.CanonicalGlossaryOwlParser;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;

public class CanonicalGlossaryOwlArchiveWriter
extends OMRSArchiveWriter {
    private final String openMetadataArchiveFileName;
    private final String modelLocation;

    CanonicalGlossaryOwlArchiveWriter(String modelLocation) {
        this.modelLocation = modelLocation;
        this.openMetadataArchiveFileName = modelLocation.substring(0, modelLocation.length() - 5) + "Archive.omarchive";
    }

    void writeOpenMetadataArchive() {
        try {
            CanonicalGlossaryOwlParser modelParser = new CanonicalGlossaryOwlParser(this.modelLocation);
            CanonicalGlossaryOwlModelArchiveBuilder modelArchiveBuilder = new CanonicalGlossaryOwlModelArchiveBuilder(modelParser);
            super.writeOpenMetadataArchive(this.openMetadataArchiveFileName, modelArchiveBuilder.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("USAGE: filename");
            System.exit(-1);
        }
        if (!args[0].endsWith(".json")) {
            System.err.println("Supplied filename must have a json extension");
            System.exit(-1);
        }
        try {
            CanonicalGlossaryOwlArchiveWriter archiveWriter = new CanonicalGlossaryOwlArchiveWriter(args[0]);
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

