/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarymanager.server;

import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.CollaborationExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.StewardshipExchangeClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;

public class GlossaryManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.GLOSSARY_MANAGER;
    private final CollaborationExchangeClient collaborationExchangeClient;
    private final GlossaryExchangeClient glossaryExchangeClient;
    private final StewardshipExchangeClient stewardshipExchangeClient;

    public GlossaryManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.collaborationExchangeClient = new CollaborationExchangeClient(remoteServerName, remoteServerURL, auditLog, maxPageSize);
        this.glossaryExchangeClient = new GlossaryExchangeClient(remoteServerName, remoteServerURL, auditLog, maxPageSize);
        this.stewardshipExchangeClient = new StewardshipExchangeClient(remoteServerName, remoteServerURL, auditLog, maxPageSize);
    }

    public CollaborationExchangeClient getCollaborationExchangeClient() {
        return this.collaborationExchangeClient;
    }

    public GlossaryExchangeClient getGlossaryExchangeClient() {
        return this.glossaryExchangeClient;
    }

    public StewardshipExchangeClient getStewardshipExchangeClient() {
        return this.stewardshipExchangeClient;
    }
}

