/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarymanager.server;

import java.util.Arrays;
import java.util.Date;
import org.odpi.openmetadata.accessservices.assetmanager.client.exchange.GlossaryExchangeClient;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ClassificationProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.ActivityDescriptionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.CanonicalVocabularyProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.EditingGlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryCategoryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermCategorization;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermContextDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.StagingGlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.TaxonomyProperties;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ArchiveRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.server.GlossaryManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class GlossaryManagerRESTServices
extends TokenController {
    private static final GlossaryManagerInstanceHandler instanceHandler = new GlossaryManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GlossaryManagerRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse createGlossary(String serverName, ReferenceableRequestBody requestBody) {
        String methodName = "createGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGlossary");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossary");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryProperties) {
                    GlossaryProperties glossaryProperties = (GlossaryProperties)referenceableProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "createGlossary");
                    response.setGUID(handler.createGlossary(userId, null, null, false, null, glossaryProperties));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryProperties.class.getName(), "createGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossary", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryFromTemplate(String serverName, String templateGUID, boolean deepCopy, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGlossaryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGlossaryFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "createGlossaryFromTemplate");
                response.setGUID(handler.createGlossaryFromTemplate(userId, null, null, false, templateGUID, null, deepCopy, requestBody.getElementProperties()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createGlossaryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossary(String serverName, String glossaryGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossary");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryProperties) {
                    GlossaryProperties glossaryProperties = (GlossaryProperties)referenceableProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "updateGlossary");
                    handler.updateGlossary(userId, null, null, glossaryGUID, null, isMergeUpdate, glossaryProperties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryProperties.class.getName(), "updateGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossary", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossary(String serverName, String glossaryGUID, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossary");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "removeGlossary");
            if (requestBody != null) {
                handler.removeGlossary(userId, null, null, glossaryGUID, null, cascadedDelete, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeGlossary(userId, null, null, glossaryGUID, null, cascadedDelete, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsEditingGlossary(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsEditingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setGlossaryAsEditingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setGlossaryAsEditingGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsEditingGlossary");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof EditingGlossaryProperties) {
                    EditingGlossaryProperties properties = (EditingGlossaryProperties)classificationProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setGlossaryAsEditingGlossary");
                    handler.setGlossaryAsEditingGlossary(userId, null, null, glossaryGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(EditingGlossaryProperties.class.getName(), "setGlossaryAsEditingGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsEditingGlossary", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setGlossaryAsEditingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsEditingGlossary(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsEditingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearGlossaryAsEditingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearGlossaryAsEditingGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsEditingGlossary");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearGlossaryAsEditingGlossary");
            if (requestBody != null) {
                handler.clearGlossaryAsEditingGlossary(userId, null, null, glossaryGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsEditingGlossary(userId, null, null, glossaryGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearGlossaryAsEditingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsStagingGlossary(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsStagingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setGlossaryAsStagingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setGlossaryAsStagingGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsStagingGlossary");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof StagingGlossaryProperties) {
                    StagingGlossaryProperties properties = (StagingGlossaryProperties)classificationProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setGlossaryAsStagingGlossary");
                    handler.setGlossaryAsStagingGlossary(userId, null, null, glossaryGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(StagingGlossaryProperties.class.getName(), "setGlossaryAsStagingGlossary");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsStagingGlossary", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setGlossaryAsStagingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsStagingGlossary(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsStagingGlossary";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearGlossaryAsStagingGlossary");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearGlossaryAsStagingGlossary");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsStagingGlossary");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearGlossaryAsStagingGlossary");
            if (requestBody != null) {
                handler.clearGlossaryAsStagingGlossary(userId, null, null, glossaryGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsStagingGlossary(userId, null, null, glossaryGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearGlossaryAsStagingGlossary", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsTaxonomy(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setGlossaryAsTaxonomy");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsTaxonomy");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof TaxonomyProperties) {
                    TaxonomyProperties properties = (TaxonomyProperties)classificationProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setGlossaryAsTaxonomy");
                    handler.setGlossaryAsTaxonomy(userId, null, null, glossaryGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(TaxonomyProperties.class.getName(), "setGlossaryAsTaxonomy");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsTaxonomy", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsTaxonomy(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsTaxonomy";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearGlossaryAsTaxonomy");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearGlossaryAsTaxonomy");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsTaxonomy");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearGlossaryAsTaxonomy");
            if (requestBody != null) {
                handler.clearGlossaryAsTaxonomy(userId, null, null, glossaryGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsTaxonomy(userId, null, null, glossaryGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearGlossaryAsTaxonomy", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setGlossaryAsCanonical(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setGlossaryAsCanonical");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setGlossaryAsCanonical");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof CanonicalVocabularyProperties) {
                    CanonicalVocabularyProperties properties = (CanonicalVocabularyProperties)classificationProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setGlossaryAsCanonical");
                    handler.setGlossaryAsCanonical(userId, null, null, glossaryGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(CanonicalVocabularyProperties.class.getName(), "setGlossaryAsCanonical");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setGlossaryAsCanonical", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearGlossaryAsCanonical(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearGlossaryAsCanonical";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearGlossaryAsCanonical");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearGlossaryAsCanonical");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearGlossaryAsCanonical");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearGlossaryAsCanonical");
            if (requestBody != null) {
                handler.clearGlossaryAsCanonical(userId, null, null, glossaryGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearGlossaryAsCanonical(userId, null, null, glossaryGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearGlossaryAsCanonical", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategory(String serverName, String glossaryGUID, boolean isRootCategory, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "createGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGlossaryCategory");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGlossaryCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategory");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryCategoryProperties) {
                    GlossaryCategoryProperties properties = (GlossaryCategoryProperties)referenceableProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "createGlossaryCategory");
                    response.setGUID(handler.createGlossaryCategory(userId, null, null, false, glossaryGUID, null, properties, isRootCategory, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryCategoryProperties.class.getName(), "createGlossaryCategory");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategory", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryCategoryFromTemplate(String serverName, String glossaryGUID, String templateGUID, TemplateRequestBody requestBody) {
        String methodName = "createGlossaryCategoryFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGlossaryCategoryFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGlossaryCategoryFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryCategoryFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "createGlossaryCategoryFromTemplate");
                response.setGUID(handler.createGlossaryCategoryFromTemplate(userId, null, null, false, glossaryGUID, templateGUID, null, true, requestBody.getElementProperties()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryCategoryFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createGlossaryCategoryFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryCategory(String serverName, String glossaryCategoryGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGlossaryCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryCategory");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryCategoryProperties) {
                    GlossaryCategoryProperties properties = (GlossaryCategoryProperties)referenceableProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "updateGlossaryCategory");
                    handler.updateGlossaryCategory(userId, null, null, glossaryCategoryGUID, null, isMergeUpdate, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryCategoryProperties.class.getName(), "updateGlossaryCategory");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryCategory", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupCategoryParent(String serverName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupCategoryParent");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupCategoryParent");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setupCategoryParent");
            if (requestBody != null) {
                if (requestBody.getProperties() != null) {
                    handler.setupCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    handler.setupCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                }
            } else {
                handler.setupCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearCategoryParent(String serverName, String glossaryParentCategoryGUID, String glossaryChildCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearCategoryParent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearCategoryParent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearCategoryParent");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearCategoryParent");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearCategoryParent");
            if (requestBody != null) {
                handler.clearCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearCategoryParent(userId, null, null, glossaryParentCategoryGUID, glossaryChildCategoryGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearCategoryParent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryCategory(String serverName, String glossaryCategoryGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossaryCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGlossaryCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGlossaryCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryCategory");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "removeGlossaryCategory");
            if (requestBody != null) {
                handler.removeGlossaryCategory(userId, null, null, glossaryCategoryGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeGlossaryCategory(userId, null, null, glossaryCategoryGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeGlossaryCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermStatusListResponse getGlossaryTermStatuses(String serverName) {
        String methodName = "getGlossaryTermStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermStatuses");
        GlossaryTermStatusListResponse response = new GlossaryTermStatusListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermStatuses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermStatus.values()));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(String serverName) {
        String methodName = "getGlossaryTermRelationshipStatuses";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermRelationshipStatuses");
        GlossaryTermRelationshipStatusListResponse response = new GlossaryTermRelationshipStatusListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermRelationshipStatuses");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermRelationshipStatuses");
            response.setStatuses(Arrays.asList(GlossaryTermRelationshipStatus.values()));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermRelationshipStatuses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(String serverName) {
        String methodName = "getGlossaryTermActivityTypes";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getGlossaryTermActivityTypes");
        GlossaryTermActivityTypeListResponse response = new GlossaryTermActivityTypeListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getGlossaryTermActivityTypes");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getGlossaryTermActivityTypes");
            response.setTypes(Arrays.asList(GlossaryTermActivityType.values()));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getGlossaryTermActivityTypes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createControlledGlossaryTerm(String serverName, String glossaryGUID, boolean forLineage, boolean forDuplicateProcessing, ControlledGlossaryTermRequestBody requestBody) {
        String methodName = "createControlledGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createControlledGlossaryTerm");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createControlledGlossaryTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createControlledGlossaryTerm");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "createControlledGlossaryTerm");
                response.setGUID(handler.createControlledGlossaryTerm(userId, null, null, false, glossaryGUID, null, requestBody.getElementProperties(), requestBody.getInitialStatus(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createControlledGlossaryTerm", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createControlledGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createGlossaryTermFromTemplate(String serverName, String glossaryGUID, String templateGUID, boolean deepCopy, boolean templateSubstitute, GlossaryTemplateRequestBody requestBody) {
        String methodName = "createGlossaryTermFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "createGlossaryTermFromTemplate");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "createGlossaryTermFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createGlossaryTermFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "createGlossaryTermFromTemplate");
                response.setGUID(handler.createGlossaryTermFromTemplate(userId, null, null, false, glossaryGUID, templateGUID, null, deepCopy, templateSubstitute, requestBody.getGlossaryTermStatus(), requestBody.getElementProperties()));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "createGlossaryTermFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "createGlossaryTermFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTerm(String serverName, String glossaryTermGUID, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGlossaryTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTerm");
            if (requestBody != null) {
                ReferenceableProperties referenceableProperties = requestBody.getElementProperties();
                if (referenceableProperties instanceof GlossaryTermProperties) {
                    GlossaryTermProperties properties = (GlossaryTermProperties)referenceableProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "updateGlossaryTerm");
                    handler.updateGlossaryTerm(userId, null, null, glossaryTermGUID, null, isMergeUpdate, properties, requestBody.getUpdateDescription(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermProperties.class.getName(), "updateGlossaryTerm");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTerm", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTermStatus(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, GlossaryTermStatusRequestBody requestBody) {
        String methodName = "updateGlossaryTermStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGlossaryTermStatus");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGlossaryTermStatus");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTermStatus");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "updateGlossaryTermStatus");
                handler.updateGlossaryTermStatus(userId, null, null, glossaryTermGUID, null, requestBody.getGlossaryTermStatus(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTermStatus", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateGlossaryTermStatus", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateGlossaryTermFromTemplate(String serverName, String glossaryTermGUID, boolean isMergeClassifications, boolean isMergeProperties, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "updateGlossaryTermFromTemplate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateGlossaryTermFromTemplate");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateGlossaryTermFromTemplate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateGlossaryTermFromTemplate");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "updateGlossaryTermFromTemplate");
                handler.updateGlossaryTermFromTemplate(userId, null, null, glossaryTermGUID, requestBody.getParentGUID(), null, requestBody.getUpdateDescription(), isMergeClassifications, isMergeProperties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateGlossaryTermFromTemplate", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateGlossaryTermFromTemplate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse moveGlossaryTerm(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "moveGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "moveGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "moveGlossaryTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "moveGlossaryTerm");
            if (requestBody != null) {
                GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "moveGlossaryTerm");
                handler.moveGlossaryTerm(userId, null, null, glossaryTermGUID, null, requestBody.getParentGUID(), requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "moveGlossaryTerm", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "moveGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermCategory(String serverName, String glossaryCategoryGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupTermCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermCategory");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermCategorization) {
                    GlossaryTermCategorization properties = (GlossaryTermCategorization)relationshipProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setupTermCategory");
                    handler.setupTermCategory(userId, null, null, glossaryCategoryGUID, glossaryTermGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermCategorization.class.getName(), "setupTermCategory");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupTermCategory", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermCategory(String serverName, String glossaryCategoryGUID, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearTermCategory";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermCategory");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermCategory");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermCategory");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermCategory");
            if (requestBody != null) {
                handler.clearTermCategory(userId, null, null, glossaryCategoryGUID, glossaryTermGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermCategory(userId, null, null, glossaryCategoryGUID, glossaryTermGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermCategory", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NameListResponse getTermRelationshipTypeNames(String serverName) {
        String methodName = "getTermRelationshipTypeNames";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getTermRelationshipTypeNames");
        NameListResponse response = new NameListResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getTermRelationshipTypeNames");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTermRelationshipTypeNames");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "getTermRelationshipTypeNames");
            response.setNames(handler.getTermRelationshipTypeNames(userId));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getTermRelationshipTypeNames", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setupTermRelationship(String serverName, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "setupTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setupTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setupTermRelationship");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setupTermRelationship");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermRelationship) {
                    GlossaryTermRelationship properties = (GlossaryTermRelationship)relationshipProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setupTermRelationship");
                    handler.setupTermRelationship(userId, null, null, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermRelationship.class.getName(), "setupTermRelationship");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setupTermRelationship", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setupTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateTermRelationship(String serverName, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, RelationshipRequestBody requestBody) {
        String methodName = "updateTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateTermRelationship");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateTermRelationship");
            if (requestBody != null) {
                RelationshipProperties relationshipProperties = requestBody.getProperties();
                if (relationshipProperties instanceof GlossaryTermRelationship) {
                    GlossaryTermRelationship properties = (GlossaryTermRelationship)relationshipProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "updateTermRelationship");
                    handler.updateTermRelationship(userId, null, null, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermRelationship.class.getName(), "updateTermRelationship");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "updateTermRelationship", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermRelationship(String serverName, String glossaryTermOneGUID, String relationshipTypeName, String glossaryTermTwoGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "clearTermRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermRelationship");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermRelationship");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermRelationship");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermRelationship");
            if (requestBody != null) {
                handler.clearTermRelationship(userId, null, null, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermRelationship(userId, null, null, relationshipTypeName, glossaryTermOneGUID, glossaryTermTwoGUID, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermRelationship", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsAbstractConcept(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setTermAsAbstractConcept");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsAbstractConcept");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setTermAsAbstractConcept");
            if (requestBody != null) {
                handler.setTermAsAbstractConcept(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsAbstractConcept(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsAbstractConcept(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsAbstractConcept";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermAsAbstractConcept");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermAsAbstractConcept");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsAbstractConcept");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermAsAbstractConcept");
            if (requestBody != null) {
                handler.clearTermAsAbstractConcept(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsAbstractConcept(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermAsAbstractConcept", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsDataValue(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setTermAsDataValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsDataValue");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setTermAsDataValue");
            if (requestBody != null) {
                handler.setTermAsDataValue(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsDataValue(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsDataValue(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsDataValue";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermAsDataValue");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermAsDataValue");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsDataValue");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermAsDataValue");
            if (requestBody != null) {
                handler.clearTermAsDataValue(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsDataValue(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermAsDataValue", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsActivity(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setTermAsActivity");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsActivity");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof ActivityDescriptionProperties) {
                    ActivityDescriptionProperties properties = (ActivityDescriptionProperties)classificationProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setTermAsActivity");
                    handler.setTermAsActivity(userId, null, null, glossaryTermGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(ActivityDescriptionProperties.class.getName(), "setTermAsActivity");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setTermAsActivity", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsActivity(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsActivity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermAsActivity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermAsActivity");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsActivity");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermAsActivity");
            if (requestBody != null) {
                handler.clearTermAsActivity(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsActivity(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermAsActivity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsContext(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setTermAsContext");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsContext");
            if (requestBody != null) {
                ClassificationProperties classificationProperties = requestBody.getProperties();
                if (classificationProperties instanceof GlossaryTermContextDefinition) {
                    GlossaryTermContextDefinition properties = (GlossaryTermContextDefinition)classificationProperties;
                    GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setTermAsContext");
                    handler.setTermAsContext(userId, null, null, glossaryTermGUID, null, properties, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
                } else {
                    restExceptionHandler.handleInvalidPropertiesObject(GlossaryTermContextDefinition.class.getName(), "setTermAsContext");
                }
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "setTermAsContext", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsContext(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsContext";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermAsContext");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermAsContext");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsContext");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermAsContext");
            if (requestBody != null) {
                handler.clearTermAsContext(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsContext(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermAsContext", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineObject(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setTermAsSpineObject");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineObject");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setTermAsSpineObject");
            if (requestBody != null) {
                handler.setTermAsSpineObject(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsSpineObject(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineObject(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsSpineObject";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermAsSpineObject");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermAsSpineObject");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineObject");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermAsSpineObject");
            if (requestBody != null) {
                handler.clearTermAsSpineObject(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsSpineObject(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermAsSpineObject", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsSpineAttribute(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setTermAsSpineAttribute");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsSpineAttribute");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setTermAsSpineAttribute");
            if (requestBody != null) {
                handler.setTermAsSpineAttribute(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsSpineAttribute(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsSpineAttribute(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsSpineAttribute";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermAsSpineAttribute");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermAsSpineAttribute");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsSpineAttribute");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermAsSpineAttribute");
            if (requestBody != null) {
                handler.clearTermAsSpineAttribute(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsSpineAttribute(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermAsSpineAttribute", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse setTermAsObjectIdentifier(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "setTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "setTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "setTermAsObjectIdentifier");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "setTermAsObjectIdentifier");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "setTermAsObjectIdentifier");
            if (requestBody != null) {
                handler.setTermAsObjectIdentifier(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.setTermAsObjectIdentifier(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "setTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse clearTermAsObjectIdentifier(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ClassificationRequestBody requestBody) {
        String methodName = "clearTermAsObjectIdentifier";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "clearTermAsObjectIdentifier");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "clearTermAsObjectIdentifier");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "clearTermAsObjectIdentifier");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "clearTermAsObjectIdentifier");
            if (requestBody != null) {
                handler.clearTermAsObjectIdentifier(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.clearTermAsObjectIdentifier(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "clearTermAsObjectIdentifier", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GlossaryTermElementResponse undoGlossaryTermUpdate(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "undoGlossaryTermUpdate";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "undoGlossaryTermUpdate");
        GlossaryTermElementResponse response = new GlossaryTermElementResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "undoGlossaryTermUpdate");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "undoGlossaryTermUpdate");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "undoGlossaryTermUpdate");
            if (requestBody != null) {
                response.setElement(handler.undoGlossaryTermUpdate(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing));
            } else {
                response.setElement(handler.undoGlossaryTermUpdate(userId, null, null, glossaryTermGUID, null, new Date(), forLineage, forDuplicateProcessing));
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "undoGlossaryTermUpdate", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse archiveGlossaryTerm(String serverName, String glossaryTermGUID, boolean forDuplicateProcessing, ArchiveRequestBody requestBody) {
        String methodName = "archiveGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "archiveGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "archiveGlossaryTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "archiveGlossaryTerm");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "archiveGlossaryTerm");
            if (requestBody != null) {
                handler.archiveGlossaryTerm(userId, null, null, glossaryTermGUID, null, requestBody.getElementProperties(), requestBody.getEffectiveTime(), forDuplicateProcessing);
            } else {
                handler.archiveGlossaryTerm(userId, null, null, glossaryTermGUID, null, null, null, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "archiveGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeGlossaryTerm(String serverName, String glossaryTermGUID, boolean forLineage, boolean forDuplicateProcessing, ReferenceableUpdateRequestBody requestBody) {
        String methodName = "removeGlossaryTerm";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "removeGlossaryTerm");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "removeGlossaryTerm");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeGlossaryTerm");
            GlossaryExchangeClient handler = instanceHandler.getGlossaryExchangeClient(userId, serverName, "removeGlossaryTerm");
            if (requestBody != null) {
                handler.removeGlossaryTerm(userId, null, null, glossaryTermGUID, null, requestBody.getEffectiveTime(), forLineage, forDuplicateProcessing);
            } else {
                handler.removeGlossaryTerm(userId, null, null, glossaryTermGUID, null, null, forLineage, forDuplicateProcessing);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "removeGlossaryTerm", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

