/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossarymanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.assetmanager.rest.GlossaryTermElementResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ArchiveRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ControlledGlossaryTermRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermActivityTypeListResponse;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermRelationshipStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermStatusListResponse;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.GlossaryTermStatusRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.ReferenceableUpdateRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.viewservices.glossarymanager.server.GlossaryManagerRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/glossary-manager"})
@Tag(name="API: Glossary Manager OMVS", description="The Glossary Manager OMVS enables the caller to create glossary terms and organize them into categories as part of a controlled workflow process.  It supports the editing glossary and multiple states.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/glossary-manager/overview/"))
public class GlossaryManagerResource {
    private final GlossaryManagerRESTServices restAPI = new GlossaryManagerRESTServices();

    @PostMapping(path={"/glossaries"})
    public GUIDResponse createGlossary(@PathVariable String serverName, @RequestBody ReferenceableRequestBody requestBody) {
        return this.restAPI.createGlossary(serverName, requestBody);
    }

    @PostMapping(path={"/glossaries/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryFromTemplate(@PathVariable String serverName, @PathVariable String templateGUID, @RequestParam(required=false, defaultValue="true") boolean deepCopy, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryFromTemplate(serverName, templateGUID, deepCopy, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/update"})
    public VoidResponse updateGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossary(serverName, glossaryGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/remove"})
    public VoidResponse removeGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossary(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-editing-glossary"})
    public VoidResponse setGlossaryAsEditingGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsEditingGlossary(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-editing-glossary/remove"})
    public VoidResponse clearGlossaryAsEditingGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsEditingGlossary(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-staging-glossary"})
    public VoidResponse setGlossaryAsStagingGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsStagingGlossary(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-staging-glossary/remove"})
    public VoidResponse clearGlossaryAsStagingGlossary(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsStagingGlossary(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy"})
    public VoidResponse setGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsTaxonomy(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-taxonomy/remove"})
    public VoidResponse clearGlossaryAsTaxonomy(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsTaxonomy(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical-vocabulary"})
    public VoidResponse setGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setGlossaryAsCanonical(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/is-canonical-vocabulary/remove"})
    public VoidResponse clearGlossaryAsCanonical(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearGlossaryAsCanonical(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories"})
    public GUIDResponse createGlossaryCategory(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean isRootCategory, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.createGlossaryCategory(serverName, glossaryGUID, isRootCategory, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/categories/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryCategoryFromTemplate(@PathVariable String serverName, @PathVariable String glossaryGUID, @PathVariable String templateGUID, @RequestBody TemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryCategoryFromTemplate(serverName, glossaryGUID, templateGUID, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/update"})
    public VoidResponse updateGlossaryCategory(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryCategory(serverName, glossaryCategoryGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}"})
    public VoidResponse setupCategoryParent(@PathVariable String serverName, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) RelationshipRequestBody requestBody) {
        return this.restAPI.setupCategoryParent(serverName, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryParentCategoryGUID}/subcategories/{glossaryChildCategoryGUID}/remove"})
    public VoidResponse clearCategoryParent(@PathVariable String serverName, @PathVariable String glossaryParentCategoryGUID, @PathVariable String glossaryChildCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearCategoryParent(serverName, glossaryParentCategoryGUID, glossaryChildCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/remove"})
    public VoidResponse removeGlossaryCategory(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossaryCategory(serverName, glossaryCategoryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @GetMapping(path={"/glossaries/terms/status-list"})
    public GlossaryTermStatusListResponse getGlossaryTermStatuses(@PathVariable String serverName) {
        return this.restAPI.getGlossaryTermStatuses(serverName);
    }

    @GetMapping(path={"/glossaries/terms/relationships/status-list"})
    public GlossaryTermRelationshipStatusListResponse getGlossaryTermRelationshipStatuses(@PathVariable String serverName) {
        return this.restAPI.getGlossaryTermRelationshipStatuses(serverName);
    }

    @GetMapping(path={"/glossaries/terms/activity-types"})
    public GlossaryTermActivityTypeListResponse getGlossaryTermActivityTypes(@PathVariable String serverName) {
        return this.restAPI.getGlossaryTermActivityTypes(serverName);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/new-controlled"})
    public GUIDResponse createControlledGlossaryTerm(@PathVariable String serverName, @PathVariable String glossaryGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ControlledGlossaryTermRequestBody requestBody) {
        return this.restAPI.createControlledGlossaryTerm(serverName, glossaryGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/{glossaryGUID}/terms/from-template/{templateGUID}"})
    public GUIDResponse createGlossaryTermFromTemplate(@PathVariable String serverName, @PathVariable String glossaryGUID, @PathVariable String templateGUID, @RequestParam(required=false, defaultValue="true") boolean deepCopy, @RequestParam(required=false, defaultValue="true") boolean templateSubstitute, @RequestBody GlossaryTemplateRequestBody requestBody) {
        return this.restAPI.createGlossaryTermFromTemplate(serverName, glossaryGUID, templateGUID, deepCopy, templateSubstitute, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/update"})
    public VoidResponse updateGlossaryTerm(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeUpdate, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryTerm(serverName, glossaryTermGUID, isMergeUpdate, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/status"})
    public VoidResponse updateGlossaryTermStatus(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody GlossaryTermStatusRequestBody requestBody) {
        return this.restAPI.updateGlossaryTermStatus(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/update/from-template"})
    public VoidResponse updateGlossaryTermFromTemplate(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean isMergeClassifications, @RequestParam(required=false, defaultValue="false") boolean isMergeProperties, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.updateGlossaryTermFromTemplate(serverName, glossaryTermGUID, isMergeClassifications, isMergeProperties, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/move"})
    public VoidResponse moveGlossaryTerm(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.moveGlossaryTerm(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}"})
    public VoidResponse setupTermCategory(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupTermCategory(serverName, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/categories/{glossaryCategoryGUID}/terms/{glossaryTermGUID}/remove"})
    public VoidResponse clearTermCategory(@PathVariable String serverName, @PathVariable String glossaryCategoryGUID, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearTermCategory(serverName, glossaryCategoryGUID, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @GetMapping(path={"/glossaries/terms/relationships/type-names"})
    public NameListResponse getTermRelationshipTypeNames(@PathVariable String serverName) {
        return this.restAPI.getTermRelationshipTypeNames(serverName);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}"})
    public VoidResponse setupTermRelationship(@PathVariable String serverName, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.setupTermRelationship(serverName, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/update"})
    public VoidResponse updateTermRelationship(@PathVariable String serverName, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody RelationshipRequestBody requestBody) {
        return this.restAPI.updateTermRelationship(serverName, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermOneGUID}/relationships/{relationshipTypeName}/terms/{glossaryTermTwoGUID}/remove"})
    public VoidResponse clearTermRelationship(@PathVariable String serverName, @PathVariable String glossaryTermOneGUID, @PathVariable String relationshipTypeName, @PathVariable String glossaryTermTwoGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.clearTermRelationship(serverName, glossaryTermOneGUID, relationshipTypeName, glossaryTermTwoGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept"})
    public VoidResponse setTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsAbstractConcept(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-abstract-concept/remove"})
    public VoidResponse clearTermAsAbstractConcept(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsAbstractConcept(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-field"})
    public VoidResponse setTermAsDataField(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsDataField(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-field/remove"})
    public VoidResponse clearTermAsDataField(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsDataField(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value"})
    public VoidResponse setTermAsDataValue(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsDataValue(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-data-value/remove"})
    public VoidResponse clearTermAsDataValue(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsDataValue(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity"})
    public VoidResponse setTermAsActivity(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsActivity(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-activity/remove"})
    public VoidResponse clearTermAsActivity(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsActivity(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition"})
    public VoidResponse setTermAsContext(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsContext(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-context-definition/remove"})
    public VoidResponse clearTermAsContext(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsContext(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object"})
    public VoidResponse setTermAsSpineObject(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsSpineObject(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-object/remove"})
    public VoidResponse clearTermAsSpineObject(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsSpineObject(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute"})
    public VoidResponse setTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsSpineAttribute(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-spine-attribute/remove"})
    public VoidResponse clearTermAsSpineAttribute(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsSpineAttribute(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier"})
    public VoidResponse setTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.setTermAsObjectIdentifier(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/is-object-identifier/remove"})
    public VoidResponse clearTermAsObjectIdentifier(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ClassificationRequestBody requestBody) {
        return this.restAPI.clearTermAsObjectIdentifier(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/undo"})
    public GlossaryTermElementResponse undoGlossaryTermUpdate(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.undoGlossaryTermUpdate(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/archive"})
    public VoidResponse archiveGlossaryTerm(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ArchiveRequestBody requestBody) {
        return this.restAPI.archiveGlossaryTerm(serverName, glossaryTermGUID, forDuplicateProcessing, requestBody);
    }

    @PostMapping(path={"/glossaries/terms/{glossaryTermGUID}/remove"})
    public VoidResponse removeGlossaryTerm(@PathVariable String serverName, @PathVariable String glossaryTermGUID, @RequestParam(required=false, defaultValue="false") boolean forLineage, @RequestParam(required=false, defaultValue="false") boolean forDuplicateProcessing, @RequestBody(required=false) ReferenceableUpdateRequestBody requestBody) {
        return this.restAPI.removeGlossaryTerm(serverName, glossaryTermGUID, forLineage, forDuplicateProcessing, requestBody);
    }
}

