/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.glossaryview.client;

import org.odpi.openmetadata.accessservices.glossaryview.client.GlossaryViewClientExceptionHandler;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryViewEntityDetailResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCRESTClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;

class OmasClient
extends FFDCRESTClient {
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private GlossaryViewClientExceptionHandler exceptionHandler = new GlossaryViewClientExceptionHandler();

    protected OmasClient(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
    }

    protected OmasClient(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL, userId, password);
    }

    protected GlossaryViewEntityDetailResponse getSingleEntityResponse(String methodName, String path, String serverName, String userId, String entityGUID) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, "entityGUID", methodName);
        GlossaryViewEntityDetailResponse response = (GlossaryViewEntityDetailResponse)this.callGetRESTCall(methodName, GlossaryViewEntityDetailResponse.class, this.serverPlatformURLRoot + path, new Object[]{serverName, userId, entityGUID});
        this.exceptionHandler.detectAndThrowGlossaryViewOmasException(methodName, response);
        return response;
    }

    protected GlossaryViewEntityDetailResponse getMultipleRelatedEntitiesPagedResponse(String methodName, String path, String serverName, String userId, String entityGUID, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(entityGUID, "entityGUID", methodName);
        GlossaryViewEntityDetailResponse response = (GlossaryViewEntityDetailResponse)this.callGetRESTCall(methodName, GlossaryViewEntityDetailResponse.class, this.serverPlatformURLRoot + path, new Object[]{serverName, userId, entityGUID, from, size});
        this.exceptionHandler.detectAndThrowGlossaryViewOmasException(methodName, response);
        return response;
    }

    protected GlossaryViewEntityDetailResponse getMultipleEntitiesPagedResponse(String methodName, String path, String serverName, String userId, Integer from, Integer size) throws PropertyServerException, org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException, GlossaryViewOmasException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        GlossaryViewEntityDetailResponse response = (GlossaryViewEntityDetailResponse)this.callGetRESTCall(methodName, GlossaryViewEntityDetailResponse.class, this.serverPlatformURLRoot + path, new Object[]{serverName, userId, from, size});
        this.exceptionHandler.detectAndThrowGlossaryViewOmasException(methodName, response);
        return response;
    }
}

